/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.stack;

import gregtech.api.unification.stack.EmptyVariantMap;
import gregtech.api.unification.stack.UnmodifiableSetViewVariantMap;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ItemVariantMap<E> {
    public boolean hasNonWildcardEntry();

    public boolean has(short var1);

    @Nullable
    public E get(short var1);

    default public boolean isEmpty() {
        return !this.hasWildcardEntry() && !this.hasNonWildcardEntry();
    }

    default public boolean hasWildcardEntry() {
        return this.has((short)Short.MAX_VALUE);
    }

    default public boolean has(@NotNull ItemStack stack) {
        return this.has((short)stack.func_77952_i());
    }

    @Nullable
    default public E get(@NotNull ItemStack stack) {
        return this.get((short)stack.func_77952_i());
    }

    @NotNull
    public static <E> ItemVariantMap<Set<E>> unmodifiableSetView(@NotNull ItemVariantMap<? extends Set<E>> map) {
        return new UnmodifiableSetViewVariantMap(map);
    }

    @NotNull
    public static <E> ItemVariantMap<E> empty() {
        return EmptyVariantMap.INSTANCE;
    }

    public static interface Mutable<E>
    extends ItemVariantMap<E> {
        public void clear();

        @Nullable
        public E put(short var1, @Nullable E var2);

        @Nullable
        default public E put(@NotNull ItemStack stack, @Nullable E e) {
            return this.put((short)stack.func_77952_i(), e);
        }
    }
}

