/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import forestry.modules.ModuleHelper;
import gregtech.api.util.ModIncompatibilityException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Mods {
    AdvancedRocketry("advancedrocketry"),
    AppliedEnergistics2("appliedenergistics2"),
    Baubles("baubles"),
    BinnieCore("binniecore"),
    BiomesOPlenty("biomesoplenty"),
    BuildCraftCore("buildcraftcore"),
    Chisel("chisel"),
    CoFHCore("cofhcore"),
    CTM("ctm"),
    CubicChunks("cubicchunks"),
    CraftTweaker("crafttweaker"),
    EnderCore("endercore"),
    EnderIO("enderio"),
    ExtraBees("extrabees"),
    ExtraTrees("extratrees"),
    ExtraUtilities2("extrautils2"),
    Forestry("forestry"),
    ForestryApiculture("forestry", Mods.forestryModule("apiculture")),
    ForestryArboriculture("forestry", Mods.forestryModule("arboriculture")),
    ForestryLepidopterology("forestry", Mods.forestryModule("lepidopterology")),
    GalacticraftCore("galacticraftcore"),
    Genetics("genetics"),
    GregTech("gregtech"),
    GregTechFoodOption("gregtechfoodoption"),
    GroovyScript("groovyscript"),
    GTCE2OC("gtce2oc"),
    HWYLA("hwyla"),
    ImmersiveEngineering("immersiveengineering"),
    IndustrialCraft2("ic2"),
    InventoryTweaks("inventorytweaks"),
    JourneyMap("journeymap"),
    JustEnoughItems("jei"),
    MagicBees("magicbees"),
    Nothirium("nothirium"),
    NuclearCraft("nuclearcraft", Mods.versionExcludes("2o")),
    NuclearCraftOverhauled("nuclearcraft", Mods.versionContains("2o")),
    OpenComputers("opencomputers"),
    ProjectRedCore("projred-core"),
    Railcraft("railcraft"),
    RefinedStorage("refinedstorage"),
    TechReborn("techreborn"),
    TheOneProbe("theoneprobe"),
    TinkersConstruct("tconstruct"),
    TOPAddons("topaddons"),
    VoxelMap("voxelmap"),
    XaerosMinimap("xaerominimap"),
    Vintagium("vintagium"),
    Alfheim("alfheim"),
    Optifine(null){

        @Override
        public boolean isModLoaded() {
            if (this.modLoaded == null) {
                try {
                    Class<?> c = Class.forName("net.optifine.shaders.Shaders");
                    Field f = c.getDeclaredField("shaderPackLoaded");
                    f.setAccessible(true);
                    this.modLoaded = f.getBoolean(null);
                }
                catch (Exception ignored) {
                    this.modLoaded = false;
                }
            }
            return this.modLoaded;
        }
    };

    private final String ID;
    private final Function<Mods, Boolean> extraCheck;
    protected Boolean modLoaded;

    private Mods(String ID) {
        this.ID = ID;
        this.extraCheck = null;
    }

    private Mods(String ID, Function<Mods, Boolean> extraCheck) {
        this.ID = ID;
        this.extraCheck = extraCheck;
    }

    public boolean isModLoaded() {
        if (this.modLoaded == null) {
            this.modLoaded = Loader.isModLoaded((String)this.ID);
            if (this.modLoaded.booleanValue() && this.extraCheck != null && !this.extraCheck.apply(this).booleanValue()) {
                this.modLoaded = false;
            }
        }
        return this.modLoaded;
    }

    public void throwIncompatibilityIfLoaded(String ... customMessages) {
        if (this.isModLoaded()) {
            String modName = TextFormatting.BOLD + this.ID + TextFormatting.RESET;
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(modName + " mod detected, this mod is incompatible with GregTech CE Unofficial.");
            messages.addAll(Arrays.asList(customMessages));
            if (FMLLaunchHandler.side() == Side.SERVER) {
                throw new RuntimeException(String.join((CharSequence)",", messages));
            }
            Mods.throwClientIncompatibility(messages);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void throwClientIncompatibility(List<String> messages) {
        throw new ModIncompatibilityException(messages);
    }

    public ItemStack getItem(@NotNull String name) {
        return this.getItem(name, 0, 1, null);
    }

    @NotNull
    public ItemStack getItem(@NotNull String name, int meta) {
        return this.getItem(name, meta, 1, null);
    }

    @NotNull
    public ItemStack getItem(@NotNull String name, int meta, int amount) {
        return this.getItem(name, meta, amount, null);
    }

    @NotNull
    public ItemStack getItem(@NotNull String name, int meta, int amount, @Nullable String nbt) {
        if (!this.isModLoaded()) {
            return ItemStack.field_190927_a;
        }
        return GameRegistry.makeItemStack((String)(this.ID + ":" + name), (int)meta, (int)amount, (String)nbt);
    }

    private static Function<Mods, Boolean> versionContains(String versionPart) {
        return mod -> {
            if (mod.ID == null) {
                return false;
            }
            if (!mod.isModLoaded()) {
                return false;
            }
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(mod.ID);
            if (container == null) {
                return false;
            }
            return container.getVersion().contains(versionPart);
        };
    }

    private static Function<Mods, Boolean> versionExcludes(String versionPart) {
        return mod -> {
            if (mod.ID == null) {
                return false;
            }
            if (!mod.isModLoaded()) {
                return false;
            }
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(mod.ID);
            if (container == null) {
                return false;
            }
            return !container.getVersion().contains(versionPart);
        };
    }

    private static Function<Mods, Boolean> forestryModule(String moduleID) {
        if (Forestry.isModLoaded()) {
            return mod -> ModuleHelper.isEnabled((String)moduleID);
        }
        return $ -> false;
    }

    public static class Names {
        public static final String ADVANCED_ROCKETRY = "advancedrocketry";
        public static final String APPLIED_ENERGISTICS2 = "appliedenergistics2";
        public static final String BAUBLES = "baubles";
        public static final String BINNIE_CORE = "binniecore";
        public static final String BIOMES_O_PLENTY = "biomesoplenty";
        public static final String BUILD_CRAFT_CORE = "buildcraftcore";
        public static final String CHISEL = "chisel";
        public static final String COFH_CORE = "cofhcore";
        public static final String CONNECTED_TEXTURES_MOD = "ctm";
        public static final String CUBIC_CHUNKS = "cubicchunks";
        public static final String CRAFT_TWEAKER = "crafttweaker";
        public static final String ENDER_CORE = "endercore";
        public static final String ENDER_IO = "enderio";
        public static final String EXTRA_BEES = "extrabees";
        public static final String EXTRA_TREES = "extratrees";
        public static final String EXTRA_UTILITIES2 = "extrautils2";
        public static final String FORESTRY = "forestry";
        public static final String FORESTRY_APICULTURE = "apiculture";
        public static final String FORESTRY_ARBORICULTURE = "arboriculture";
        public static final String FORESTRY_LEPIDOPTEROLOGY = "lepidopterology";
        public static final String GALACTICRAFT_CORE = "galacticraftcore";
        public static final String GENETICS = "genetics";
        public static final String GREGTECH = "gregtech";
        public static final String GREGTECH_FOOD_OPTION = "gregtechfoodoption";
        public static final String GROOVY_SCRIPT = "groovyscript";
        public static final String GTCE_2_OC = "gtce2oc";
        public static final String HWYLA = "hwyla";
        public static final String IMMERSIVE_ENGINEERING = "immersiveengineering";
        public static final String INDUSTRIAL_CRAFT2 = "ic2";
        public static final String INVENTORY_TWEAKS = "inventorytweaks";
        public static final String JOURNEY_MAP = "journeymap";
        public static final String JUST_ENOUGH_ITEMS = "jei";
        public static final String MAGIC_BEES = "magicbees";
        public static final String NOTHIRIUM = "nothirium";
        public static final String NUCLEAR_CRAFT = "nuclearcraft";
        public static final String OPEN_COMPUTERS = "opencomputers";
        public static final String PROJECT_RED_CORE = "projred-core";
        public static final String RAILCRAFT = "railcraft";
        public static final String REFINED_STORAGE = "refinedstorage";
        public static final String TECH_REBORN = "techreborn";
        public static final String THE_ONE_PROBE = "theoneprobe";
        public static final String TINKERS_CONSTRUCT = "tconstruct";
        public static final String TOP_ADDONS = "topaddons";
        public static final String VOXEL_MAP = "voxelmap";
        public static final String XAEROS_MINIMAP = "xaerominimap";
        public static final String VINTAGIUM = "vintagium";
        public static final String ALFHEIM = "alfheim";
    }
}

