/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.ItemStackHashStrategy;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class OverlayedItemHandler {
    private final OverlayedItemHandlerSlot[] originalSlots;
    private final OverlayedItemHandlerSlot[] slots;
    private final IItemHandler overlayedHandler;

    public OverlayedItemHandler(@NotNull IItemHandler toOverlay) {
        this.slots = new OverlayedItemHandlerSlot[toOverlay.getSlots()];
        this.originalSlots = new OverlayedItemHandlerSlot[toOverlay.getSlots()];
        this.overlayedHandler = toOverlay;
    }

    public void reset() {
        for (int i = 0; i < this.originalSlots.length; ++i) {
            if (this.originalSlots[i] == null) continue;
            this.slots[i] = this.originalSlots[i].copy();
        }
    }

    public int getSlots() {
        return this.overlayedHandler.getSlots();
    }

    private void initSlot(int slot) {
        if (this.originalSlots[slot] == null) {
            ItemStack stackToMirror = this.overlayedHandler.getStackInSlot(slot);
            int slotLimit = this.overlayedHandler.getSlotLimit(slot);
            this.originalSlots[slot] = new OverlayedItemHandlerSlot(stackToMirror, slotLimit);
            this.slots[slot] = new OverlayedItemHandlerSlot(stackToMirror, slotLimit);
        }
    }

    public int insertStackedItemStack(@NotNull ItemStack stack, int amountToInsert) {
        int insertedAmount;
        int canInsertUpTo;
        int lastKnownPopulatedSlot = 0;
        int i = 0;
        while (i < this.slots.length) {
            this.initSlot(i);
            ItemStack slotKey = this.slots[i].getItemStack();
            if ((slotKey.func_190926_b() || ItemStackHashStrategy.comparingAllButCount().equals(slotKey, stack)) && (canInsertUpTo = this.slots[i].getSlotLimit() - this.slots[i].getCount()) > 0) {
                insertedAmount = Math.min(canInsertUpTo, amountToInsert);
                this.slots[i].setItemStack(stack.func_77946_l());
                this.slots[i].setCount(this.slots[i].getCount() + insertedAmount);
                amountToInsert -= insertedAmount;
            }
            lastKnownPopulatedSlot = i++;
            if (amountToInsert != 0) continue;
            return 0;
        }
        if (amountToInsert > 0) {
            for (i = lastKnownPopulatedSlot + 1; i < this.slots.length; ++i) {
                OverlayedItemHandlerSlot slot = this.slots[i];
                if (!slot.getItemStack().func_190926_b()) continue;
                canInsertUpTo = Math.min(stack.func_77976_d(), slot.getSlotLimit());
                if (canInsertUpTo > 0) {
                    insertedAmount = Math.min(canInsertUpTo, amountToInsert);
                    slot.setItemStack(stack.func_77946_l());
                    slot.setCount(insertedAmount);
                    amountToInsert -= insertedAmount;
                }
                if (amountToInsert != 0) continue;
                return 0;
            }
        }
        return amountToInsert;
    }

    private static class OverlayedItemHandlerSlot {
        private ItemStack itemStack = ItemStack.field_190927_a;
        private int count = 0;
        private int slotLimit;

        protected OverlayedItemHandlerSlot(@NotNull ItemStack stackToMirror, int slotLimit) {
            if (!stackToMirror.func_190926_b()) {
                this.itemStack = stackToMirror.func_77946_l();
                this.count = stackToMirror.func_190916_E();
                this.slotLimit = Math.min(this.itemStack.func_77976_d(), slotLimit);
            } else {
                this.slotLimit = slotLimit;
            }
        }

        protected OverlayedItemHandlerSlot(@NotNull ItemStack itemStack, int slotLimit, int count) {
            this.itemStack = itemStack;
            this.count = count;
            this.slotLimit = slotLimit;
        }

        public int getSlotLimit() {
            return this.slotLimit;
        }

        public int getCount() {
            return this.count;
        }

        @NotNull
        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public void setItemStack(@NotNull ItemStack itemStack) {
            if (!ItemStackHashStrategy.comparingAllButCount().equals(this.itemStack, itemStack)) {
                this.itemStack = itemStack;
                this.slotLimit = Math.min(itemStack.func_77976_d(), this.slotLimit);
            }
        }

        public void setCount(int count) {
            this.count = count;
        }

        @NotNull
        OverlayedItemHandlerSlot copy() {
            return new OverlayedItemHandlerSlot(this.itemStack, this.slotLimit, this.count);
        }
    }
}

