/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.shape;

import com.google.gson.JsonObject;
import gregtech.api.worldgen.config.OreConfigUtils;
import gregtech.api.worldgen.shape.IBlockGeneratorAccess;
import gregtech.api.worldgen.shape.ShapeGenerator;
import java.util.Random;
import net.minecraft.util.math.Vec3i;

public class EllipsoidGenerator
extends ShapeGenerator {
    private int radiusMin;
    private int radiusMax;

    @Override
    public void loadFromConfig(JsonObject object) {
        int[] data = OreConfigUtils.getIntRange(object.get("radius"));
        this.radiusMin = data[0];
        this.radiusMax = data[1];
    }

    public int getYRadius() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Vec3i getMaxSize() {
        return new Vec3i(this.radiusMax * 2, this.radiusMax, this.radiusMax * 2);
    }

    @Override
    public void generate(Random gridRandom, IBlockGeneratorAccess blockAccess) {
        int a = this.radiusMin == this.radiusMax ? this.radiusMax : gridRandom.nextInt(this.radiusMax - this.radiusMin) + this.radiusMin;
        int b = this.radiusMin == this.radiusMax ? this.radiusMax / 2 : (gridRandom.nextInt(this.radiusMax - this.radiusMin) + this.radiusMin) / 2;
        int c = this.radiusMin == this.radiusMax ? this.radiusMax : gridRandom.nextInt(this.radiusMax - this.radiusMin) + this.radiusMin;
        int ab2 = a * a * b * b;
        int ac2 = a * a * c * c;
        int bc2 = b * b * c * c;
        int abc2 = ab2 * c * c;
        int max = Math.max(a, Math.max(b, c));
        int yMax = Math.min(max, this.getYRadius());
        for (int x = -max; x <= max; ++x) {
            int xr = bc2 * x * x;
            if (xr > abc2) continue;
            for (int y = -yMax; y <= yMax; ++y) {
                int yr = xr + ac2 * y * y + ab2;
                if (yr > abc2) continue;
                for (int z = -max; z <= max; ++z) {
                    int zr = yr + ab2 * z * z;
                    if (zr > abc2) continue;
                    this.generateBlock(x, y, z, blockAccess);
                }
            }
        }
    }

    public void generateBlock(int x, int y, int z, IBlockGeneratorAccess blockAccess) {
        blockAccess.generateBlock(x, y, z);
    }
}

