/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.modelfactories;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="gregtech", value={Side.CLIENT})
public class MaterialBlockModelLoader {
    private static final Table<MaterialIconType, MaterialIconSet, Entry> ENTRIES = HashBasedTable.create();
    private static final Map<ModelResourceLocation, IModel> UNBAKED_MODEL_CACHE = new Object2ObjectOpenHashMap();

    public static ModelResourceLocation registerBlockModel(MaterialIconType iconType, MaterialIconSet iconSet) {
        return MaterialBlockModelLoader.register((MaterialIconType)iconType, (MaterialIconSet)iconSet).blockModelId;
    }

    public static ModelResourceLocation registerItemModel(MaterialIconType iconType, MaterialIconSet iconSet) {
        return MaterialBlockModelLoader.register((MaterialIconType)iconType, (MaterialIconSet)iconSet).itemModelId;
    }

    private static Entry register(MaterialIconType iconType, MaterialIconSet iconSet) {
        Entry e = (Entry)ENTRIES.get((Object)iconType, (Object)iconSet);
        if (e == null) {
            e = new Entry(iconType, iconSet);
            ENTRIES.put((Object)iconType, (Object)iconSet, (Object)e);
        }
        return e;
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        UNBAKED_MODEL_CACHE.clear();
        for (Entry e : ENTRIES.values()) {
            MaterialBlockModelLoader.loadModel(event, e.getBlockModelLocation(), e.blockModelId);
            MaterialBlockModelLoader.loadModel(event, e.getItemModelLocation(), e.itemModelId);
        }
    }

    private static void loadModel(TextureStitchEvent.Pre event, ResourceLocation modelLocation, ModelResourceLocation modelId) {
        IModel model;
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
        }
        catch (Exception e) {
            GTLog.logger.error("Failed to load material model {}:", (Object)modelLocation, (Object)e);
            UNBAKED_MODEL_CACHE.put(modelId, ModelLoaderRegistry.getMissingModel());
            return;
        }
        for (ResourceLocation texture : model.getTextures()) {
            event.getMap().func_174942_a(texture);
        }
        UNBAKED_MODEL_CACHE.put(modelId, model);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        for (Map.Entry<ModelResourceLocation, IModel> e : UNBAKED_MODEL_CACHE.entrySet()) {
            IBakedModel baked = e.getValue().bake(e.getValue().getDefaultState(), DefaultVertexFormats.field_176599_b, t -> Minecraft.func_71410_x().func_147117_R().func_110572_b(t.toString()));
            event.getModelRegistry().func_82595_a((Object)e.getKey(), (Object)baked);
        }
        UNBAKED_MODEL_CACHE.clear();
    }

    private static final class Entry {
        final MaterialIconType iconType;
        final MaterialIconSet iconSet;
        final ModelResourceLocation blockModelId;
        final ModelResourceLocation itemModelId;

        Entry(MaterialIconType iconType, MaterialIconSet iconSet) {
            this.iconType = iconType;
            this.iconSet = iconSet;
            this.blockModelId = new ModelResourceLocation(GTUtility.gregtechId("material_" + iconType.name + "_" + iconSet.name), "normal");
            this.itemModelId = new ModelResourceLocation(GTUtility.gregtechId("material_" + iconType.name + "_" + iconSet.name), "inventory");
        }

        ResourceLocation getBlockModelLocation() {
            return this.iconType.getBlockModelPath(this.iconSet);
        }

        ResourceLocation getItemModelLocation() {
            ResourceLocation itemModelPath = this.iconType.getItemModelPath(this.iconSet);
            return new ResourceLocation(itemModelPath.func_110624_b(), "item/" + itemModelPath.func_110623_a());
        }
    }
}

