/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import codechicken.lib.vec.Vector3;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.client.particle.GTParticle;
import gregtech.client.renderer.IRenderSetup;
import gregtech.client.renderer.fx.LaserBeamRenderer;
import gregtech.client.utils.EffectRenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTLaserBeamParticle
extends GTParticle {
    @Nullable
    private final MetaTileEntity mte;
    @Nullable
    private ResourceLocation body;
    @Nullable
    private ResourceLocation head;
    private Vector3 direction;
    private float beamHeight = 0.075f;
    private float headWidth;
    private float alpha = 1.0f;
    private float emit;
    private boolean doubleVertical;
    private int activeTime;
    private final int fadeInTime;
    private static final IRenderSetup SETUP = new IRenderSetup(){
        float lastBrightnessX;
        float lastBrightnessY;

        @Override
        public void preDraw(@NotNull BufferBuilder buffer) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            this.lastBrightnessX = OpenGlHelper.lastBrightnessX;
            this.lastBrightnessY = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179129_p();
        }

        @Override
        public void postDraw(@NotNull BufferBuilder buffer) {
            GlStateManager.func_179089_o();
            GlStateManager.func_179101_C();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.lastBrightnessX, (float)this.lastBrightnessY);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    };

    public GTLaserBeamParticle(@Nullable MetaTileEntity mte, @NotNull Vector3 startPos, @NotNull Vector3 endPos) {
        this(mte, startPos, endPos, 0);
    }

    public GTLaserBeamParticle(@Nullable MetaTileEntity mte, @NotNull Vector3 startPos, @NotNull Vector3 endPos, int fadeInTime) {
        super(startPos.x, startPos.y, startPos.z);
        this.mte = mte;
        this.direction = endPos.copy().subtract(startPos);
        this.setRenderRange(64.0);
        this.fadeInTime = fadeInTime;
    }

    @Override
    public boolean shouldRender(@NotNull EffectRenderContext context) {
        double renderRange = this.getSquaredRenderRange();
        if (renderRange < 0.0) {
            return true;
        }
        Vec3d eyePos = context.renderViewEntity().func_174824_e(context.partialTicks());
        return eyePos.func_186679_c(this.posX, this.posY, this.posZ) <= renderRange || eyePos.func_186679_c(this.posX + this.direction.x, this.posY + this.direction.y, this.posZ + this.direction.z) <= renderRange;
    }

    public GTLaserBeamParticle setBody(@Nullable ResourceLocation body) {
        this.body = body;
        return this;
    }

    public GTLaserBeamParticle setHead(@Nullable ResourceLocation head) {
        this.head = head;
        return this;
    }

    public GTLaserBeamParticle setStartPos(@NotNull Vector3 startPos) {
        this.direction.add(this.posX, this.posY, this.posZ).subtract(startPos);
        return this;
    }

    public GTLaserBeamParticle setEndPos(@NotNull Vector3 endPos) {
        this.direction = endPos.copy().subtract(this.posX, this.posY, this.posZ);
        return this;
    }

    public GTLaserBeamParticle setBeamHeight(float beamHeight) {
        this.beamHeight = beamHeight;
        return this;
    }

    public GTLaserBeamParticle setHeadWidth(float headWidth) {
        this.headWidth = headWidth;
        return this;
    }

    public GTLaserBeamParticle setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getAlpha(float partialTicks) {
        if (this.fadeInTime > this.activeTime) {
            return (float)((double)this.alpha * MathHelper.func_151238_b((double)((double)this.activeTime / (double)this.fadeInTime), (double)((double)(this.activeTime + 1) / (double)this.fadeInTime), (double)partialTicks));
        }
        return this.alpha;
    }

    public GTLaserBeamParticle setEmit(float emit) {
        this.emit = emit;
        return this;
    }

    public GTLaserBeamParticle setDoubleVertical(boolean doubleVertical) {
        this.doubleVertical = doubleVertical;
        return this;
    }

    @Override
    public boolean shouldDisableDepth() {
        return true;
    }

    @Override
    public void onUpdate() {
        if (this.mte == null || this.mte.isValid() && this.mte.getWorld().func_175668_a(this.mte.getPos(), false) && this.mte.getWorld().func_175625_s(this.mte.getPos()) == this.mte.getHolder()) {
            ++this.activeTime;
        } else {
            this.setExpired();
        }
    }

    @Override
    public void renderParticle(@NotNull BufferBuilder buffer, @NotNull EffectRenderContext context) {
        GlStateManager.func_179137_b((double)(this.posX - context.cameraX()), (double)(this.posY - context.cameraY()), (double)(this.posZ - context.cameraZ()));
        Vector3 cameraDirection = null;
        if (!this.doubleVertical) {
            Vec3d positionEyes = context.renderViewEntity().func_174824_e(context.partialTicks());
            cameraDirection = new Vector3(this.posX, this.posY, this.posZ).subtract(new Vector3(positionEyes));
        }
        TextureManager renderEngine = Minecraft.func_71410_x().func_175598_ae().field_78724_e;
        ITextureObject bodyTexture = null;
        if (this.body != null && (bodyTexture = renderEngine.func_110581_b(this.body)) == null) {
            bodyTexture = new SimpleTexture(this.body);
            renderEngine.func_110579_a(this.body, bodyTexture);
        }
        ITextureObject headTexture = null;
        if (this.head != null && (headTexture = renderEngine.func_110581_b(this.head)) == null) {
            headTexture = new SimpleTexture(this.head);
            renderEngine.func_110579_a(this.head, headTexture);
        }
        float offset = -this.emit * ((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + context.partialTicks());
        LaserBeamRenderer.renderRawBeam(bodyTexture == null ? -1 : bodyTexture.func_110552_b(), headTexture == null ? -1 : headTexture.func_110552_b(), this.direction, cameraDirection, this.beamHeight, this.headWidth, this.getAlpha(context.partialTicks()), offset);
        GlStateManager.func_179137_b((double)(context.cameraX() - this.posX), (double)(context.cameraY() - this.posY), (double)(context.cameraZ() - this.posZ));
    }

    @Override
    @Nullable
    public IRenderSetup getRenderSetup() {
        return SETUP;
    }

    public String toString() {
        return "GTLaserBeamParticle{mte=" + this.mte + ", body=" + this.body + ", head=" + this.head + ", direction=" + this.direction + ", beamHeight=" + this.beamHeight + ", headWidth=" + this.headWidth + ", alpha=" + this.alpha + ", emit=" + this.emit + ", doubleVertical=" + this.doubleVertical + ", posX=" + this.posX + ", posY=" + this.posY + ", posZ=" + this.posZ + '}';
    }
}

