/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.cube;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrientedOverlayRenderer
implements ICubeRenderer {
    protected final String basePath;
    @SideOnly(value=Side.CLIENT)
    public Map<OverlayFace, ActivePredicate> sprites;

    public OrientedOverlayRenderer(@NotNull String basePath) {
        this.basePath = basePath;
        Textures.CUBE_RENDERER_REGISTRY.put(basePath, this);
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.sprites = new EnumMap<OverlayFace, ActivePredicate>(OverlayFace.class);
        String modID = "gregtech";
        String basePath = this.basePath;
        String[] split = this.basePath.split(":");
        if (split.length == 2) {
            modID = split[0];
            basePath = split[1];
        }
        boolean foundTexture = false;
        for (OverlayFace overlayFace : OverlayFace.VALUES) {
            String faceName = overlayFace.name().toLowerCase();
            String overlayPath = String.format("blocks/%s/overlay_%s", basePath, faceName);
            TextureAtlasSprite normalSprite = ICubeRenderer.getResource(textureMap, modID, overlayPath);
            if (normalSprite == null) continue;
            foundTexture = true;
            String active = String.format("%s_active", overlayPath);
            TextureAtlasSprite activeSprite = ICubeRenderer.getResource(textureMap, modID, active);
            if (activeSprite == null) {
                FMLClientHandler.instance().trackMissingTexture(new ResourceLocation(modID, "blocks/" + basePath + "/overlay_" + overlayFace.toString().toLowerCase() + "_active"));
                continue;
            }
            String paused = String.format("%s_paused", overlayPath);
            TextureAtlasSprite pausedSprite = ICubeRenderer.getResource(textureMap, modID, paused);
            TextureAtlasSprite normalSpriteEmissive = ICubeRenderer.getResource(textureMap, modID, overlayPath + "_emissive");
            TextureAtlasSprite activeSpriteEmissive = ICubeRenderer.getResource(textureMap, modID, active + "_emissive");
            TextureAtlasSprite pausedSpriteEmissive = ICubeRenderer.getResource(textureMap, modID, paused + "_emissive");
            this.sprites.put(overlayFace, new ActivePredicate(normalSprite, activeSprite, pausedSprite, normalSpriteEmissive, activeSpriteEmissive, pausedSpriteEmissive));
        }
        if (!foundTexture) {
            FMLClientHandler.instance().trackMissingTexture(new ResourceLocation(modID, "blocks/" + basePath + "/overlay_OVERLAY_FACE"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleSprite() {
        for (ActivePredicate predicate : this.sprites.values()) {
            TextureAtlasSprite sprite = predicate.getSprite(false, false);
            if (sprite == null) continue;
            return sprite;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOrientedState(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds, EnumFacing frontFacing, boolean isActive, boolean isWorkingEnabled) {
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            ActivePredicate predicate = this.sprites.get((Object)OverlayFace.bySide(renderSide, frontFacing));
            if (predicate == null) continue;
            TextureAtlasSprite renderSprite = predicate.getSprite(isActive, isWorkingEnabled);
            Matrix4 renderTranslation = translation.copy();
            Rotation rotation = this.getRotation(renderTranslation, renderSide, frontFacing);
            renderTranslation = RenderUtil.adjustTrans(renderTranslation, renderSide, 1);
            renderTranslation.apply((Transformation)rotation);
            Textures.renderFace(renderState, renderTranslation, (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{rotation}), renderSide, bounds, renderSprite, BlockRenderLayer.CUTOUT_MIPPED);
            TextureAtlasSprite emissiveSprite = predicate.getEmissiveSprite(isActive, isWorkingEnabled);
            if (emissiveSprite == null) continue;
            if (ConfigHolder.client.machinesEmissiveTextures) {
                IVertexOperation[] lightPipeline = (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new LightMapOperation(240, 240), rotation});
                Textures.renderFace(renderState, renderTranslation, lightPipeline, renderSide, bounds, emissiveSprite, BloomEffectUtil.getEffectiveBloomLayer());
                continue;
            }
            Textures.renderFace(renderState, renderTranslation, (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{rotation}), renderSide, bounds, emissiveSprite, BlockRenderLayer.CUTOUT_MIPPED);
        }
    }

    public Rotation getRotation(Matrix4 transformation, EnumFacing renderSide, EnumFacing frontFacing) {
        Rotation rotation = new Rotation(0.0, 0.0, 1.0, 0.0);
        if (renderSide.func_176740_k() == EnumFacing.Axis.Y) {
            if (frontFacing == EnumFacing.NORTH) {
                transformation.translate(1.0, 0.0, 1.0);
                rotation = new Rotation(Math.PI, 0.0, 1.0, 0.0);
            } else if (frontFacing == EnumFacing.EAST) {
                transformation.translate(0.0, 0.0, 1.0);
                rotation = new Rotation(1.5707963267948966, 0.0, 1.0, 0.0);
            } else if (frontFacing == EnumFacing.WEST) {
                transformation.translate(1.0, 0.0, 0.0);
                rotation = new Rotation(-1.5707963267948966, 0.0, 1.0, 0.0);
            }
        }
        return rotation;
    }

    public static enum OverlayFace {
        FRONT,
        BACK,
        TOP,
        BOTTOM,
        SIDE;

        public static final OverlayFace[] VALUES;

        public static OverlayFace bySide(EnumFacing side, EnumFacing frontFacing) {
            if (side == frontFacing) {
                return FRONT;
            }
            if (side.func_176734_d() == frontFacing) {
                return BACK;
            }
            if (side == EnumFacing.UP) {
                return TOP;
            }
            if (side == EnumFacing.DOWN) {
                return BOTTOM;
            }
            return SIDE;
        }

        static {
            VALUES = OverlayFace.values();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ActivePredicate {
        private final TextureAtlasSprite normalSprite;
        private final TextureAtlasSprite activeSprite;
        private final TextureAtlasSprite pausedSprite;
        private final TextureAtlasSprite normalSpriteEmissive;
        private final TextureAtlasSprite activeSpriteEmissive;
        private final TextureAtlasSprite pausedSpriteEmissive;

        public ActivePredicate(@NotNull TextureAtlasSprite normalSprite, @NotNull TextureAtlasSprite activeSprite, @Nullable TextureAtlasSprite pausedSprite, @Nullable TextureAtlasSprite normalSpriteEmissive, @Nullable TextureAtlasSprite activeSpriteEmissive, @Nullable TextureAtlasSprite pausedSpriteEmissive) {
            this.normalSprite = normalSprite;
            this.activeSprite = activeSprite;
            this.pausedSprite = pausedSprite;
            this.normalSpriteEmissive = normalSpriteEmissive;
            this.activeSpriteEmissive = activeSpriteEmissive;
            this.pausedSpriteEmissive = pausedSpriteEmissive;
        }

        @Nullable
        public TextureAtlasSprite getSprite(boolean active, boolean workingEnabled) {
            if (active) {
                if (workingEnabled) {
                    return this.activeSprite;
                }
                if (this.pausedSprite != null) {
                    return this.pausedSprite;
                }
            }
            return this.normalSprite;
        }

        @Nullable
        public TextureAtlasSprite getEmissiveSprite(boolean active, boolean workingEnabled) {
            if (active) {
                if (workingEnabled) {
                    return this.activeSpriteEmissive;
                }
                if (this.pausedSpriteEmissive != null) {
                    return this.pausedSpriteEmissive;
                }
            }
            return this.normalSpriteEmissive;
        }
    }
}

