/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.custom;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.MetaTileEntityClipboard;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ClipboardRenderer
implements TextureUtils.IIconRegister {
    private static final Cuboid6 pageBox = new Cuboid6(0.1875, 0.015625, 0.015625, 0.8125, 0.890625, 0.01875);
    private static final Cuboid6 boardBox = new Cuboid6(0.171875, 0.0, 0.0, 0.828125, 0.953125, 0.015625);
    private static final Cuboid6 clipBox = new Cuboid6(0.359375, 0.921875, 0.015625, 0.640625, 0.96875, 0.025);
    private static final Cuboid6 graspBox = new Cuboid6(0.4375, 0.953125, 0.00625, 0.5625, 1.0, 0.021875);
    private static final List<EnumFacing> rotations = Arrays.asList(EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.EAST);
    @SideOnly(value=Side.CLIENT)
    private static HashMap<Cuboid6, TextureAtlasSprite> boxTextureMap;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[] textures;

    public ClipboardRenderer() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            boxTextureMap = new HashMap();
            this.textures = new TextureAtlasSprite[3];
        }
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.textures[0] = textureMap.func_174942_a(new ResourceLocation("gregtech:blocks/clipboard/wood"));
        boxTextureMap.put(boardBox, this.textures[0]);
        this.textures[1] = textureMap.func_174942_a(new ResourceLocation("gregtech:blocks/clipboard/clip"));
        boxTextureMap.put(clipBox, this.textures[1]);
        boxTextureMap.put(graspBox, this.textures[1]);
        this.textures[2] = textureMap.func_174942_a(new ResourceLocation("gregtech:blocks/clipboard/page"));
        boxTextureMap.put(pageBox, this.textures[2]);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBoard(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, EnumFacing rotation, MetaTileEntityClipboard clipboard, float partialTicks) {
        translation.translate(0.5, 0.5, 0.5);
        translation.rotate(Math.toRadians(90.0 * (double)rotations.indexOf(rotation)), Rotation.axes[1]);
        translation.translate(-0.5, -0.5, -0.5);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            boxTextureMap.forEach((box, sprite) -> Textures.renderFace(renderState, translation, pipeline, renderSide, box, sprite, null));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderGUI(double x, double y, double z, EnumFacing rotation, MetaTileEntityClipboard clipboard, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179137_b((double)0.5, (double)0.451, (double)0.5);
        GlStateManager.func_179114_b((float)((float)(90.0 * (double)rotations.indexOf(rotation))), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.468);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.875, (double)0.875, (double)0.875);
        if (clipboard.guiCache != null) {
            Pair<Double, Double> result = clipboard.checkLookingAt((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.01);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
            if (result == null) {
                clipboard.guiCache.drawScreen(0.0, 0.0, partialTicks);
            } else {
                clipboard.guiCache.drawScreen((Double)result.getKey(), (Double)result.getValue(), partialTicks);
            }
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.textures[0];
    }
}

