/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import appeng.items.misc.ItemEncodedPattern;
import gregtech.api.util.GTLog;
import gregtech.api.util.Mods;
import gregtech.api.util.world.DummyWorld;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemRenderCompat {
    @Nullable
    private static RepresentativeStackExtractor rsHandler;
    @Nullable
    private static RepresentativeStackExtractor ae2Handler;

    private ItemRenderCompat() {
    }

    @ApiStatus.Internal
    public static void init() {
        ae2Handler = AE2StackExtractor.create();
        rsHandler = RSStackExtractor.create();
    }

    @NotNull
    public static ItemStack getRepresentedStack(@NotNull ItemStack stack) {
        if (ae2Handler != null && ae2Handler.canHandleStack(stack)) {
            return ae2Handler.getActualStack(stack);
        }
        if (rsHandler != null && rsHandler.canHandleStack(stack)) {
            return rsHandler.getActualStack(stack);
        }
        return stack;
    }

    private static final class AE2StackExtractor
    implements RepresentativeStackExtractor {
        private AE2StackExtractor() {
        }

        @Nullable
        public static AE2StackExtractor create() {
            if (!Mods.AppliedEnergistics2.isModLoaded()) {
                return null;
            }
            GTLog.logger.info("AppliedEnergistics2 found; enabling render integration.");
            return new AE2StackExtractor();
        }

        @Override
        public boolean canHandleStack(@NotNull ItemStack stack) {
            return stack.func_77973_b() instanceof ItemEncodedPattern;
        }

        @Override
        @NotNull
        public ItemStack getActualStack(@NotNull ItemStack stack) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            Item item = stack.func_77973_b();
            if (item instanceof ItemEncodedPattern) {
                ItemEncodedPattern encodedPattern = (ItemEncodedPattern)item;
                return encodedPattern.getOutput(stack);
            }
            return stack;
        }
    }

    public static interface RepresentativeStackExtractor {
        public boolean canHandleStack(@NotNull ItemStack var1);

        @NotNull
        public ItemStack getActualStack(@NotNull ItemStack var1);
    }

    private static final class RSStackExtractor
    implements RepresentativeStackExtractor {
        private final MethodHandle getPatternFromCacheHandle;
        private final MethodHandle getOutputsHandle;
        private final Class<?> itemPatternClass;

        private RSStackExtractor(MethodHandle getPatternFromCacheHandle, MethodHandle getOutputsHandle, Class<?> itemPatternClass) {
            this.getPatternFromCacheHandle = getPatternFromCacheHandle;
            this.getOutputsHandle = getOutputsHandle;
            this.itemPatternClass = itemPatternClass;
        }

        @Nullable
        public static RSStackExtractor create() {
            Class<?> clazz;
            if (!Mods.RefinedStorage.isModLoaded()) {
                return null;
            }
            try {
                clazz = Class.forName("com.raoulvdberge.refinedstorage.item.ItemPattern");
                GTLog.logger.info("RefinedStorage found; enabling render integration.");
            }
            catch (ClassNotFoundException ignored) {
                GTLog.logger.error("RefinedStorage classes not found; skipping render integration.");
                return null;
            }
            try {
                Method method = clazz.getMethod("getPatternFromCache", World.class, ItemStack.class);
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                MethodHandle getPatternFromCacheHandle = lookup.unreflect(method);
                method = method.getReturnType().getMethod("getOutputs", new Class[0]);
                MethodHandle getOutputsHandle = lookup.unreflect(method);
                return new RSStackExtractor(getPatternFromCacheHandle, getOutputsHandle, clazz);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                GTLog.logger.error("Failed to enable RefinedStorage integration", (Throwable)e);
                return null;
            }
        }

        @Override
        public boolean canHandleStack(@NotNull ItemStack stack) {
            return this.itemPatternClass.isAssignableFrom(stack.func_77973_b().getClass());
        }

        @Override
        @NotNull
        public ItemStack getActualStack(@NotNull ItemStack stack) {
            List outputs;
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            try {
                Object craftingPattern = this.getPatternFromCacheHandle.invoke(DummyWorld.INSTANCE, stack);
                outputs = this.getOutputsHandle.invoke(craftingPattern);
            }
            catch (Throwable e) {
                GTLog.logger.error("Failed to obtain item from ItemPattern", e);
                return stack;
            }
            if (outputs.isEmpty()) {
                return stack;
            }
            return (ItemStack)outputs.get(0);
        }
    }
}

