/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.block.VariantActiveBlock;
import gregtech.api.block.VariantItemBlock;
import gregtech.api.unification.material.Materials;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityMultiSmelter;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockWireCoil
extends VariantActiveBlock<CoilType> {
    public BlockWireCoil() {
        super(Material.field_151573_f);
        this.func_149663_c("wire_coil");
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("wrench", 2);
        this.func_180632_j(this.getState(CoilType.CUPRONICKEL));
    }

    @Override
    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(@NotNull ItemStack itemStack, @Nullable World worldIn, @NotNull List<String> lines, @NotNull ITooltipFlag tooltipFlag) {
        super.func_190948_a(itemStack, worldIn, lines, tooltipFlag);
        VariantItemBlock itemBlock = (VariantItemBlock)itemStack.func_77973_b();
        IBlockState stackState = itemBlock.getBlockState(itemStack);
        CoilType coilType = (CoilType)this.getState(stackState);
        lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_heat", (Object[])new Object[]{coilType.coilTemperature}));
        if (TooltipHelper.isShiftDown()) {
            int coilTier = coilType.ordinal();
            lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_smelter", (Object[])new Object[0]));
            lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_parallel_smelter", (Object[])new Object[]{coilType.level * 32}));
            int EUt = MetaTileEntityMultiSmelter.getEUtForParallel(MetaTileEntityMultiSmelter.getMaxParallel(coilType.getLevel()), coilType.getEnergyDiscount());
            lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_energy_smelter", (Object[])new Object[]{EUt}));
            lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_pyro", (Object[])new Object[0]));
            lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_speed_pyro", (Object[])new Object[]{coilTier == 0 ? 75 : 50 * (coilTier + 1)}));
            lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_cracking", (Object[])new Object[0]));
            lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_energy_cracking", (Object[])new Object[]{100 - 10 * coilTier}));
        } else {
            lines.add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_extended_info", (Object[])new Object[0]));
        }
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    protected boolean isBloomEnabled(CoilType value) {
        return ConfigHolder.client.coilsActiveEmissiveTextures;
    }

    public static enum CoilType implements IStringSerializable,
    IHeatingCoilBlockStats
    {
        CUPRONICKEL("cupronickel", 1800, 1, 1, Materials.Cupronickel),
        KANTHAL("kanthal", 2700, 2, 1, Materials.Kanthal),
        NICHROME("nichrome", 3600, 2, 2, Materials.Nichrome),
        RTM_ALLOY("rtm_alloy", 4500, 4, 2, Materials.RTMAlloy),
        HSS_G("hss_g", 5400, 4, 4, Materials.HSSG),
        NAQUADAH("naquadah", 7200, 8, 4, Materials.Naquadah),
        TRINIUM("trinium", 9001, 8, 8, Materials.Trinium),
        TRITANIUM("tritanium", 10800, 16, 8, Materials.Tritanium);

        private final String name;
        private final int coilTemperature;
        private final int level;
        private final int energyDiscount;
        private final gregtech.api.unification.material.Material material;

        private CoilType(String name, int coilTemperature, int level, int energyDiscount, gregtech.api.unification.material.Material material) {
            this.name = name;
            this.coilTemperature = coilTemperature;
            this.level = level;
            this.energyDiscount = energyDiscount;
            this.material = material;
        }

        @NotNull
        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getCoilTemperature() {
            return this.coilTemperature;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public int getEnergyDiscount() {
            return this.energyDiscount;
        }

        @Override
        public int getTier() {
            return this.ordinal();
        }

        @Override
        @Nullable
        public gregtech.api.unification.material.Material getMaterial() {
            return this.material;
        }

        @NotNull
        public String toString() {
            return this.func_176610_l();
        }
    }
}

