/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.crafting;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.impl.ElectricItem;
import gregtech.api.items.toolitem.IGTTool;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jetbrains.annotations.NotNull;

public class ShapedOreEnergyTransferRecipe
extends ShapedOreRecipe {
    private final Predicate<ItemStack> chargePredicate;
    private final boolean transferMaxCharge;

    public ShapedOreEnergyTransferRecipe(ResourceLocation group, @NotNull ItemStack result, Predicate<ItemStack> chargePredicate, boolean overrideCharge, boolean transferMaxCharge, Object ... recipe) {
        super(group, result, CraftingHelper.parseShaped((Object[])recipe));
        this.chargePredicate = chargePredicate;
        this.transferMaxCharge = transferMaxCharge;
        if (overrideCharge) {
            this.fixOutputItemMaxCharge();
        }
    }

    private void fixOutputItemMaxCharge() {
        long totalMaxCharge = this.func_192400_c().stream().mapToLong(it -> Arrays.stream(it.func_193365_a()).filter(itemStack -> !(itemStack.func_77973_b() instanceof IGTTool)).map(stack -> (IElectricItem)stack.func_77946_l().getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)).filter(Objects::nonNull).mapToLong(IElectricItem::getMaxCharge).max().orElse(0L)).sum();
        IElectricItem electricItem = (IElectricItem)this.output.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (totalMaxCharge > 0L && electricItem instanceof ElectricItem) {
            ((ElectricItem)electricItem).setMaxChargeOverride(totalMaxCharge);
        }
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull InventoryCrafting inventoryCrafting) {
        ItemStack resultStack = super.func_77572_b(inventoryCrafting);
        ShapedOreEnergyTransferRecipe.chargeStackFromComponents(resultStack, (IInventory)inventoryCrafting, this.chargePredicate, this.transferMaxCharge);
        return resultStack;
    }

    public static void chargeStackFromComponents(ItemStack toolStack, IInventory ingredients, Predicate<ItemStack> chargePredicate, boolean transferMaxCharge) {
        IElectricItem electricItem = (IElectricItem)toolStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        long totalMaxCharge = 0L;
        long toCharge = 0L;
        if (electricItem != null && electricItem.getMaxCharge() > 0L) {
            for (int slotIndex = 0; slotIndex < ingredients.func_70302_i_(); ++slotIndex) {
                IElectricItem batteryItem;
                ItemStack stackInSlot = ingredients.func_70301_a(slotIndex);
                if (!chargePredicate.test(stackInSlot) || (batteryItem = (IElectricItem)stackInSlot.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) == null) continue;
                totalMaxCharge += batteryItem.getMaxCharge();
                toCharge += batteryItem.discharge(Long.MAX_VALUE, Integer.MAX_VALUE, true, true, true);
            }
        }
        if (electricItem instanceof ElectricItem && transferMaxCharge) {
            ((ElectricItem)electricItem).setMaxChargeOverride(totalMaxCharge);
        }
        electricItem.charge(toCharge, Integer.MAX_VALUE, true, false);
    }
}

