/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng;

import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.ScrollableListWidget;
import net.minecraft.network.PacketBuffer;

public abstract class AEListGridWidget<T extends IAEStack<T>>
extends ScrollableListWidget {
    protected final IItemList<T> list;
    private final int slotAmountY;
    private int slotRowsAmount = 0;
    protected static final int ROW_CHANGE_ID = 2;
    protected static final int CONTENT_CHANGE_ID = 3;

    public AEListGridWidget(int x, int y, int slotsY, IItemList<T> internalList) {
        super(x, y, 158, slotsY * 18);
        this.list = internalList;
        this.slotAmountY = slotsY;
    }

    public abstract T getAt(int var1);

    protected abstract void addSlotRows(int var1);

    private void removeSlotRows(int amount) {
        for (int i = 0; i < amount; ++i) {
            Widget slotWidget = (Widget)this.widgets.remove(this.widgets.size() - 1);
            this.removeWidget(slotWidget);
        }
    }

    private void modifySlotRows(int delta) {
        if (delta > 0) {
            this.addSlotRows(delta);
        } else {
            this.removeSlotRows(delta);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.list == null) {
            return;
        }
        int amountOfTypes = this.list.size();
        int slotRowsRequired = Math.max(this.slotAmountY, amountOfTypes);
        if (this.slotRowsAmount != slotRowsRequired) {
            int slotsToAdd = slotRowsRequired - this.slotRowsAmount;
            this.slotRowsAmount = slotRowsRequired;
            this.writeUpdateInfo(2, buf -> buf.func_150787_b(slotsToAdd));
            this.modifySlotRows(slotsToAdd);
        }
        this.writeListChange();
    }

    protected abstract void writeListChange();

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 2) {
            int slotsToAdd = buffer.func_150792_a();
            this.modifySlotRows(slotsToAdd);
        }
        if (id == 3) {
            this.readListChange(buffer);
        }
    }

    protected abstract void readListChange(PacketBuffer var1);
}

