/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.inventory.itemsource;

import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.inventory.IItemInfo;
import gregtech.common.inventory.IItemList;
import gregtech.common.inventory.itemsource.ItemSource;
import gregtech.common.inventory.itemsource.NetworkItemInfo;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class ItemSources
implements IItemList {
    protected final World world;
    protected final List<ItemSource> handlerInfoList = new ArrayList<ItemSource>();
    protected final Map<ItemStack, NetworkItemInfo> itemInfoMap = new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
    private final Comparator<ItemSource> comparator = Comparator.comparing(ItemSource::getPriority);
    private final Set<ItemStack> storedItemsView = Collections.unmodifiableSet(this.itemInfoMap.keySet());

    public ItemSources(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public Set<ItemStack> getStoredItems() {
        return this.storedItemsView;
    }

    @Override
    @Nullable
    public IItemInfo getItemInfo(ItemStack stack) {
        return this.itemInfoMap.get(stack);
    }

    public void update() {
        this.itemInfoMap.clear();
        this.handlerInfoList.forEach(is -> {
            is.computeItemHandler();
            is.update();
        });
        this.handlerInfoList.forEach(source -> source.getStoredItems().forEach((stack, amount) -> {
            this.itemInfoMap.putIfAbsent((ItemStack)stack, new NetworkItemInfo((ItemStack)stack));
            this.itemInfoMap.computeIfPresent((ItemStack)stack, (stackKey1, itemInfo) -> {
                itemInfo.addToSource((ItemSource)source, (Integer)source.getStoredItems().get(stack));
                return itemInfo;
            });
        }));
    }

    @Override
    public int insertItem(ItemStack itemStack, int amount, boolean simulate, IItemList.InsertMode insertMode) {
        ItemSource itemSource2;
        int inserted;
        Object2IntOpenHashMap itemSourceMap = new Object2IntOpenHashMap();
        int amountToInsert = amount;
        if (insertMode == IItemList.InsertMode.HIGHEST_PRIORITY) {
            Iterator<ItemSource> iterator = this.handlerInfoList.iterator();
            while (iterator.hasNext() && (amountToInsert -= (inserted = (itemSource2 = iterator.next()).insertItem(itemStack, amountToInsert, simulate, (Object2IntMap<ItemSource>)itemSourceMap))) != 0) {
            }
        } else {
            for (int i = this.handlerInfoList.size() - 1; i >= 0 && (amountToInsert -= (inserted = (itemSource2 = this.handlerInfoList.get(i)).insertItem(itemStack, amountToInsert, simulate, (Object2IntMap<ItemSource>)itemSourceMap))) != 0; --i) {
            }
        }
        if (!simulate) {
            for (ItemSource itemSource2 : this.handlerInfoList) {
                if (itemSourceMap.get((Object)itemSource2) == null) continue;
                this.itemInfoMap.putIfAbsent(itemStack, new NetworkItemInfo(itemStack));
                this.itemInfoMap.get(itemStack).addToSource(itemSource2, (Integer)itemSourceMap.get((Object)itemSource2));
            }
        }
        return amount - amountToInsert;
    }

    @Override
    public int extractItem(ItemStack itemStack, int amount, boolean simulate) {
        Object2IntOpenHashMap itemSourceMap = new Object2IntOpenHashMap();
        int totalExtracted = 0;
        for (ItemSource itemSource : this.handlerInfoList) {
            int extractedAmount = 0;
            if (this.itemInfoMap.get(itemStack) != null && this.itemInfoMap.get(itemStack).getTotalItemAmount() > 0) {
                amount -= (extractedAmount += itemSource.extractItem(itemStack, amount, simulate, (Object2IntMap<ItemSource>)itemSourceMap));
                totalExtracted += extractedAmount;
                if (!simulate && extractedAmount > 0) {
                    this.itemInfoMap.get(itemStack).removeFromSource(itemSource, extractedAmount);
                }
            }
            if (amount != 0) continue;
            break;
        }
        return totalExtracted;
    }

    public void notifyPriorityUpdated() {
        this.handlerInfoList.sort(this.comparator);
    }

    public void addItemHandler(ItemSource handlerInfo) {
        if (!this.handlerInfoList.contains(handlerInfo)) {
            this.handlerInfoList.add(handlerInfo);
            handlerInfo.computeItemHandler();
            this.notifyPriorityUpdated();
        }
    }
}

