/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ItemGTAxe;
import gregtech.api.items.toolitem.ItemGTHoe;
import gregtech.api.items.toolitem.ItemGTSword;
import gregtech.api.items.toolitem.ItemGTTool;
import gregtech.api.items.toolitem.ToolBuilder;
import gregtech.api.items.toolitem.ToolClasses;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.items.toolitem.ToolOreDict;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.common.items.tool.BlockRotatingBehavior;
import gregtech.common.items.tool.DisableShieldBehavior;
import gregtech.common.items.tool.EntityDamageBehavior;
import gregtech.common.items.tool.GrassPathBehavior;
import gregtech.common.items.tool.HarvestCropsBehavior;
import gregtech.common.items.tool.HarvestIceBehavior;
import gregtech.common.items.tool.HoeGroundBehavior;
import gregtech.common.items.tool.PlungerBehavior;
import gregtech.common.items.tool.RotateRailBehavior;
import gregtech.common.items.tool.TorchPlaceBehavior;
import gregtech.common.items.tool.TreeFellingBehavior;
import gregtech.core.sound.GTSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import org.jetbrains.annotations.NotNull;

public final class ToolItems {
    private static final List<IGTTool> TOOLS = new ArrayList<IGTTool>();
    public static IGTTool SWORD;
    public static IGTTool PICKAXE;
    public static IGTTool SHOVEL;
    public static IGTTool AXE;
    public static IGTTool HOE;
    public static IGTTool SAW;
    public static IGTTool HARD_HAMMER;
    public static IGTTool SOFT_MALLET;
    public static IGTTool MINING_HAMMER;
    public static IGTTool SPADE;
    public static IGTTool WRENCH;
    public static IGTTool FILE;
    public static IGTTool CROWBAR;
    public static IGTTool SCREWDRIVER;
    public static IGTTool MORTAR;
    public static IGTTool WIRE_CUTTER;
    public static IGTTool SCYTHE;
    public static IGTTool KNIFE;
    public static IGTTool BUTCHERY_KNIFE;
    public static IGTTool DRILL_LV;
    public static IGTTool DRILL_MV;
    public static IGTTool DRILL_HV;
    public static IGTTool DRILL_EV;
    public static IGTTool DRILL_IV;
    public static IGTTool CHAINSAW_LV;
    public static IGTTool WRENCH_LV;
    public static IGTTool WRENCH_HV;
    public static IGTTool WRENCH_IV;
    public static IGTTool BUZZSAW;
    public static IGTTool SCREWDRIVER_LV;
    public static IGTTool PLUNGER;
    public static IGTTool WIRECUTTER_LV;
    public static IGTTool WIRECUTTER_HV;
    public static IGTTool WIRECUTTER_IV;

    private ToolItems() {
    }

    public static List<IGTTool> getAllTools() {
        return TOOLS;
    }

    public static void init() {
        SWORD = ToolItems.register(ItemGTSword.Builder.of("gregtech", "sword").toolStats(b -> b.attacking().attackDamage(3.0f).attackSpeed(-2.4f)).toolClasses("sword").oreDict(ToolOreDict.toolSword));
        PICKAXE = ToolItems.register(ItemGTTool.Builder.of("gregtech", "pickaxe").toolStats(b -> b.blockBreaking().attackDamage(1.0f).attackSpeed(-2.8f).behaviors(TorchPlaceBehavior.INSTANCE)).toolClasses("pickaxe").oreDict(ToolOreDict.toolPickaxe));
        SHOVEL = ToolItems.register(ItemGTTool.Builder.of("gregtech", "shovel").toolStats(b -> b.blockBreaking().attackDamage(1.5f).attackSpeed(-3.0f).behaviors(GrassPathBehavior.INSTANCE)).toolClasses("shovel").oreDict(ToolOreDict.toolShovel));
        AXE = ToolItems.register(ItemGTAxe.Builder.of("gregtech", "axe").toolStats(b -> b.blockBreaking().attackDamage(5.0f).attackSpeed(-3.2f).baseEfficiency(2.0f).behaviors(DisableShieldBehavior.INSTANCE, TreeFellingBehavior.INSTANCE)).toolClasses("axe").oreDict(ToolOreDict.toolAxe));
        HOE = ToolItems.register(ItemGTHoe.Builder.of("gregtech", "hoe").toolStats(b -> b.cannotAttack().attackSpeed(-1.0f)).toolClasses("hoe").oreDict(ToolOreDict.toolHoe));
        SAW = ToolItems.register(ItemGTTool.Builder.of("gregtech", "saw").toolStats(b -> b.crafting().damagePerCraftingAction(2).attackDamage(-1.0f).attackSpeed(-2.6f).behaviors(HarvestIceBehavior.INSTANCE)).oreDict(ToolOreDict.toolSaw).secondaryOreDicts("craftingToolSaw").symbol('s').toolClasses("saw"));
        HARD_HAMMER = ToolItems.register(ItemGTTool.Builder.of("gregtech", "hammer").toolStats(b -> b.blockBreaking().crafting().damagePerCraftingAction(2).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(new EntityDamageBehavior(2.0f, EntityGolem.class))).oreDict(ToolOreDict.toolHammer).secondaryOreDicts("craftingToolHardHammer").sound(SoundEvents.field_187689_f).symbol('h').toolClasses("pickaxe", "hammer"));
        SOFT_MALLET = ToolItems.register(ItemGTTool.Builder.of("gregtech", "mallet").toolStats(b -> b.crafting().cannotAttack().attackSpeed(-2.4f)).oreDict(ToolOreDict.toolMallet).secondaryOreDicts("craftingToolSoftHammer").sound(GTSoundEvents.SOFT_MALLET_TOOL).symbol('r').toolClasses("mallet").markerItem(() -> ToolHelper.getAndSetToolData(SOFT_MALLET, Materials.Wood, 47, 1, 4.0f, 1.0f)));
        MINING_HAMMER = ToolItems.register(ItemGTTool.Builder.of("gregtech", "mining_hammer").toolStats(b -> b.blockBreaking().aoe(1, 1, 0).efficiencyMultiplier(0.4f).attackDamage(1.5f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).behaviors(TorchPlaceBehavior.INSTANCE)).toolClasses("pickaxe").oreDict(ToolOreDict.toolMiningHammer));
        SPADE = ToolItems.register(ItemGTTool.Builder.of("gregtech", "spade").toolStats(b -> b.blockBreaking().aoe(1, 1, 0).efficiencyMultiplier(0.4f).attackDamage(1.5f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).behaviors(GrassPathBehavior.INSTANCE)).toolClasses("shovel").oreDict(ToolOreDict.toolSpade));
        WRENCH = ToolItems.register(ItemGTTool.Builder.of("gregtech", "wrench").toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, EntityGolem.class))).sound(GTSoundEvents.WRENCH_TOOL, true).oreDict(ToolOreDict.toolWrench).secondaryOreDicts("craftingToolWrench").symbol('w').toolClasses("wrench"));
        FILE = ToolItems.register(ItemGTTool.Builder.of("gregtech", "file").toolStats(b -> b.crafting().damagePerCraftingAction(4).cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEvents.FILE_TOOL).oreDict(ToolOreDict.toolFile).secondaryOreDicts("craftingToolFile").symbol('f').toolClasses("file"));
        CROWBAR = ToolItems.register(ItemGTTool.Builder.of("gregtech", "crowbar").toolStats(b -> b.blockBreaking().crafting().attackDamage(2.0f).attackSpeed(-2.4f).sneakBypassUse().behaviors(RotateRailBehavior.INSTANCE)).sound(SoundEvents.field_187635_cQ).oreDict(ToolOreDict.toolCrowbar).secondaryOreDicts("craftingToolCrowbar").symbol('c').toolClasses("crowbar"));
        SCREWDRIVER = ToolItems.register(ItemGTTool.Builder.of("gregtech", "screwdriver").toolStats(b -> b.crafting().damagePerCraftingAction(4).sneakBypassUse().attackDamage(-1.0f).attackSpeed(3.0f).behaviors(new EntityDamageBehavior(3.0f, EntitySpider.class))).sound(GTSoundEvents.SCREWDRIVER_TOOL).oreDict(ToolOreDict.toolScrewdriver).secondaryOreDicts("craftingToolScrewdriver").symbol('d').toolClasses("screwdriver"));
        MORTAR = ToolItems.register(ItemGTTool.Builder.of("gregtech", "mortar").toolStats(b -> b.crafting().damagePerCraftingAction(2).cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEvents.MORTAR_TOOL).oreDict(ToolOreDict.toolMortar).secondaryOreDicts("craftingToolMortar").symbol('m').toolClasses("mortar"));
        WIRE_CUTTER = ToolItems.register(ItemGTTool.Builder.of("gregtech", "wire_cutter").toolStats(b -> b.blockBreaking().crafting().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f)).sound(GTSoundEvents.WIRECUTTER_TOOL, true).oreDict(ToolOreDict.toolWireCutter).secondaryOreDicts("craftingToolWireCutter").symbol('x').toolClasses("wirecutter"));
        SCYTHE = ToolItems.register(ItemGTSword.Builder.of("gregtech", "scythe").toolStats(b -> b.blockBreaking().attacking().attackDamage(5.0f).attackSpeed(-3.0f).durabilityMultiplier(3.0f).aoe(2, 2, 2).behaviors(HoeGroundBehavior.INSTANCE, HarvestCropsBehavior.INSTANCE).canApplyEnchantment(EnumEnchantmentType.DIGGER)).oreDict(ToolOreDict.toolScythe).toolClasses("scythe", "hoe"));
        KNIFE = ToolItems.register(ItemGTSword.Builder.of("gregtech", "knife").toolStats(b -> b.crafting().attacking().attackSpeed(3.0f)).oreDict(ToolOreDict.toolKnife).secondaryOreDicts("craftingToolKnife").symbol('k').toolClasses("knife", "sword"));
        BUTCHERY_KNIFE = ToolItems.register(ItemGTSword.Builder.of("gregtech", "butchery_knife").toolStats(b -> b.attacking().attackDamage(1.5f).attackSpeed(-1.3f).defaultEnchantment(Enchantments.field_185304_p, 3)).oreDict(ToolOreDict.toolButcheryKnife).secondaryOreDicts("craftingToolButcheryKnife").toolClasses("butchery_knife"));
        DRILL_LV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "drill_lv").toolStats(b -> b.blockBreaking().aoe(1, 1, 0).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV).behaviors(TorchPlaceBehavior.INSTANCE)).oreDict(ToolOreDict.toolDrill).secondaryOreDicts(ToolOreDict.toolPickaxe, ToolOreDict.toolShovel).sound(GTSoundEvents.DRILL_TOOL, true).toolClasses(ToolClasses.DRILL).electric(1));
        DRILL_MV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "drill_mv").toolStats(b -> b.blockBreaking().aoe(1, 1, 2).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(4.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_MV).behaviors(TorchPlaceBehavior.INSTANCE)).oreDict(ToolOreDict.toolDrill).secondaryOreDicts(ToolOreDict.toolPickaxe, ToolOreDict.toolShovel).sound(GTSoundEvents.DRILL_TOOL, true).toolClasses(ToolClasses.DRILL).electric(2));
        DRILL_HV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "drill_hv").toolStats(b -> b.blockBreaking().aoe(2, 2, 4).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(5.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV).behaviors(TorchPlaceBehavior.INSTANCE)).oreDict(ToolOreDict.toolDrill).secondaryOreDicts(ToolOreDict.toolPickaxe, ToolOreDict.toolShovel).sound(GTSoundEvents.DRILL_TOOL, true).toolClasses(ToolClasses.DRILL).electric(3));
        DRILL_EV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "drill_ev").toolStats(b -> b.blockBreaking().aoe(3, 3, 6).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(6.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_EV).behaviors(TorchPlaceBehavior.INSTANCE)).oreDict(ToolOreDict.toolDrill).secondaryOreDicts(ToolOreDict.toolPickaxe, ToolOreDict.toolShovel).sound(GTSoundEvents.DRILL_TOOL, true).toolClasses(ToolClasses.DRILL).electric(4));
        DRILL_IV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "drill_iv").toolStats(b -> b.blockBreaking().aoe(4, 4, 8).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(7.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV).behaviors(TorchPlaceBehavior.INSTANCE)).oreDict(ToolOreDict.toolDrill).secondaryOreDicts(ToolOreDict.toolPickaxe, ToolOreDict.toolShovel).sound(GTSoundEvents.DRILL_TOOL, true).toolClasses(ToolClasses.DRILL).electric(5));
        CHAINSAW_LV = ToolItems.register(ItemGTAxe.Builder.of("gregtech", "chainsaw_lv").toolStats(b -> b.blockBreaking().efficiencyMultiplier(2.0f).attackDamage(5.0f).attackSpeed(-3.2f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV).behaviors(HarvestIceBehavior.INSTANCE, DisableShieldBehavior.INSTANCE, TreeFellingBehavior.INSTANCE)).oreDict(ToolOreDict.toolAxe).secondaryOreDicts(ToolOreDict.toolChainsaw).sound(GTSoundEvents.CHAINSAW_TOOL, true).toolClasses("axe").electric(1));
        WRENCH_LV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "wrench_lv").toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(2.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, EntityGolem.class)).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEvents.WRENCH_TOOL, true).oreDict(ToolOreDict.toolWrench).secondaryOreDicts("craftingToolWrench").toolClasses("wrench").electric(1));
        WRENCH_HV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "wrench_hv").toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(3.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, EntityGolem.class)).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV)).sound(GTSoundEvents.WRENCH_TOOL, true).oreDict(ToolOreDict.toolWrench).secondaryOreDicts("craftingToolWrench").toolClasses("wrench").electric(3));
        WRENCH_IV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "wrench_iv").toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(4.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, EntityGolem.class)).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV)).sound(GTSoundEvents.WRENCH_TOOL, true).oreDict(ToolOreDict.toolWrench).secondaryOreDicts("craftingToolWrench").toolClasses("wrench").electric(5));
        BUZZSAW = ToolItems.register(ItemGTTool.Builder.of("gregtech", "buzzsaw").toolStats(b -> b.crafting().attackDamage(1.5f).attackSpeed(-3.2f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEvents.CHAINSAW_TOOL, true).oreDict(ToolOreDict.toolSaw).secondaryOreDicts("craftingToolSaw").secondaryOreDicts(ToolOreDict.toolBuzzsaw).toolClasses("saw").electric(1));
        SCREWDRIVER_LV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "screwdriver_lv").toolStats(b -> b.crafting().sneakBypassUse().attackDamage(-1.0f).attackSpeed(3.0f).behaviors(new EntityDamageBehavior(3.0f, EntitySpider.class)).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEvents.SCREWDRIVER_TOOL).oreDict(ToolOreDict.toolScrewdriver).secondaryOreDicts("craftingToolScrewdriver").toolClasses("screwdriver").electric(1));
        PLUNGER = ToolItems.register(ItemGTTool.Builder.of("gregtech", "plunger").toolStats(b -> b.cannotAttack().attackSpeed(-2.4f).sneakBypassUse().behaviors(PlungerBehavior.INSTANCE)).sound(GTSoundEvents.PLUNGER_TOOL).oreDict(ToolOreDict.toolPlunger).toolClasses("plunger").markerItem(() -> ToolHelper.getAndSetToolData(PLUNGER, Materials.Rubber, 255, 1, 4.0f, 0.0f)));
        WIRECUTTER_LV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "wire_cutter_lv").toolStats(b -> b.blockBreaking().crafting().damagePerCraftingAction(4).efficiencyMultiplier(2.0f).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEvents.WIRECUTTER_TOOL, true).oreDict(ToolOreDict.toolWireCutter).secondaryOreDicts("craftingToolWireCutter").toolClasses("wirecutter").electric(1));
        WIRECUTTER_HV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "wire_cutter_hv").toolStats(b -> b.blockBreaking().crafting().damagePerCraftingAction(4).efficiencyMultiplier(3.0f).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEvents.WIRECUTTER_TOOL, true).oreDict(ToolOreDict.toolWireCutter).secondaryOreDicts("craftingToolWireCutter").toolClasses("wirecutter").electric(3));
        WIRECUTTER_IV = ToolItems.register(ItemGTTool.Builder.of("gregtech", "wire_cutter_iv").toolStats(b -> b.blockBreaking().crafting().damagePerCraftingAction(4).efficiencyMultiplier(4.0f).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEvents.WIRECUTTER_TOOL, true).oreDict(ToolOreDict.toolWireCutter).secondaryOreDicts("craftingToolWireCutter").toolClasses("wirecutter").electric(5));
    }

    public static IGTTool register(@NotNull ToolBuilder<?> builder) {
        Object tool = builder.build();
        TOOLS.add((IGTTool)tool);
        return tool;
    }

    public static IGTTool register(@NotNull IGTTool tool) {
        TOOLS.add(tool);
        return tool;
    }

    public static void registerModels() {
        TOOLS.forEach(tool -> ModelLoader.setCustomModelResourceLocation((Item)tool.get(), (int)0, (ModelResourceLocation)tool.getModelLocation()));
    }

    public static void registerColors() {
        TOOLS.forEach(tool -> Minecraft.func_71410_x().getItemColors().func_186730_a(tool::getColor, new Item[]{tool.get()}));
    }

    public static void registerOreDict() {
        TOOLS.forEach(tool -> {
            ItemStack stack = new ItemStack(tool.get(), 1, Short.MAX_VALUE);
            if (tool.getOreDictName() != null) {
                OreDictUnifier.registerOre(stack, tool.getOreDictName());
            }
            tool.getSecondaryOreDicts().forEach(oreDict -> OreDictUnifier.registerOre(stack, oreDict));
        });
    }
}

