/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.items.metaitem.stats.IDataItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.machines.IResearchRecipeMap;
import gregtech.api.util.AssemblyLineManager;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DataItemBehavior
implements IItemBehaviour,
IDataItem {
    private final boolean requireDataBank;

    public DataItemBehavior() {
        this.requireDataBank = false;
    }

    public DataItemBehavior(boolean requireDataBank) {
        this.requireDataBank = requireDataBank;
    }

    @Override
    public boolean requireDataBank() {
        return this.requireDataBank;
    }

    @Override
    public void addInformation(@NotNull ItemStack itemStack, List<String> lines) {
        String researchId = AssemblyLineManager.readResearchId(itemStack);
        if (researchId == null) {
            return;
        }
        Collection<Recipe> recipes = ((IResearchRecipeMap)((Object)RecipeMaps.ASSEMBLY_LINE_RECIPES)).getDataStickEntry(researchId);
        if (recipes != null && !recipes.isEmpty()) {
            lines.add(I18n.func_135052_a((String)"behavior.data_item.assemblyline.title", (Object[])new Object[0]));
            ObjectOpenHashSet added = new ObjectOpenHashSet();
            for (Recipe recipe : recipes) {
                ItemStack output = (ItemStack)recipe.getOutputs().get(0);
                if (!added.add(output)) continue;
                lines.add(I18n.func_135052_a((String)"behavior.data_item.assemblyline.data", (Object[])new Object[]{output.func_82833_r()}));
            }
        }
    }
}

