/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.util.GTUtility;
import gregtech.common.terminal.app.prospector.ProspectorMode;
import gregtech.common.terminal.app.prospector.widget.WidgetOreList;
import gregtech.common.terminal.app.prospector.widget.WidgetProspectingMap;
import gregtech.common.terminal.component.SearchComponent;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ProspectorScannerBehavior
implements IItemBehaviour,
ItemUIFactory,
SearchComponent.IWidgetSearch<String> {
    private static final long VOLTAGE_FACTOR = 16L;
    private static final int FLUID_PROSPECTION_THRESHOLD = 3;
    private final int radius;
    private final int tier;
    private WidgetOreList widgetOreList;

    public ProspectorScannerBehavior(int radius, int tier) {
        this.radius = radius + 1;
        this.tier = tier;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(@NotNull World world, @NotNull EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                ItemStack stack = player.func_184586_b(hand);
                ProspectorMode mode = ProspectorScannerBehavior.getMode(stack);
                ProspectorMode nextMode = mode.next();
                if (nextMode == ProspectorMode.FLUID) {
                    if (this.tier >= 3) {
                        ProspectorScannerBehavior.setMode(stack, nextMode);
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("metaitem.prospector.mode.fluid", new Object[0]), true);
                    }
                } else {
                    ProspectorScannerBehavior.setMode(stack, nextMode);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaitem.prospector.mode.ores", new Object[0]), true);
                }
            } else if (this.checkCanUseScanner(heldItem, player, true)) {
                new PlayerInventoryHolder(player, hand).openUI();
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("behavior.prospector.not_enough_energy", new Object[0]));
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
    }

    @NotNull
    private static ProspectorMode getMode(ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return ProspectorMode.ORE;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return ProspectorMode.ORE;
        }
        if (tag.func_150297_b("Mode", 3)) {
            return ProspectorMode.VALUES[tag.func_74762_e("Mode")];
        }
        return ProspectorMode.ORE;
    }

    private static void setMode(ItemStack stack, @NotNull ProspectorMode mode) {
        NBTTagCompound tagCompound = GTUtility.getOrCreateNbtCompound(stack);
        tagCompound.func_74768_a("Mode", mode.ordinal());
    }

    private boolean checkCanUseScanner(ItemStack stack, @NotNull EntityPlayer player, boolean simulate) {
        return player.func_184812_l_() || ProspectorScannerBehavior.drainEnergy(stack, GTValues.V[this.tier] / 16L, simulate);
    }

    private static boolean drainEnergy(@NotNull ItemStack stack, long amount, boolean simulate) {
        IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem == null) {
            return false;
        }
        return electricItem.discharge(amount, Integer.MAX_VALUE, true, false, simulate) >= amount;
    }

    @Override
    public ModularUI createUI(PlayerInventoryHolder holder, @NotNull EntityPlayer entityPlayer) {
        ProspectorMode mode = ProspectorScannerBehavior.getMode(entityPlayer.func_184586_b(EnumHand.MAIN_HAND));
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 332, 200);
        this.widgetOreList = new WidgetOreList(32 * this.radius - 6, 18, 332 - 32 * this.radius, 176);
        builder.widget(this.widgetOreList);
        builder.widget(new WidgetProspectingMap(6, 18, this.radius, this.widgetOreList, mode, 1));
        builder.widget(new LabelWidget(3 + 16 * (this.radius * 2 - 1) / 2, 14, "N", 0xAAAAAA).setShadow(true));
        builder.widget(new LabelWidget(3 + 16 * (this.radius * 2 - 1) / 2, 14 + 16 * (this.radius * 2 - 1), "S", 0xAAAAAA).setShadow(true));
        builder.widget(new LabelWidget(3, 15 + 16 * (this.radius * 2 - 1) / 2, "W", 0xAAAAAA).setShadow(true));
        builder.widget(new LabelWidget(3 + 16 * (this.radius * 2 - 1), 15 + 16 * (this.radius * 2 - 1) / 2, "E", 0xAAAAAA).setShadow(true));
        return builder.label(6, 6, this.getTranslationKey()).build(holder, entityPlayer);
    }

    private String getTranslationKey() {
        return String.format("metaitem.prospector.%s.name", GTValues.VN[this.tier].toLowerCase(Locale.ROOT));
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        IItemBehaviour.super.addInformation(itemStack, lines);
        if (this.tier >= 3) {
            lines.add(I18n.func_135052_a((String)"metaitem.prospector.tooltip.fluids", (Object[])new Object[]{this.radius}));
            lines.add(I18n.func_135052_a((String)ProspectorScannerBehavior.getMode((ItemStack)itemStack).unlocalizedName, (Object[])new Object[0]));
        } else {
            lines.add(I18n.func_135052_a((String)"metaitem.prospector.tooltip.ores", (Object[])new Object[]{this.radius}));
        }
    }

    @Override
    public String resultDisplay(String result) {
        if (this.widgetOreList != null) {
            return this.widgetOreList.ores.get(result);
        }
        return "";
    }

    @Override
    public void selectResult(String result) {
        if (this.widgetOreList != null) {
            this.widgetOreList.setSelected(result);
        }
    }

    @Override
    public void search(String word, Consumer<String> find) {
        if (this.widgetOreList != null) {
            word = word.toLowerCase();
            for (Map.Entry<String, String> entry : this.widgetOreList.ores.entrySet()) {
                if (!entry.getKey().toLowerCase().contains(word) && !entry.getValue().toLowerCase().contains(word)) continue;
                find.accept(entry.getKey());
            }
        }
    }

    @Override
    public void onUpdate(ItemStack itemStack, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71070_bA instanceof ModularUIContainer) {
                ModularUIContainer modularUIContainer = (ModularUIContainer)player.field_71070_bA;
                if (modularUIContainer.getModularUI().holder instanceof PlayerInventoryHolder && ((PlayerInventoryHolder)modularUIContainer.getModularUI().holder).getCurrentItem() == itemStack && !player.func_184812_l_()) {
                    if (this.checkCanUseScanner(itemStack, player, true)) {
                        ProspectorScannerBehavior.drainEnergy(itemStack, GTValues.V[this.tier] / 16L, false);
                    } else {
                        player.func_71053_j();
                    }
                }
            }
        }
    }
}

