/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors.monitorplugin;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Translation;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.items.behavior.MonitorPluginBaseBehavior;
import gregtech.api.items.behavior.ProxyHolderPluginBehavior;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.client.renderer.scene.FBOWorldSceneRenderer;
import gregtech.client.renderer.scene.WorldSceneRenderer;
import gregtech.client.utils.RenderUtil;
import gregtech.client.utils.TrackedDummyWorld;
import gregtech.common.gui.widget.WidgetScrollBar;
import gregtech.common.gui.widget.monitor.WidgetPluginConfig;
import gregtech.common.items.behaviors.monitorplugin.FakeGuiPluginBehavior;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityCentralMonitor;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityMonitorScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;

public class AdvancedMonitorPluginBehavior
extends ProxyHolderPluginBehavior {
    @SideOnly(value=Side.CLIENT)
    private static Framebuffer FBO;
    private static final int RESOLUTION = 1080;
    private float scale;
    private int rotationPitch;
    private int rotationYaw;
    private float spin;
    private boolean connect;
    @SideOnly(value=Side.CLIENT)
    private FBOWorldSceneRenderer worldSceneRenderer;
    @SideOnly(value=Side.CLIENT)
    private Map<BlockPos, Pair<List<MetaTileEntityMonitorScreen>, Vector3f>> connections;
    @SideOnly(value=Side.CLIENT)
    private Vector3f center;
    @SideOnly(value=Side.CLIENT)
    private double[] lastMouse;
    private boolean isValid;
    Set<BlockPos> validPos;

    @SideOnly(value=Side.CLIENT)
    private void createWorldScene() {
        if (this.screen == null || this.screen.getWorld() == null) {
            return;
        }
        this.isValid = true;
        World world = this.screen.getWorld();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos2 : this.validPos) {
            minX = Math.min(minX, pos2.func_177958_n());
            minY = Math.min(minY, pos2.func_177956_o());
            minZ = Math.min(minZ, pos2.func_177952_p());
            maxX = Math.max(maxX, pos2.func_177958_n());
            maxY = Math.max(maxY, pos2.func_177956_o());
            maxZ = Math.max(maxZ, pos2.func_177952_p());
        }
        if (FBO == null) {
            FBO = new Framebuffer(1080, 1080, true);
        }
        TrackedDummyWorld dummyWorld = new TrackedDummyWorld(world);
        dummyWorld.setRenderFilter(pos -> this.validPos.contains(pos));
        this.worldSceneRenderer = new FBOWorldSceneRenderer(dummyWorld, FBO);
        this.worldSceneRenderer.addRenderedBlocks(this.validPos, null);
        this.center = new Vector3f((float)(minX + maxX) / 2.0f + 0.5f, (float)(minY + maxY) / 2.0f + 0.5f, (float)(minZ + maxZ) / 2.0f + 0.5f);
        this.worldSceneRenderer.setCameraLookAt(this.center, 10.0f / this.scale, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        this.worldSceneRenderer.setBeforeWorldRender(this::renderBefore);
        this.worldSceneRenderer.setAfterWorldRender(this::renderAfter);
        this.worldSceneRenderer.setOnLookingAt(rayTrace -> this.renderBlockOverLay(rayTrace.func_178782_a()));
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBefore(WorldSceneRenderer renderer) {
        if (this.spin > 0.0f && this.lastMouse == null) {
            this.worldSceneRenderer.setCameraLookAt(this.center, 10.0f / this.scale, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderAfter(WorldSceneRenderer renderer) {
        if (this.lastMouse != null) {
            int mouseX = (int)(1080.0 * this.lastMouse[0]);
            int mouseY = (int)(1080.0 * (1.0 - this.lastMouse[1]));
            Vector3f hitPos = WorldSceneRenderer.unProject(mouseX, mouseY);
            Vec3d eyePos = new Vec3d((double)renderer.getEyePos().x, (double)renderer.getEyePos().y, (double)renderer.getEyePos().z);
            hitPos.scale(2.0f);
            Vec3d endPos = new Vec3d((double)hitPos.x - eyePos.field_72450_a, (double)hitPos.y - eyePos.field_72448_b, (double)hitPos.z - eyePos.field_72449_c);
            double min = 3.4028234663852886E38;
            BlockPos pos = null;
            for (BlockPos core : this.validPos) {
                double dist;
                RayTraceResult hit;
                IBlockState blockState = renderer.world.func_180495_p(core);
                if (blockState.func_177230_c() == Blocks.field_150350_a || (hit = blockState.func_185910_a(renderer.world, core, eyePos, endPos)) == null || hit.field_72313_a == RayTraceResult.Type.MISS || !((dist = eyePos.func_72438_d(new Vec3d((Vec3i)hit.func_178782_a()))) < min)) continue;
                min = dist;
                pos = hit.func_178782_a();
            }
            if (pos != null) {
                this.renderBlockOverLay(pos);
            }
        }
        if (this.connect && this.connections != null) {
            for (Map.Entry<BlockPos, Pair<List<MetaTileEntityMonitorScreen>, Vector3f>> entry : this.connections.entrySet()) {
                BlockPos pos = entry.getKey();
                Vector3f winPos = WorldSceneRenderer.project(pos);
                entry.getValue().setValue((Object)winPos);
                if (winPos == null) continue;
                this.renderBlockOverLay(pos);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBlockOverLay(BlockPos pos) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5));
        GlStateManager.func_179139_a((double)1.01, (double)1.01, (double)1.01);
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179090_x();
        CCRenderState renderState = CCRenderState.instance();
        renderState.startDrawing(7, DefaultVertexFormats.field_181706_f, tessellator.func_178180_c());
        ColourMultiplier multiplier = new ColourMultiplier(0);
        renderState.setPipeline(new IVertexOperation[]{new Translation(-0.5, -0.5, -0.5), multiplier});
        BlockRenderer.BlockFace blockFace = new BlockRenderer.BlockFace();
        renderState.setModel((IVertexSource)blockFace);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            multiplier.colour = RenderUtil.packColor(255, 255, 255, 100);
            blockFace.loadCuboidFace(Cuboid6.full, renderSide.func_176745_a());
            renderState.render();
        }
        renderState.draw();
        GlStateManager.func_179139_a((double)0.9900990099009901, (double)0.9900990099009901, (double)0.9900990099009901);
        GlStateManager.func_179137_b((double)(-((double)pos.func_177958_n() + 0.5)), (double)(-((double)pos.func_177956_o() + 0.5)), (double)(-((double)pos.func_177952_p() + 0.5)));
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setConfig(float scale, int rY, int rX, float spin, boolean connect) {
        if (this.scale == scale && this.rotationPitch == rY && this.rotationYaw == rX && this.spin == spin && this.connect == connect) {
            return;
        }
        if ((double)scale < 0.3 || scale > 2.0f || rY < 0 || rY > 360 || rX < -90 || rX > 90 || spin < 0.0f || spin > 2.0f) {
            return;
        }
        this.scale = scale;
        this.rotationPitch = rY;
        this.rotationYaw = rX;
        this.spin = spin;
        this.connect = connect;
        if (this.screen.getWorld().field_72995_K) {
            if (this.worldSceneRenderer != null) {
                this.worldSceneRenderer.setCameraLookAt(this.center, 10.0f / scale, Math.toRadians(rY), Math.toRadians(rX));
            }
        } else {
            this.writePluginData(GregtechDataCodes.UPDATE_PLUGIN_CONFIG, buffer -> {
                buffer.writeFloat(scale);
                buffer.func_150787_b(rY);
                buffer.func_150787_b(rX);
                buffer.writeFloat(spin);
                buffer.writeBoolean(connect);
            });
            this.markAsDirty();
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.screen.getOffsetTimer() % 20L == 0L) {
            if (this.screen.getWorld().field_72995_K) {
                if (this.worldSceneRenderer == null && this.validPos != null && this.validPos.size() > 0) {
                    this.createWorldScene();
                }
                if (this.connect && this.worldSceneRenderer != null && this.screen.getController() instanceof MetaTileEntityCentralMonitor) {
                    if (this.connections == null) {
                        this.connections = new HashMap<BlockPos, Pair<List<MetaTileEntityMonitorScreen>, Vector3f>>();
                    }
                    this.connections.clear();
                    MetaTileEntityMonitorScreen[][] metaTileEntityMonitorScreenArray = ((MetaTileEntityCentralMonitor)this.screen.getController()).screens;
                    int n = metaTileEntityMonitorScreenArray.length;
                    for (int i = 0; i < n; ++i) {
                        MetaTileEntityMonitorScreen[] monitorScreens;
                        for (MetaTileEntityMonitorScreen screen : monitorScreens = metaTileEntityMonitorScreenArray[i]) {
                            MetaTileEntity met;
                            if (screen == null || !(screen.plugin instanceof FakeGuiPluginBehavior) || ((FakeGuiPluginBehavior)screen.plugin).getHolder() != this.holder || (met = ((FakeGuiPluginBehavior)screen.plugin).getRealMTE()) == null) continue;
                            BlockPos pos = met.getPos();
                            Pair<List<MetaTileEntityMonitorScreen>, Vector3f> tuple = this.connections.getOrDefault(pos, (Pair<List<MetaTileEntityMonitorScreen>, Vector3f>)new MutablePair(new ArrayList(), null));
                            ((List)tuple.getLeft()).add(screen);
                            this.connections.put(pos, tuple);
                        }
                    }
                }
            } else if (this.holder != null && this.holder.getMetaTileEntity() instanceof MultiblockControllerBase) {
                MultiblockControllerBase entity = (MultiblockControllerBase)this.holder.getMetaTileEntity();
                if (entity.isStructureFormed()) {
                    if (!this.isValid) {
                        PatternMatchContext result = entity.structurePattern.checkPatternFastAt(entity.getWorld(), entity.getPos(), entity.getFrontFacing().func_176734_d(), entity.getUpwardsFacing(), entity.allowsFlip());
                        if (result != null) {
                            this.validPos = entity.structurePattern.cache.keySet().stream().map(BlockPos::func_177969_a).collect(Collectors.toSet());
                            this.writePluginData(GregtechDataCodes.UPDATE_ADVANCED_VALID_POS, buf -> {
                                buf.func_150787_b(this.validPos.size());
                                for (BlockPos pos : this.validPos) {
                                    buf.func_179255_a(pos);
                                }
                            });
                            this.isValid = true;
                        } else {
                            this.validPos = Collections.emptySet();
                        }
                    }
                } else if (this.isValid) {
                    this.writePluginData(GregtechDataCodes.UPDATE_ADVANCED_VALID_POS, buf -> buf.func_150787_b(0));
                    this.isValid = false;
                }
            }
        }
        if (this.screen.getWorld().field_72995_K && this.spin > 0.0f && this.lastMouse == null) {
            this.rotationPitch = (int)(((float)this.rotationPitch + this.spin * 4.0f) % 360.0f);
        }
    }

    @Override
    public WidgetPluginConfig customUI(WidgetPluginConfig widgetGroup, IUIHolder holder, EntityPlayer entityPlayer) {
        return widgetGroup.setSize(260, 170).widget(new WidgetScrollBar(25, 20, 210, 0.3f, 2.0f, 0.1f, value -> this.setConfig(value.floatValue(), this.rotationPitch, this.rotationYaw, this.spin, this.connect)).setTitle("zoom", -1).setInitValue(this.scale)).widget(new WidgetScrollBar(25, 40, 210, 0.0f, 360.0f, 1.0f, value -> this.setConfig(this.scale, value.intValue(), this.rotationYaw, this.spin, this.connect)).setTitle("rotationPitch", -1).setInitValue(this.rotationPitch)).widget(new WidgetScrollBar(25, 60, 210, -90.0f, 90.0f, 1.0f, value -> this.setConfig(this.scale, this.rotationPitch, value.intValue(), this.spin, this.connect)).setTitle("rotationYaw", -1).setInitValue(this.rotationYaw)).widget(new WidgetScrollBar(25, 100, 210, 0.0f, 2.0f, 0.1f, value -> this.setConfig(this.scale, this.rotationPitch, this.rotationYaw, value.floatValue(), this.connect)).setTitle("spinDur", -1).setInitValue(this.spin)).widget(new LabelWidget(25, 135, "Fake GUI:", -1)).widget(new ToggleButtonWidget(80, 130, 20, 20, () -> this.connect, state -> this.setConfig(this.scale, this.rotationPitch, this.rotationYaw, this.spin, state)));
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        if (this.validPos != null && this.validPos.size() > 0) {
            buf.func_150787_b(this.validPos.size());
            for (BlockPos pos : this.validPos) {
                buf.func_179255_a(pos);
            }
        } else {
            buf.func_150787_b(0);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        this.loadValidPos(buf);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74776_a("scale", this.scale);
        data.func_74768_a("rY", this.rotationPitch);
        data.func_74768_a("rX", this.rotationYaw);
        data.func_74776_a("spin", this.spin);
        data.func_74757_a("connect", this.connect);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.scale = data.func_74764_b("scale") ? data.func_74760_g("scale") : 0.6f;
        this.rotationPitch = data.func_74764_b("rY") ? data.func_74762_e("rY") : 45;
        this.rotationYaw = data.func_74764_b("rX") ? data.func_74762_e("rX") : 0;
        this.spin = data.func_74764_b("spin") ? data.func_74760_g("spin") : 0.0f;
        this.connect = data.func_74764_b("connect") && data.func_74767_n("connect");
    }

    @Override
    public void readPluginData(int id, PacketBuffer buf) {
        if (id == GregtechDataCodes.UPDATE_ADVANCED_VALID_POS) {
            this.loadValidPos(buf);
        } else if (id == GregtechDataCodes.UPDATE_PLUGIN_CONFIG) {
            this.scale = buf.readFloat();
            this.rotationPitch = buf.func_150792_a();
            this.rotationYaw = buf.func_150792_a();
            this.spin = buf.readFloat();
            this.connect = buf.readBoolean();
            if (this.worldSceneRenderer != null) {
                this.worldSceneRenderer.setCameraLookAt(this.center, 10.0f / this.scale, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
        }
    }

    private void loadValidPos(PacketBuffer buf) {
        int size = buf.func_150792_a();
        if (size > 0) {
            this.validPos = new HashSet<BlockPos>();
            for (int i = 0; i < size; ++i) {
                this.validPos.add(buf.func_179259_c());
            }
            this.createWorldScene();
        } else {
            this.validPos = null;
            this.worldSceneRenderer = null;
            this.isValid = false;
        }
    }

    @Override
    public void readPluginAction(EntityPlayerMP player, int id, PacketBuffer buf) {
        if (id == GregtechDataCodes.ACTION_PLUGIN_CONFIG) {
            BlockPos pos = buf.func_179259_c();
            TileEntity tileEntity = this.screen.getWorld().func_175625_s(pos);
            if (tileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tileEntity).isValid()) {
                ((IGregTechTileEntity)tileEntity).getMetaTileEntity().onRightClick((EntityPlayer)player, EnumHand.MAIN_HAND, ((IGregTechTileEntity)tileEntity).getMetaTileEntity().getFrontFacing(), null);
            }
        }
    }

    @Override
    public boolean onClickLogic(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, boolean isRight, double x, double y) {
        RayTraceResult rayTrace;
        if (this.screen.getWorld().field_72995_K && this.worldSceneRenderer != null && (rayTrace = this.worldSceneRenderer.screenPos2BlockPosFace((int)(x * 1080.0), (int)((1.0 - y) * 1080.0))) != null && isRight) {
            this.writePluginAction(GregtechDataCodes.ACTION_PLUGIN_CONFIG, buf -> buf.func_179255_a(rayTrace.func_178782_a()));
        }
        return true;
    }

    @Override
    protected void onHolderChanged(IGregTechTileEntity lastHolder) {
        if (!this.screen.getWorld().field_72995_K) {
            this.validPos = null;
            this.isValid = false;
            this.writePluginData(GregtechDataCodes.UPDATE_ADVANCED_VALID_POS, buf -> buf.func_150787_b(0));
        }
    }

    @Override
    public MonitorPluginBaseBehavior createPlugin() {
        return new AdvancedMonitorPluginBehavior();
    }

    @Override
    public void renderPlugin(float partialTicks, RayTraceResult rayTraceResult) {
        if (this.worldSceneRenderer != null && this.screen != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.01);
            double[] currentMouse = this.screen.checkLookingAt(rayTraceResult);
            if (currentMouse != null) {
                this.worldSceneRenderer.render(0.0f, 0.0f, 1.0f, 1.0f, (float)currentMouse[0], (float)currentMouse[1]);
                if (this.lastMouse != null) {
                    if (Mouse.isButtonDown((int)0)) {
                        this.rotationPitch = (int)((double)this.rotationPitch + (currentMouse[0] - this.lastMouse[0]) * 300.0);
                        this.rotationPitch %= 360;
                        this.rotationYaw = (int)MathHelper.func_151237_a((double)((double)this.rotationYaw + (currentMouse[1] - this.lastMouse[1]) * 300.0), (double)-89.9, (double)89.9);
                    }
                    this.worldSceneRenderer.setCameraLookAt(this.center, 10.0f / this.scale, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
                }
            } else {
                this.worldSceneRenderer.render(0.0f, 0.0f, 1.0f, 1.0f, 0, 0);
            }
            this.lastMouse = currentMouse;
            if (this.connect && this.connections != null) {
                GlStateManager.func_179152_a((float)(1.0f / this.screen.scale), (float)(1.0f / this.screen.scale), (float)1.0f);
                for (Pair<List<MetaTileEntityMonitorScreen>, Vector3f> tuple : this.connections.values()) {
                    Vector3f origin = (Vector3f)tuple.getRight();
                    List screens = (List)tuple.getLeft();
                    if (origin == null) continue;
                    float oX = (origin.x / 1080.0f - 0.025f) * this.screen.scale;
                    float oY = (1.0f - origin.y / 1080.0f) * this.screen.scale;
                    RenderUtil.renderRect(oX, oY, 0.05f, 0.05f, 0.002f, -256);
                    for (MetaTileEntityMonitorScreen screen : screens) {
                        float rY;
                        float rX;
                        float dY;
                        float dX = (float)(screen.getX() - this.screen.getX()) - 0.025f;
                        if ((oX - dX) * (oX - dX) + (oY - (dY = (float)(screen.getY() - this.screen.getY()) + screen.scale / 2.0f - 0.025f)) * (oY - dY) > (oX - (rX = (float)(screen.getX() - this.screen.getX()) + screen.scale - 0.025f)) * (oX - rX) + (oY - (rY = (float)(screen.getY() - this.screen.getY()) + screen.scale / 2.0f - 0.025f)) * (oY - rY)) {
                            dX = rX;
                            dY = rY;
                        }
                        RenderUtil.renderRect(dX, dY, 0.05f, 0.05f, 0.002f, screen.frameColor);
                        RenderUtil.renderLine(oX + 0.025f, oY + 0.025f, dX + 0.025f, dY + 0.025f, 0.01f, screen.frameColor);
                    }
                }
            }
            GlStateManager.func_179121_F();
        }
    }
}

