/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.tool.rotation;

import gregtech.api.cover.CoverRayTracer;
import gregtech.common.items.tool.rotation.ICustomRotationBehavior;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;

public class CustomBlockRotations {
    private static final Map<Block, ICustomRotationBehavior> CUSTOM_BEHAVIOR_MAP = new Object2ObjectOpenHashMap();
    public static final ICustomRotationBehavior BLOCK_HORIZONTAL_BEHAVIOR = new ICustomRotationBehavior(){

        @Override
        public boolean customRotate(IBlockState state, World world, BlockPos pos, RayTraceResult hitResult) {
            EnumFacing gridSide = CoverRayTracer.determineGridSideHit(hitResult);
            if (gridSide == null) {
                return false;
            }
            if (gridSide.func_176740_k() == EnumFacing.Axis.Y) {
                return false;
            }
            if (gridSide != state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
                state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)gridSide);
                world.func_175656_a(pos, state);
                return true;
            }
            return false;
        }

        @Override
        public boolean showXOnSide(IBlockState state, EnumFacing facing) {
            return state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == facing;
        }
    };
    public static final ICustomRotationBehavior BLOCK_DIRECTIONAL_BEHAVIOR = new ICustomRotationBehavior(){

        @Override
        public boolean customRotate(IBlockState state, World world, BlockPos pos, RayTraceResult hitResult) {
            EnumFacing gridSide = CoverRayTracer.determineGridSideHit(hitResult);
            if (gridSide == null) {
                return false;
            }
            if (gridSide != state.func_177229_b((IProperty)BlockDirectional.field_176387_N)) {
                state = state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)gridSide);
                world.func_175656_a(pos, state);
                return true;
            }
            return false;
        }

        @Override
        public boolean showXOnSide(IBlockState state, EnumFacing facing) {
            return state.func_177229_b((IProperty)BlockDirectional.field_176387_N) == facing;
        }
    };

    @ApiStatus.Internal
    public static void init() {
        CustomRotations.init();
    }

    public static void registerCustomRotation(Block block, ICustomRotationBehavior behavior) {
        CUSTOM_BEHAVIOR_MAP.put(block, behavior);
    }

    public static ICustomRotationBehavior getCustomRotation(Block block) {
        return CUSTOM_BEHAVIOR_MAP.get(block);
    }

    private static enum CustomRotations {
        PISTON((Block)Blocks.field_150331_J, BLOCK_DIRECTIONAL_BEHAVIOR),
        STICKY_PISTON((Block)Blocks.field_150320_F, BLOCK_DIRECTIONAL_BEHAVIOR),
        DROPPER(Blocks.field_150409_cd, BLOCK_DIRECTIONAL_BEHAVIOR),
        DISPENSER(Blocks.field_150367_z, BLOCK_DIRECTIONAL_BEHAVIOR),
        OBSERVER(Blocks.field_190976_dk, BLOCK_DIRECTIONAL_BEHAVIOR),
        FURNACE(Blocks.field_150460_al, BLOCK_HORIZONTAL_BEHAVIOR),
        LIT_FURNACE(Blocks.field_150470_am, BLOCK_HORIZONTAL_BEHAVIOR),
        PUMPKIN(Blocks.field_150423_aK, BLOCK_HORIZONTAL_BEHAVIOR),
        LIT_PUMPKIN(Blocks.field_150428_aP, BLOCK_HORIZONTAL_BEHAVIOR),
        CHEST((Block)Blocks.field_150486_ae, BLOCK_HORIZONTAL_BEHAVIOR),
        TRAPPED_CHEST(Blocks.field_150447_bR, BLOCK_HORIZONTAL_BEHAVIOR),
        ENDER_CHEST(Blocks.field_150477_bB, BLOCK_HORIZONTAL_BEHAVIOR),
        HOPPER((Block)Blocks.field_150438_bZ, new ICustomRotationBehavior(){

            @Override
            public boolean customRotate(IBlockState state, World world, BlockPos pos, RayTraceResult hitResult) {
                EnumFacing gridSide = CoverRayTracer.determineGridSideHit(hitResult);
                if (gridSide == null || gridSide == EnumFacing.UP) {
                    return false;
                }
                if (gridSide != state.func_177229_b((IProperty)BlockHopper.field_176430_a)) {
                    state = state.func_177226_a((IProperty)BlockHopper.field_176430_a, (Comparable)gridSide);
                    world.func_175656_a(pos, state);
                    return true;
                }
                return false;
            }

            @Override
            public boolean showXOnSide(IBlockState state, EnumFacing facing) {
                return state.func_177229_b((IProperty)BlockHopper.field_176430_a) == facing;
            }
        });


        private CustomRotations(Block block, ICustomRotationBehavior behavior) {
            CustomBlockRotations.registerCustomRotation(block, behavior);
        }

        private static void init() {
        }
    }
}

