/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.client.particle.IMachineParticleEffect;
import gregtech.client.renderer.ICubeRenderer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class SimpleMachineMetaTileEntityResizable
extends SimpleMachineMetaTileEntity {
    private final int inputAmount;
    private final int outputAmount;

    public SimpleMachineMetaTileEntityResizable(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int inputAmount, int outputAmount, ICubeRenderer renderer, int tier) {
        super(metaTileEntityId, recipeMap, renderer, tier, true);
        this.inputAmount = inputAmount;
        this.outputAmount = outputAmount;
        this.initializeInventory();
    }

    public SimpleMachineMetaTileEntityResizable(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int inputAmount, int outputAmount, ICubeRenderer renderer, int tier, boolean hasFrontFacing, Function<Integer, Integer> tankScalingFunction) {
        super(metaTileEntityId, recipeMap, renderer, tier, hasFrontFacing, tankScalingFunction);
        this.inputAmount = inputAmount;
        this.outputAmount = outputAmount;
        this.initializeInventory();
    }

    public SimpleMachineMetaTileEntityResizable(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int inputAmount, int outputAmount, ICubeRenderer renderer, int tier, boolean hasFrontFacing, Function<Integer, Integer> tankScalingFunction, @Nullable IMachineParticleEffect tickingParticle, @Nullable IMachineParticleEffect randomParticle) {
        super(metaTileEntityId, recipeMap, renderer, tier, hasFrontFacing, tankScalingFunction, tickingParticle, randomParticle);
        this.inputAmount = inputAmount;
        this.outputAmount = outputAmount;
        this.initializeInventory();
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        if (this.inputAmount != -1) {
            return new NotifiableItemStackHandler(this, this.inputAmount, this, false);
        }
        return super.createImportItemHandler();
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        if (this.outputAmount != -1) {
            return new NotifiableItemStackHandler(this, this.outputAmount, this, true);
        }
        return super.createExportItemHandler();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SimpleMachineMetaTileEntityResizable(this.metaTileEntityId, this.workable.getRecipeMap(), this.inputAmount, this.outputAmount, this.renderer, this.getTier(), this.hasFrontFacing(), this.getTankScalingFunction(), this.tickingParticle, this.randomParticle);
    }

    @Override
    public int getItemOutputLimit() {
        return this.outputAmount;
    }
}

