/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.BoilerRecipeLogic;
import gregtech.api.capability.impl.CommonFluidFilters;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.IProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.metatileentities.multi.BoilerType;
import gregtech.core.sound.GTSoundEvents;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLargeBoiler
extends MultiblockWithDisplayBase
implements IProgressBarMultiblock {
    public final BoilerType boilerType;
    protected BoilerRecipeLogic recipeLogic;
    private FluidTankList fluidImportInventory;
    private ItemHandlerList itemImportInventory;
    private FluidTankList steamOutputTank;
    private int throttlePercentage = 100;

    public MetaTileEntityLargeBoiler(ResourceLocation metaTileEntityId, BoilerType boilerType) {
        super(metaTileEntityId);
        this.boilerType = boilerType;
        this.recipeLogic = new BoilerRecipeLogic(this);
        this.resetTileAbilities();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeBoiler(this.metaTileEntityId, this.boilerType);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
        this.throttlePercentage = 100;
        this.recipeLogic.invalidate();
    }

    private void initializeAbilities() {
        this.fluidImportInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.itemImportInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.steamOutputTank = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
    }

    private void resetTileAbilities() {
        this.fluidImportInventory = new FluidTankList(true, new IFluidTank[0]);
        this.itemImportInventory = new ItemHandlerList(Collections.emptyList());
        this.steamOutputTank = new FluidTankList(true, new IFluidTank[0]);
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed()).setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive()).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentString steamOutput = TextComponentUtil.stringWithColor(TextFormatting.AQUA, TextFormattingUtil.formatNumbers(this.recipeLogic.getLastTickSteam()) + " L/t");
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.large_boiler.steam_output", steamOutput));
                TextComponentString efficiency = TextComponentUtil.stringWithColor(this.getNumberColor(this.recipeLogic.getHeatScaled()), this.recipeLogic.getHeatScaled() + "%");
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.large_boiler.efficiency", efficiency));
                TextComponentString throttle = TextComponentUtil.stringWithColor(this.getNumberColor(this.getThrottle()), this.getThrottle() + "%");
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.large_boiler.throttle", throttle));
            }
        }).addWorkingStatusLine();
    }

    private TextFormatting getNumberColor(int number) {
        if (number == 0) {
            return TextFormatting.DARK_RED;
        }
        if (number <= 40) {
            return TextFormatting.RED;
        }
        if (number < 100) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.GREEN;
    }

    @Override
    protected void addWarningText(List<ITextComponent> textList) {
        int[] waterAmount;
        super.addWarningText(textList);
        if (this.isStructureFormed() && (waterAmount = this.getWaterAmount())[0] == 0) {
            textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.large_boiler.no_water", new Object[0]));
            textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.large_boiler.explosion_tooltip", new Object[0]));
        }
    }

    @Override
    @NotNull
    protected Widget getFlexButton(int x, int y, int width, int height) {
        WidgetGroup group = new WidgetGroup(x, y, width, height);
        group.addWidget(new ClickButtonWidget(0, 0, 9, 18, "", this::decrementThrottle).setButtonTexture(GuiTextures.BUTTON_THROTTLE_MINUS).setTooltipText("gregtech.multiblock.large_boiler.throttle_decrement", new Object[0]));
        group.addWidget(new ClickButtonWidget(9, 0, 9, 18, "", this::incrementThrottle).setButtonTexture(GuiTextures.BUTTON_THROTTLE_PLUS).setTooltipText("gregtech.multiblock.large_boiler.throttle_increment", new Object[0]));
        return group;
    }

    private void incrementThrottle(Widget.ClickData clickData) {
        this.throttlePercentage = MathHelper.func_76125_a((int)(this.throttlePercentage + 5), (int)25, (int)100);
    }

    private void decrementThrottle(Widget.ClickData clickData) {
        this.throttlePercentage = MathHelper.func_76125_a((int)(this.throttlePercentage - 5), (int)25, (int)100);
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.recipeLogic.isActive() && this.recipeLogic.isWorkingEnabled();
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "CCC", "CCC", "CCC").aisle("XXX", "CPC", "CPC", "CCC").aisle("XXX", "CSC", "CCC", "CCC").where('S', this.selfPredicate()).where('P', MetaTileEntityLargeBoiler.states(this.boilerType.pipeState)).where('X', MetaTileEntityLargeBoiler.states(this.boilerType.fireboxState).setMinGlobalLimited(4).or(MetaTileEntityLargeBoiler.abilities(MultiblockAbility.IMPORT_FLUIDS).setMinGlobalLimited(1)).or(MetaTileEntityLargeBoiler.abilities(MultiblockAbility.IMPORT_ITEMS).setMaxGlobalLimited(1)).or(this.autoAbilities())).where('C', MetaTileEntityLargeBoiler.states(this.boilerType.casingState).setMinGlobalLimited(20).or(MetaTileEntityLargeBoiler.abilities(MultiblockAbility.EXPORT_FLUIDS).setMinGlobalLimited(1))).build();
    }

    @Override
    public String[] getDescription() {
        return new String[]{I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.description", (Object[])new Object[0])};
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.rate_tooltip", (Object[])new Object[]{(int)((double)(this.boilerType.steamPerTick() * 20 * this.boilerType.runtimeBoost(20)) / 20.0)}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.heat_time_tooltip", (Object[])new Object[]{this.boilerType.getTicksToBoiling() / 20}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.base_production_fluid", (Object[])new Object[]{this.boilerType.steamPerTick()}));
        tooltip.add(TooltipHelper.BLINKING_RED + I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.explosion_tooltip", (Object[])new Object[0]));
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.recipeLogic.isWorkingEnabled());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return this.boilerType.frontOverlay;
    }

    private boolean isFireboxPart(IMultiblockPart sourcePart) {
        return this.isStructureFormed() && ((MetaTileEntity)((Object)sourcePart)).getPos().func_177956_o() < this.getPos().func_177956_o();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (sourcePart != null && this.isFireboxPart(sourcePart)) {
            return this.isActive() ? this.boilerType.fireboxActiveRenderer : this.boilerType.fireboxIdleRenderer;
        }
        return this.boilerType.casingRenderer;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return true;
    }

    @Override
    public SoundEvent getSound() {
        return GTSoundEvents.BOILER;
    }

    @Override
    protected void updateFormedValid() {
        this.recipeLogic.update();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74768_a("ThrottlePercentage", this.throttlePercentage);
        return super.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.throttlePercentage = data.func_74762_e("ThrottlePercentage");
        super.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.throttlePercentage);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.throttlePercentage = buf.func_150792_a();
    }

    public int getThrottle() {
        return this.throttlePercentage;
    }

    @Override
    public IItemHandlerModifiable getImportItems() {
        return this.itemImportInventory;
    }

    @Override
    public FluidTankList getImportFluids() {
        return this.fluidImportInventory;
    }

    @Override
    public FluidTankList getExportFluids() {
        return this.steamOutputTank;
    }

    @Override
    protected boolean shouldUpdate(MTETrait trait) {
        return !(trait instanceof BoilerRecipeLogic);
    }

    @Override
    protected boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    public double getFillPercentage(int index) {
        if (!this.isStructureFormed()) {
            return 0.0;
        }
        int[] waterAmount = this.getWaterAmount();
        if (waterAmount[1] == 0) {
            return 0.0;
        }
        return 1.0 * (double)waterAmount[0] / (double)waterAmount[1];
    }

    @Override
    public TextureArea getProgressBarTexture(int index) {
        return GuiTextures.PROGRESS_BAR_FLUID_RIG_DEPLETION;
    }

    @Override
    public void addBarHoverText(List<ITextComponent> hoverList, int index) {
        if (!this.isStructureFormed()) {
            hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.invalid_structure", new Object[0]));
        } else {
            int[] waterAmount = this.getWaterAmount();
            if (waterAmount[0] == 0) {
                hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.large_boiler.no_water", new Object[0]));
            } else {
                TextComponentTranslation waterInfo = TextComponentUtil.translationWithColor(TextFormatting.BLUE, "%s / %s L", waterAmount[0], waterAmount[1]);
                hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.large_boiler.water_bar_hover", waterInfo));
            }
        }
    }

    private int[] getWaterAmount() {
        if (!this.isStructureFormed()) {
            return new int[]{0, 0};
        }
        List<IFluidTank> tanks = this.getAbilities(MultiblockAbility.IMPORT_FLUIDS);
        int filled = 0;
        int capacity = 0;
        for (IFluidTank tank : tanks) {
            if (tank == null || tank.getFluid() == null || !CommonFluidFilters.BOILER_FLUID.test(tank.getFluid())) continue;
            filled += tank.getFluidAmount();
            capacity += tank.getCapacity();
        }
        return new int[]{filled, capacity};
    }
}

