/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntityMultiSmelter
extends RecipeMapMultiblockController {
    protected int heatingCoilLevel;
    protected int heatingCoilDiscount;

    public MetaTileEntityMultiSmelter(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.FURNACE_RECIPES);
        this.recipeMapWorkable = new MultiSmelterWorkable(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMultiSmelter(this.metaTileEntityId);
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed()).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.recipeMapWorkable.getEnergyContainer()).addEnergyTierLine(GTUtility.getTierByVoltage(this.recipeMapWorkable.getMaxVoltage())).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentTranslation hoverText;
                if (this.heatingCoilDiscount > 1) {
                    TextComponentString coilDiscount = TextComponentUtil.stringWithColor(TextFormatting.AQUA, TextFormattingUtil.formatNumbers(100.0 / (double)this.heatingCoilDiscount) + "%");
                    TextComponentTranslation base = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.multi_furnace.heating_coil_discount", coilDiscount);
                    hoverText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.multi_furnace.heating_coil_discount_hover", new Object[0]);
                    TextComponentUtil.setHover((ITextComponent)base, new ITextComponent[]{hoverText});
                    tl.add(base);
                }
                if (this.recipeMapWorkable.getParallelLimit() > 1) {
                    TextComponentString parallels = TextComponentUtil.stringWithColor(TextFormatting.DARK_PURPLE, TextFormattingUtil.formatNumbers(this.recipeMapWorkable.getParallelLimit()));
                    TextComponentTranslation bodyText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.parallel", parallels);
                    hoverText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.multi_furnace.parallel_hover", new Object[0]);
                    tl.add(TextComponentUtil.setHover((ITextComponent)bodyText, new ITextComponent[]{hoverText}));
                }
            }
        }).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgressPercent());
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object coilType = context.get("CoilType");
        if (coilType instanceof IHeatingCoilBlockStats) {
            this.heatingCoilLevel = ((IHeatingCoilBlockStats)coilType).getLevel();
            this.heatingCoilDiscount = ((IHeatingCoilBlockStats)coilType).getEnergyDiscount();
        } else {
            this.heatingCoilLevel = BlockWireCoil.CoilType.CUPRONICKEL.getLevel();
            this.heatingCoilDiscount = BlockWireCoil.CoilType.CUPRONICKEL.getEnergyDiscount();
        }
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.heatingCoilLevel = 0;
        this.heatingCoilDiscount = 0;
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "CCC", "XXX").aisle("XXX", "C#C", "XMX").aisle("XSX", "CCC", "XXX").where('S', this.selfPredicate()).where('X', MetaTileEntityMultiSmelter.states(this.getCasingState()).setMinGlobalLimited(9).or(this.autoAbilities(true, true, true, true, true, true, false))).where('M', MetaTileEntityMultiSmelter.abilities(MultiblockAbility.MUFFLER_HATCH)).where('C', MetaTileEntityMultiSmelter.heatingCoils()).where('#', MetaTileEntityMultiSmelter.air()).build();
    }

    public IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.HEAT_PROOF_CASING;
    }

    @Override
    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.MULTI_FURNACE_OVERLAY;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return true;
    }

    public static int getEUtForParallel(int parallel, int discount) {
        return 4 * Math.max(1, parallel / 8 / discount);
    }

    public static int getMaxParallel(int heatingCoilLevel) {
        return 32 * heatingCoilLevel;
    }

    public static int getDurationForParallel(int parallel, int parallelLimit) {
        return (int)Math.max(1.0, (double)(256 * parallel) / Math.max(1.0, (double)parallelLimit * 1.0));
    }

    protected class MultiSmelterWorkable
    extends MultiblockRecipeLogic {
        public MultiSmelterWorkable(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        @Override
        @NotNull
        public ParallelLogicType getParallelLogicType() {
            return ParallelLogicType.APPEND_ITEMS;
        }

        @Override
        public void applyParallelBonus(@NotNull RecipeBuilder<?> builder) {
            ((RecipeBuilder)builder.EUt(MetaTileEntityMultiSmelter.getEUtForParallel(builder.getParallel(), MetaTileEntityMultiSmelter.this.heatingCoilDiscount))).duration(MetaTileEntityMultiSmelter.getDurationForParallel(builder.getParallel(), this.getParallelLimit()));
        }

        @Override
        public int getParallelLimit() {
            return MetaTileEntityMultiSmelter.getMaxParallel(MetaTileEntityMultiSmelter.this.heatingCoilLevel);
        }
    }
}

