/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IOpticalComputationHatch;
import gregtech.api.capability.IOpticalComputationProvider;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.util.GTLog;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import gregtech.common.pipelike.optical.tile.TileEntityOpticalPipe;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityComputationHatch
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<IOpticalComputationHatch>,
IOpticalComputationHatch {
    private final boolean isTransmitter;

    public MetaTileEntityComputationHatch(ResourceLocation metaTileEntityId, boolean isTransmitter) {
        super(metaTileEntityId, 7);
        this.isTransmitter = isTransmitter;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityComputationHatch(this.metaTileEntityId, this.isTransmitter);
    }

    @Override
    public boolean isTransmitter() {
        return this.isTransmitter;
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        MultiblockControllerBase controller = this.getController();
        if (controller == null || !controller.isStructureFormed()) {
            return 0;
        }
        if (this.isTransmitter()) {
            if (controller instanceof IOpticalComputationProvider) {
                IOpticalComputationProvider provider = (IOpticalComputationProvider)((Object)controller);
                return provider.requestCWUt(cwut, simulate, seen);
            }
            GTLog.logger.error("Computation Transmission Hatch could not request CWU/t from its controller!");
            return 0;
        }
        IOpticalComputationProvider provider = this.getOpticalNetProvider();
        if (provider == null) {
            return 0;
        }
        return provider.requestCWUt(cwut, simulate, seen);
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        MultiblockControllerBase controller = this.getController();
        if (controller == null || !controller.isStructureFormed()) {
            return 0;
        }
        if (this.isTransmitter()) {
            if (controller instanceof IOpticalComputationProvider) {
                IOpticalComputationProvider provider = (IOpticalComputationProvider)((Object)controller);
                return provider.getMaxCWUt(seen);
            }
            GTLog.logger.error("Computation Transmission Hatch could not get maximum CWU/t from its controller!");
            return 0;
        }
        IOpticalComputationProvider provider = this.getOpticalNetProvider();
        if (provider == null) {
            return 0;
        }
        return provider.getMaxCWUt(seen);
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        MultiblockControllerBase controller = this.getController();
        if (controller == null || !controller.isStructureFormed()) {
            return true;
        }
        if (this.isTransmitter()) {
            if (controller instanceof IOpticalComputationProvider) {
                IOpticalComputationProvider provider = (IOpticalComputationProvider)((Object)controller);
                return provider.canBridge(seen);
            }
            GTLog.logger.error("Computation Transmission Hatch could not test bridge status of its controller!");
            return false;
        }
        IOpticalComputationProvider provider = this.getOpticalNetProvider();
        if (provider == null) {
            return true;
        }
        return provider.canBridge(seen);
    }

    @Nullable
    private IOpticalComputationProvider getOpticalNetProvider() {
        TileEntity tileEntity = this.getNeighbor(this.getFrontFacing());
        if (tileEntity == null) {
            return null;
        }
        if (tileEntity instanceof TileEntityOpticalPipe) {
            return (IOpticalComputationProvider)tileEntity.getCapability(GregtechTileCapabilities.CABABILITY_COMPUTATION_PROVIDER, this.getFrontFacing().func_176734_d());
        }
        return null;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public boolean canPartShare() {
        return false;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.OPTICAL_DATA_ACCESS_HATCH.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    public MultiblockAbility<IOpticalComputationHatch> getAbility() {
        return this.isTransmitter() ? MultiblockAbility.COMPUTATION_DATA_TRANSMISSION : MultiblockAbility.COMPUTATION_DATA_RECEPTION;
    }

    @Override
    public void registerAbilities(List<IOpticalComputationHatch> abilityList) {
        abilityList.add(this);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (side == this.getFrontFacing() && capability == GregtechTileCapabilities.CABABILITY_COMPUTATION_PROVIDER) {
            return (T)GregtechTileCapabilities.CABABILITY_COMPUTATION_PROVIDER.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.disabled", (Object[])new Object[0]));
    }
}

