/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.IMufflerHatch;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.client.particle.VanillaParticleEffects;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMufflerHatch
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<IMufflerHatch>,
ITieredMetaTileEntity,
IMufflerHatch {
    private final int recoveryChance;
    private final GTItemStackHandler inventory;
    private boolean frontFaceFree;

    public MetaTileEntityMufflerHatch(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.recoveryChance = Math.max(1, tier * 10);
        this.inventory = new GTItemStackHandler((MetaTileEntity)this, (int)Math.pow(tier + 1, 2.0));
        this.frontFaceFree = false;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMufflerHatch(this.metaTileEntityId, this.getTier());
    }

    @Override
    public void update() {
        MultiblockWithDisplayBase controller;
        MultiblockControllerBase multiblockControllerBase;
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 10L == 0L) {
            this.frontFaceFree = this.checkFrontFaceFree();
        }
        if (this.getWorld().field_72995_K && (multiblockControllerBase = this.getController()) instanceof MultiblockWithDisplayBase && (controller = (MultiblockWithDisplayBase)multiblockControllerBase).isActive()) {
            VanillaParticleEffects.mufflerEffect(this, controller.getMufflerParticle());
        }
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        MetaTileEntityMufflerHatch.clearInventory(itemBuffer, (IItemHandlerModifiable)this.inventory);
    }

    @Override
    public void recoverItemsTable(List<ItemStack> recoveryItems) {
        for (ItemStack recoveryItem : recoveryItems) {
            if (!this.calculateChance()) continue;
            GTTransferUtils.insertItem((IItemHandler)this.inventory, recoveryItem.func_77946_l(), false);
        }
    }

    private boolean calculateChance() {
        return this.recoveryChance >= 100 || this.recoveryChance > GTValues.RNG.nextInt(100);
    }

    @Override
    public boolean isFrontFaceFree() {
        return this.frontFaceFree;
    }

    private boolean checkFrontFaceFree() {
        BlockPos frontPos = this.getPos().func_177972_a(this.getFrontFacing());
        IBlockState blockState = this.getWorld().func_180495_p(frontPos);
        MultiblockWithDisplayBase controller = (MultiblockWithDisplayBase)this.getController();
        if (controller != null && controller.isActive()) {
            if (GTUtility.tryBreakSnow(this.getWorld(), frontPos, blockState, true)) {
                return true;
            }
            return blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.getWorld(), frontPos);
        }
        return blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.getWorld(), frontPos) || GTUtility.isBlockSnow(blockState);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public void pollutionParticles() {
        MultiblockControllerBase controller = this.getController();
        if (controller instanceof MultiblockWithDisplayBase) {
            MultiblockWithDisplayBase displayBase = (MultiblockWithDisplayBase)controller;
            VanillaParticleEffects.mufflerEffect(this, displayBase.getMufflerParticle());
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.MUFFLER_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.muffler_hatch.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.muffler.recovery_tooltip", (Object[])new Object[]{this.recoveryChance}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
        tooltip.add(TooltipHelper.BLINKING_RED + I18n.func_135052_a((String)"gregtech.machine.muffler_hatch.tooltip2", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public MultiblockAbility<IMufflerHatch> getAbility() {
        return MultiblockAbility.MUFFLER_HATCH;
    }

    @Override
    public void registerAbilities(List<IMufflerHatch> abilityList) {
        abilityList.add(this);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        int rowSize;
        return this.createUITemplate(entityPlayer, rowSize, (rowSize = (int)Math.sqrt(this.inventory.getSlots())) == 10 ? 9 : 0).build(this.getHolder(), entityPlayer);
    }

    private ModularUI.Builder createUITemplate(EntityPlayer player, int rowSize, int xOffset) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176 + xOffset * 2, 18 + 18 * rowSize + 94).label(10, 5, this.getMetaFullName());
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                builder.widget(new SlotWidget((IItemHandler)this.inventory, index, 88 - rowSize * 9 + x * 18 + xOffset, 18 + y * 18, true, false).setBackgroundTexture(GuiTextures.SLOT));
            }
        }
        return builder.bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 7 + xOffset, 18 + 18 * rowSize + 12);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("RecoveryInventory", (NBTBase)this.inventory.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.deserializeNBT(data.func_74775_l("RecoveryInventory"));
    }
}

