/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FilteredItemHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.FluidContainerSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityReservoirHatch
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IFluidTank> {
    private static final int FLUID_AMOUNT = 2000000000;
    private final InfiniteWaterTank fluidTank = new InfiniteWaterTank(this.getInventorySize(), this);

    public MetaTileEntityReservoirHatch(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 4, false);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityReservoirHatch(this.metaTileEntityId);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            this.fillContainerFromInternalTank((IFluidHandler)this.fluidTank);
            if (this.getOffsetTimer() % 20L == 0L) {
                this.fluidTank.refillWater();
            }
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.WATER_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidTank);
        }
        return super.getCapability(capability, side);
    }

    private int getInventorySize() {
        return 2000000000;
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new FilteredItemHandler(this).setFillPredicate(FilteredItemHandler.getCapabilityFilter(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY));
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    public MultiblockAbility<IFluidTank> getAbility() {
        return MultiblockAbility.IMPORT_FLUIDS;
    }

    @Override
    public void registerAbilities(List<IFluidTank> abilityList) {
        abilityList.add((IFluidTank)this.fluidTank);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createTankUI((IFluidTank)this.fluidTank, this.getMetaFullName(), entityPlayer).build(this.getHolder(), entityPlayer);
    }

    public ModularUI.Builder createTankUI(IFluidTank fluidTank, String title, EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        TankWidget tankWidget = new TankWidget(fluidTank, 69, 52, 18, 18).setAlwaysShowFull(true).setDrawHoveringText(false).setContainerClicking(true, false);
        builder.image(7, 16, 81, 55, GuiTextures.DISPLAY).widget(new ImageWidget(91, 36, 14, 15, GuiTextures.TANK_ICON)).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 90, 53, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY));
        return builder.label(6, 6, title).label(11, 20, "gregtech.gui.fluid_amount", 0xFFFFFF).widget(new AdvancedTextWidget(11, 30, this.getFluidAmountText(tankWidget), 0xFFFFFF)).widget(new AdvancedTextWidget(11, 40, this.getFluidNameText(tankWidget), 0xFFFFFF)).widget(tankWidget).widget(new FluidContainerSlotWidget(this.importItems, 0, 90, 16, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).bindPlayerInventory(entityPlayer.field_71071_by);
    }

    private Consumer<List<ITextComponent>> getFluidNameText(TankWidget tankWidget) {
        return list -> {
            TextComponentTranslation translation = tankWidget.getFluidTextComponent();
            if (translation != null) {
                list.add(translation);
            }
        };
    }

    private Consumer<List<ITextComponent>> getFluidAmountText(TankWidget tankWidget) {
        return list -> {
            String fluidAmount = tankWidget.getFormattedFluidAmount();
            if (!fluidAmount.isEmpty()) {
                list.add(new TextComponentString(fluidAmount));
            }
        };
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.getInventorySize()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    private static class InfiniteWaterTank
    extends NotifiableFluidTank {
        public InfiniteWaterTank(int capacity, MetaTileEntity entityToNotify) {
            super(capacity, entityToNotify, false);
            this.setFluid(new FluidStack(FluidRegistry.WATER, 2000000000));
            this.setCanFill(false);
        }

        private void refillWater() {
            int fillAmount = Math.max(0, 2000000000 - this.getFluidAmount());
            if (fillAmount > 0) {
                super.fillInternal(new FluidStack(FluidRegistry.WATER, fillAmount), true);
            }
        }

        public boolean canDrainFluidType(@Nullable FluidStack fluid) {
            return fluid != null && fluid.getFluid() == FluidRegistry.WATER;
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            return 0;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return false;
        }

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            return this;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            return nbt;
        }
    }
}

