/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng.slot;

import appeng.api.storage.data.IAEStack;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.IConfigurableSlot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public abstract class ExportOnlyAESlot<T extends IAEStack<T>>
implements IConfigurableSlot<T>,
INBTSerializable<NBTTagCompound> {
    protected static final String CONFIG_TAG = "config";
    protected static final String STOCK_TAG = "stock";
    protected T config;
    protected T stock;

    public ExportOnlyAESlot(T config, T stock) {
        this.config = config;
        this.stock = stock;
    }

    public ExportOnlyAESlot() {
        this(null, null);
    }

    @Nullable
    public T requestStack() {
        if (this.stock != null && !this.stock.isMeaningful()) {
            this.stock = null;
        }
        if (this.config == null || this.stock != null && !this.config.equals(this.stock)) {
            return null;
        }
        if (this.stock == null) {
            return (T)this.config.copy();
        }
        if (this.stock.getStackSize() < this.config.getStackSize()) {
            return (T)this.config.copy().setStackSize(this.config.getStackSize() - this.stock.getStackSize());
        }
        return null;
    }

    @Nullable
    public T exceedStack() {
        if (this.stock != null && !this.stock.isMeaningful()) {
            this.stock = null;
        }
        if (this.config == null && this.stock != null) {
            return (T)this.stock.copy();
        }
        if (this.config != null && this.stock != null) {
            if (this.config.equals(this.stock) && this.config.getStackSize() < this.stock.getStackSize()) {
                return (T)this.stock.copy().setStackSize(this.stock.getStackSize() - this.config.getStackSize());
            }
            if (!this.config.equals(this.stock)) {
                return (T)this.stock.copy();
            }
        }
        return null;
    }

    public abstract void addStack(T var1);

    public abstract void setStack(T var1);

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.config != null) {
            NBTTagCompound configTag = new NBTTagCompound();
            this.config.writeToNBT(configTag);
            tag.func_74782_a(CONFIG_TAG, (NBTBase)configTag);
        }
        if (this.stock != null) {
            NBTTagCompound stockTag = new NBTTagCompound();
            this.stock.writeToNBT(stockTag);
            tag.func_74782_a(STOCK_TAG, (NBTBase)stockTag);
        }
        return tag;
    }

    @Override
    public T getConfig() {
        return this.config;
    }

    @Override
    public T getStock() {
        return this.stock;
    }

    @Override
    public void setConfig(T val) {
        this.config = val;
    }

    @Override
    public void setStock(T val) {
        this.stock = val;
    }
}

