/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.hpca;

import gregtech.api.GTValues;
import gregtech.api.capability.IHPCAComputationProvider;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.metatileentities.multi.multiblockpart.hpca.MetaTileEntityHPCAComponent;
import net.minecraft.util.ResourceLocation;

public class MetaTileEntityHPCAComputation
extends MetaTileEntityHPCAComponent
implements IHPCAComputationProvider {
    private final boolean advanced;

    public MetaTileEntityHPCAComputation(ResourceLocation metaTileEntityId, boolean advanced) {
        super(metaTileEntityId);
        this.advanced = advanced;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityHPCAComputation(this.metaTileEntityId, this.advanced);
    }

    @Override
    public boolean isAdvanced() {
        return this.advanced;
    }

    @Override
    public SimpleOverlayRenderer getFrontOverlay() {
        if (this.isDamaged()) {
            return this.advanced ? Textures.HPCA_ADVANCED_DAMAGED_OVERLAY : Textures.HPCA_DAMAGED_OVERLAY;
        }
        return this.advanced ? Textures.HPCA_ADVANCED_COMPUTATION_OVERLAY : Textures.HPCA_COMPUTATION_OVERLAY;
    }

    @Override
    public TextureArea getComponentIcon() {
        if (this.isDamaged()) {
            return this.advanced ? GuiTextures.HPCA_ICON_DAMAGED_ADVANCED_COMPUTATION_COMPONENT : GuiTextures.HPCA_ICON_DAMAGED_COMPUTATION_COMPONENT;
        }
        return this.advanced ? GuiTextures.HPCA_ICON_ADVANCED_COMPUTATION_COMPONENT : GuiTextures.HPCA_ICON_COMPUTATION_COMPONENT;
    }

    @Override
    public SimpleOverlayRenderer getFrontActiveOverlay() {
        if (this.isDamaged()) {
            return this.advanced ? Textures.HPCA_ADVANCED_DAMAGED_ACTIVE_OVERLAY : Textures.HPCA_DAMAGED_ACTIVE_OVERLAY;
        }
        return this.advanced ? Textures.HPCA_ADVANCED_COMPUTATION_ACTIVE_OVERLAY : Textures.HPCA_COMPUTATION_ACTIVE_OVERLAY;
    }

    @Override
    public int getUpkeepEUt() {
        return GTValues.VA[this.advanced ? 5 : 4];
    }

    @Override
    public int getMaxEUt() {
        return GTValues.VA[this.advanced ? 7 : 6];
    }

    @Override
    public int getCWUPerTick() {
        if (this.isDamaged()) {
            return 0;
        }
        return this.advanced ? 16 : 4;
    }

    @Override
    public int getCoolingPerTick() {
        return this.advanced ? 4 : 2;
    }

    @Override
    public boolean canBeDamaged() {
        return true;
    }
}

