/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IMiner;
import gregtech.api.capability.IVentable;
import gregtech.api.capability.impl.CommonFluidFilters;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.capability.impl.miner.MinerLogic;
import gregtech.api.capability.impl.miner.SteamMinerLogic;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.common.ConfigHolder;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SteamMiner
extends MetaTileEntity
implements IMiner,
IControllable,
IVentable,
IDataInfoProvider {
    private boolean needsVenting = false;
    private boolean ventingStuck = false;
    private final int inventorySize;
    private final int energyPerTick;
    private boolean isInventoryFull = false;
    private final MinerLogic minerLogic;

    public SteamMiner(ResourceLocation metaTileEntityId, int speed, int maximumRadius, int fortune) {
        super(metaTileEntityId);
        this.inventorySize = 4;
        this.energyPerTick = 16;
        this.minerLogic = new SteamMinerLogic(this, fortune, speed, maximumRadius, Textures.BRONZE_PLATED_BRICKS);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SteamMiner(this.metaTileEntityId, this.minerLogic.getSpeed(), this.minerLogic.getMaximumRadius(), this.minerLogic.getFortune());
    }

    @Override
    public FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{new FilteredFluidHandler(16000).setFilter(CommonFluidFilters.STEAM)});
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler(this, 0, this, false);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new NotifiableItemStackHandler(this, this.inventorySize, this, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        ColourMultiplier multiplier = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()));
        IVertexOperation[] coloredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)multiplier);
        Textures.STEAM_CASING_BRONZE.render(renderState, translation, coloredPipeline);
        for (EnumFacing renderSide : EnumFacing.field_176754_o) {
            if (renderSide == this.getFrontFacing()) {
                Textures.PIPE_OUT_OVERLAY.renderSided(renderSide, renderState, translation, pipeline);
                continue;
            }
            Textures.STEAM_MINER_OVERLAY.renderSided(renderSide, renderState, translation, coloredPipeline);
        }
        Textures.STEAM_VENT_OVERLAY.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        Textures.PIPE_IN_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
        this.minerLogic.renderPipe(renderState, translation, pipeline);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        int rowSize = (int)Math.sqrt(this.inventorySize);
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND_STEAM.get(false), 175, 176);
        builder.bindPlayerInventory(entityPlayer.field_71071_by, 94);
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                builder.widget(new SlotWidget((IItemHandler)this.exportItems, index, 142 - rowSize * 9 + x * 18, 18 + y * 18, true, false).setBackgroundTexture(GuiTextures.SLOT_STEAM.get(false)));
            }
        }
        builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT_STEAM.get(false), 10);
        builder.image(7, 16, 105, 75, GuiTextures.DISPLAY_STEAM.get(false)).label(6, 6, this.getMetaFullName());
        builder.widget(new AdvancedTextWidget(10, 19, this::addDisplayText, 0xFFFFFF).setMaxWidthLimit(84));
        builder.widget(new AdvancedTextWidget(70, 19, this::addDisplayText2, 0xFFFFFF).setMaxWidthLimit(84));
        return builder.build(this.getHolder(), entityPlayer);
    }

    void addDisplayText(List<ITextComponent> textList) {
        int workingArea = this.getWorkingArea(this.minerLogic.getCurrentRadius());
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.startx", new Object[]{this.minerLogic.getX().get()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.starty", new Object[]{this.minerLogic.getY().get()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.startz", new Object[]{this.minerLogic.getZ().get()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.working_area", new Object[]{workingArea, workingArea}));
        if (this.minerLogic.isDone()) {
            textList.add(new TextComponentTranslation("gregtech.machine.miner.done", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        } else if (this.minerLogic.isWorking()) {
            textList.add(new TextComponentTranslation("gregtech.machine.miner.working", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        } else if (!this.isWorkingEnabled()) {
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.work_paused", new Object[0]));
        }
        if (this.isInventoryFull) {
            textList.add(new TextComponentTranslation("gregtech.machine.miner.invfull", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        if (this.ventingStuck) {
            textList.add(new TextComponentTranslation("gregtech.machine.steam_miner.vent", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        } else if (!this.drainEnergy(true)) {
            textList.add(new TextComponentTranslation("gregtech.machine.steam_miner.steam", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    void addDisplayText2(List<ITextComponent> textList) {
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.minex", new Object[]{this.minerLogic.getMineX().get()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.miney", new Object[]{this.minerLogic.getMineY().get()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.minez", new Object[]{this.minerLogic.getMineZ().get()}));
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.uses_per_tick_steam", (Object[])new Object[]{this.energyPerTick}) + TextFormatting.GRAY + ", " + I18n.func_135052_a((String)"gregtech.machine.miner.per_block", (Object[])new Object[]{this.minerLogic.getSpeed() / 20}));
        int maxArea = this.getWorkingArea(this.minerLogic.getMaximumRadius());
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.working_area", (Object[])new Object[]{maxArea, maxArea}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.reset", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public boolean drainEnergy(boolean simulate) {
        int resultSteam = this.importFluids.getTankAt(0).getFluidAmount() - this.energyPerTick;
        if (!this.ventingStuck && (long)resultSteam >= 0L && resultSteam <= this.importFluids.getTankAt(0).getCapacity()) {
            if (!simulate) {
                this.importFluids.getTankAt(0).drain(this.energyPerTick, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void update() {
        super.update();
        this.minerLogic.performMining();
        if (!this.getWorld().field_72995_K) {
            if (this.getOffsetTimer() % 5L == 0L) {
                this.pushItemsIntoNearbyHandlers(this.getFrontFacing());
            }
            if (this.minerLogic.wasActiveAndNeedsUpdate()) {
                this.minerLogic.setWasActiveAndNeedsUpdate(false);
                this.minerLogic.setActive(false);
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("needsVenting", this.needsVenting);
        data.func_74757_a("ventingStuck", this.ventingStuck);
        return this.minerLogic.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.needsVenting = data.func_74767_n("needsVenting");
        this.ventingStuck = data.func_74767_n("ventingStuck");
        this.minerLogic.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.needsVenting);
        buf.writeBoolean(this.ventingStuck);
        this.minerLogic.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.needsVenting = buf.readBoolean();
        this.ventingStuck = buf.readBoolean();
        this.minerLogic.receiveInitialSyncData(buf);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.NEEDS_VENTING) {
            this.needsVenting = buf.readBoolean();
        } else if (dataId == GregtechDataCodes.VENTING_STUCK) {
            this.ventingStuck = buf.readBoolean();
        }
        this.minerLogic.receiveCustomData(dataId, buf);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.STEAM_CASING_BRONZE.getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.TOP), (Object)this.getPaintingColorForRendering());
    }

    public void setVentingStuck(boolean ventingStuck) {
        this.ventingStuck = ventingStuck;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
            this.writeCustomData(GregtechDataCodes.VENTING_STUCK, buf -> buf.writeBoolean(ventingStuck));
        }
    }

    @Override
    public void setNeedsVenting(boolean needsVenting) {
        this.needsVenting = needsVenting;
        if (!needsVenting && this.ventingStuck) {
            this.setVentingStuck(false);
        }
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
            this.writeCustomData(GregtechDataCodes.NEEDS_VENTING, buf -> buf.writeBoolean(needsVenting));
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isInventoryFull() {
        return this.isInventoryFull;
    }

    @Override
    public void setInventoryFull(boolean isFull) {
        this.isInventoryFull = isFull;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.minerLogic.isWorkingEnabled();
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.minerLogic.setWorkingEnabled(isActivationAllowed);
    }

    @Override
    public boolean isNeedsVenting() {
        return this.needsVenting;
    }

    @Override
    public void tryDoVenting() {
        BlockPos machinePos = this.getPos();
        EnumFacing ventingSide = EnumFacing.UP;
        BlockPos ventingBlockPos = machinePos.func_177972_a(ventingSide);
        IBlockState blockOnPos = this.getWorld().func_180495_p(ventingBlockPos);
        if (blockOnPos.func_185890_d((IBlockAccess)this.getWorld(), ventingBlockPos) == Block.field_185506_k) {
            this.getWorld().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(ventingBlockPos), EntitySelectors.field_188444_d).forEach(entity -> entity.func_70097_a(DamageSources.getHeatDamage(), 6.0f));
            WorldServer world = (WorldServer)this.getWorld();
            double posX = (double)machinePos.func_177958_n() + 0.5 + (double)ventingSide.func_82601_c() * 0.6;
            double posY = (double)machinePos.func_177956_o() + 0.5 + (double)ventingSide.func_96559_d() * 0.6;
            double posZ = (double)machinePos.func_177952_p() + 0.5 + (double)ventingSide.func_82599_e() * 0.6;
            world.func_175739_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 7 + world.field_73012_v.nextInt(3), (double)ventingSide.func_82601_c() / 2.0, (double)ventingSide.func_96559_d() / 2.0, (double)ventingSide.func_82599_e() / 2.0, 0.1, new int[0]);
            if (ConfigHolder.machines.machineSounds && !this.isMuffled()) {
                world.func_184148_a(null, posX, posY, posZ, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.setNeedsVenting(false);
        } else if (!this.ventingStuck) {
            this.setVentingStuck(true);
        }
    }

    @Override
    public boolean isVentingStuck() {
        return this.ventingStuck;
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        int workingArea = this.getWorkingArea(this.minerLogic.getCurrentRadius());
        return Collections.singletonList(new TextComponentTranslation("gregtech.machine.miner.working_area", new Object[]{workingArea, workingArea}));
    }
}

