/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.game.minesweeper.widget;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.interpolate.RGBInterpolator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class MineMapWidget
extends Widget {
    private static final TextureArea COVERED = new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/covered.png"), 0.0, 0.0, 1.0, 1.0);
    private static final TextureArea FLAG = new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/flag.png"), 0.0, 0.0, 1.0, 1.0);
    private static final TextureArea BOMB = new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/bomb.png"), 0.0, 0.0, 1.0, 1.0);
    private static final TextureArea[] NUMBERS = new TextureArea[]{new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/blank.png"), 0.0, 0.0, 1.0, 1.0), new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/1.png"), 0.0, 0.0, 1.0, 1.0), new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/2.png"), 0.0, 0.0, 1.0, 1.0), new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/3.png"), 0.0, 0.0, 1.0, 1.0), new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/4.png"), 0.0, 0.0, 1.0, 1.0), new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/5.png"), 0.0, 0.0, 1.0, 1.0), new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/6.png"), 0.0, 0.0, 1.0, 1.0), new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/7.png"), 0.0, 0.0, 1.0, 1.0), new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/minesweeper/8.png"), 0.0, 0.0, 1.0, 1.0)};
    public int mineCount;
    public int flagsPlaced;
    private int width;
    private int height;
    private boolean isPrepared;
    private boolean[][] mines;
    private boolean[][] flags;
    private boolean[][] checkedSpaces;
    private int[][] generatedNumbers;
    private boolean isLost;
    private boolean isWon;
    private int timer = 0;
    private static final RGBInterpolator interpolator = new RGBInterpolator(5, (r, g, b) -> GlStateManager.func_179124_c((float)r.floatValue(), (float)g.floatValue(), (float)b.floatValue()), (r, g, b) -> GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f));

    public MineMapWidget(int width, int height, int mineCount) {
        super(166 - width * 8, 116 - height * 8, width * 16, height * 16);
        this.width = width;
        this.height = height;
        this.resetData();
        this.mineCount = mineCount;
    }

    public void resetData() {
        this.mines = new boolean[this.width][this.height];
        this.generatedNumbers = new int[this.width][this.height];
        this.checkedSpaces = new boolean[this.width][this.height];
        this.flags = new boolean[this.width][this.height];
        this.isLost = false;
        this.isWon = false;
        this.isPrepared = false;
        this.flagsPlaced = 0;
    }

    public void initMines(int startX, int startY) {
        int minesPlaced = 0;
        while (minesPlaced < this.mineCount) {
            while (minesPlaced < this.mineCount) {
                this.placeMine(startX, startY);
                ++minesPlaced;
            }
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    boolean isTrapped = true;
                    for (int xMod = i == 0 ? 0 : -1; xMod < (i == this.width - 1 ? 1 : 2); ++xMod) {
                        for (int yMod = j == 0 ? 0 : -1; yMod < (j == this.height - 1 ? 1 : 2); ++yMod) {
                            isTrapped &= this.mines[i + xMod][j + yMod];
                        }
                    }
                    if (!isTrapped) continue;
                    this.mines[i][j] = false;
                    --minesPlaced;
                }
            }
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.mines[x][y]) continue;
                for (int xMod = x == 0 ? 0 : -1; xMod < (x == this.width - 1 ? 1 : 2); ++xMod) {
                    for (int yMod = y == 0 ? 0 : -1; yMod < (y == this.height - 1 ? 1 : 2); ++yMod) {
                        int[] nArray = this.generatedNumbers[x + xMod];
                        int n = y + yMod;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        }
        this.isPrepared = true;
    }

    private void placeMine(int startX, int startY) {
        int x = (int)(Math.random() * (double)this.width);
        int y = (int)(Math.random() * (double)this.height);
        while (this.mines[x][y] || startX < x + 3 && startX > x - 3 && startY < y + 3 && startY > y - 3) {
            x = (int)(Math.random() * (double)this.width);
            y = (int)(Math.random() * (double)this.height);
        }
        this.mines[x][y] = true;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        ++this.timer;
        if (this.isWon && !interpolator.isActivated()) {
            interpolator.start();
        }
        if (!this.isWon && interpolator.isActivated()) {
            interpolator.stop();
        }
        interpolator.func_73660_a();
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (this.isLost && this.mines[i][j]) {
                    BOMB.draw(i * 16 + this.getPosition().getX(), j * 16 + this.getPosition().getY(), 16, 16);
                    continue;
                }
                if (!this.checkedSpaces[i][j]) {
                    if (this.flags[i][j]) {
                        FLAG.draw(i * 16 + this.getPosition().getX(), j * 16 + this.getPosition().getY(), 16, 16);
                        continue;
                    }
                    COVERED.draw(i * 16 + this.getPosition().getX(), j * 16 + this.getPosition().getY(), 16, 16);
                    continue;
                }
                if (!this.mines[i][j]) {
                    NUMBERS[this.generatedNumbers[i][j]].draw(i * 16 + this.getPosition().getX(), j * 16 + this.getPosition().getY(), 16, 16);
                    continue;
                }
                BOMB.draw(i * 16 + this.getPosition().getX(), j * 16 + this.getPosition().getY(), 16, 16);
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isWon || this.isLost) {
            return false;
        }
        int gridX = (mouseX - this.getPosition().getX()) / 16;
        int gridY = (mouseY - this.getPosition().getY()) / 16;
        if (gridX >= this.width || gridY >= this.height || gridX < 0 || gridY < 0) {
            return false;
        }
        if (button == 0 && !this.flags[gridX][gridY]) {
            if (!this.isPrepared) {
                this.initMines(gridX, gridY);
            }
            if (this.generatedNumbers[gridX][gridY] == 0) {
                this.uncoverSafeTiles(gridX, gridY);
            } else {
                this.checkedSpaces[gridX][gridY] = true;
            }
            if (this.mines[gridX][gridY]) {
                this.isLost = true;
            }
        } else if (button == 1 && !this.checkedSpaces[gridX][gridY]) {
            boolean bl = this.flags[gridX][gridY] = !this.flags[gridX][gridY];
            this.flagsPlaced = this.flags[gridX][gridY] ? ++this.flagsPlaced : --this.flagsPlaced;
        }
        return true;
    }

    private void uncoverSafeTiles(int x, int y) {
        this.checkedSpaces[x][y] = true;
        if (this.generatedNumbers[x][y] != 0) {
            return;
        }
        for (int xMod = x == 0 ? 0 : -1; xMod < (x == this.width - 1 ? 1 : 2); ++xMod) {
            for (int yMod = y == 0 ? 0 : -1; yMod < (y == this.height - 1 ? 1 : 2); ++yMod) {
                if (this.checkedSpaces[x + xMod][y + yMod]) continue;
                this.uncoverSafeTiles(x + xMod, y + yMod);
            }
        }
    }

    public boolean hasLost() {
        return this.isLost;
    }

    public boolean hasWon() {
        if (!this.isPrepared) {
            return false;
        }
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (this.mines[i][j] == this.flags[i][j] && this.checkedSpaces[i][j] != this.mines[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public void notifyWon() {
        this.isWon = true;
    }
}

