/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.worldgen;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import gregtech.api.unification.OreDictUnifier;
import gregtech.common.worldgen.AbstractItemLootEntry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.ForgeHooks;

public class LootEntryOreDict
extends AbstractItemLootEntry {
    private final String oreDictName;

    protected LootEntryOreDict(String oreDictName, int weightIn, int qualityIn, LootFunction[] functionsIn, LootCondition[] conditionsIn, String entryName) {
        super(weightIn, qualityIn, functionsIn, conditionsIn, entryName);
        this.oreDictName = oreDictName;
    }

    @Override
    protected ItemStack createItemStack() {
        return OreDictUnifier.get(this.oreDictName);
    }

    public static LootEntryOreDict deserialize(JsonObject object, JsonDeserializationContext context, int weight, int quality, LootCondition[] conditions) {
        String entryName = ForgeHooks.readLootEntryName((JsonObject)object, (String)"item");
        LootFunction[] lootFunctions = object.has("functions") ? (LootFunction[])JsonUtils.func_188174_a((JsonObject)object, (String)"functions", (JsonDeserializationContext)context, LootFunction[].class) : new LootFunction[]{};
        String oreDictName = JsonUtils.func_151200_h((JsonObject)object, (String)"name");
        return new LootEntryOreDict(oreDictName, weight, quality, lootFunctions, conditions, entryName);
    }
}

