/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.unification.material.internal;

import com.google.common.base.Preconditions;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.registry.IMaterialRegistryManager;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.api.util.GTControlledRegistry;
import gregtech.core.unification.material.internal.MaterialRegistryImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaterialRegistryManager
implements IMaterialRegistryManager {
    private static MaterialRegistryManager INSTANCE;
    private final Object2ObjectMap<String, MaterialRegistryImpl> registries = new Object2ObjectOpenHashMap();
    private final Int2ObjectMap<MaterialRegistryImpl> networkIds = new Int2ObjectOpenHashMap();
    @Nullable
    private Collection<Material> registeredMaterials;
    private final MaterialRegistryImpl gregtechRegistry = this.createInternalRegistry();
    private IMaterialRegistryManager.Phase registrationPhase = IMaterialRegistryManager.Phase.PRE;

    private MaterialRegistryManager() {
    }

    public static MaterialRegistryManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MaterialRegistryManager();
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    public MaterialRegistry createRegistry(@NotNull String modid) {
        if (this.getPhase() != IMaterialRegistryManager.Phase.PRE) {
            throw new IllegalStateException("Cannot create registries in phase " + (Object)((Object)this.getPhase()));
        }
        Preconditions.checkArgument((!this.registries.containsKey((Object)modid) ? 1 : 0) != 0, (String)"Material registry already exists for modid %s", (Object)modid);
        MaterialRegistryImpl registry = new MaterialRegistryImpl(modid);
        this.registries.put((Object)modid, (Object)registry);
        this.networkIds.put(registry.getNetworkId(), (Object)registry);
        return registry;
    }

    @Override
    @NotNull
    public MaterialRegistry getRegistry(@NotNull String modid) {
        MaterialRegistry registry = (MaterialRegistry)((Object)this.registries.get((Object)modid));
        return registry != null ? registry : this.gregtechRegistry;
    }

    @Override
    @NotNull
    public MaterialRegistry getRegistry(int networkId) {
        MaterialRegistry registry = (MaterialRegistry)((Object)this.networkIds.get(networkId));
        return registry != null ? registry : this.gregtechRegistry;
    }

    @Override
    @NotNull
    public Collection<MaterialRegistry> getRegistries() {
        if (this.getPhase() == IMaterialRegistryManager.Phase.PRE) {
            throw new IllegalStateException("Cannot get all material registries during phase " + (Object)((Object)this.getPhase()));
        }
        return Collections.unmodifiableCollection(this.registries.values());
    }

    @Override
    @NotNull
    public Collection<Material> getRegisteredMaterials() {
        if (this.registeredMaterials == null || this.getPhase() != IMaterialRegistryManager.Phase.CLOSED && this.getPhase() != IMaterialRegistryManager.Phase.FROZEN) {
            throw new IllegalStateException("Cannot retrieve all materials before registration");
        }
        return this.registeredMaterials;
    }

    @Override
    @Nullable
    public Material getMaterial(@NotNull String name) {
        if (!name.isEmpty()) {
            String materialName;
            String modid;
            int index = name.indexOf(58);
            if (index >= 0) {
                modid = name.substring(0, index);
                materialName = name.substring(index + 1);
            } else {
                modid = "gregtech";
                materialName = name;
            }
            return (Material)this.getRegistry(modid).func_82594_a(materialName);
        }
        return null;
    }

    @Override
    @NotNull
    public IMaterialRegistryManager.Phase getPhase() {
        return this.registrationPhase;
    }

    public void unfreezeRegistries() {
        this.registries.values().forEach(GTControlledRegistry::unfreeze);
        this.registrationPhase = IMaterialRegistryManager.Phase.OPEN;
    }

    public void closeRegistries() {
        this.registries.values().forEach(MaterialRegistryImpl::closeRegistry);
        ArrayList<Material> collection = new ArrayList<Material>();
        for (MaterialRegistry registry : this.registries.values()) {
            collection.addAll(registry.getAllMaterials());
        }
        this.registeredMaterials = Collections.unmodifiableCollection(collection);
        this.registrationPhase = IMaterialRegistryManager.Phase.CLOSED;
    }

    public void freezeRegistries() {
        this.registries.values().forEach(GTControlledRegistry::freeze);
        this.registrationPhase = IMaterialRegistryManager.Phase.FROZEN;
    }

    @NotNull
    private MaterialRegistryImpl createInternalRegistry() {
        MaterialRegistryImpl registry = new MaterialRegistryImpl("gregtech");
        this.registries.put((Object)"gregtech", (Object)registry);
        return registry;
    }

    @NotNull
    public MaterialRegistry getDefaultRegistry() {
        return this.gregtechRegistry;
    }

    @NotNull
    public Material getDefaultFallback() {
        return this.gregtechRegistry.getFallbackMaterial();
    }
}

