/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleEffects;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import gregtech.integration.forestry.bees.GTAlleleBeeSpecies;
import java.util.Arrays;
import java.util.function.Consumer;

public enum GTBranchDefinition {
    GT_ORGANIC("Fuelis", alleles -> {
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
    }),
    GT_INDUSTRIAL("Industrialis", alleles -> {
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
    }),
    GT_ALLOY("Amalgamis", alleles -> {
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
    }),
    GT_GEM("Ornamentis", alleles -> {
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }),
    GT_METAL("Metaliferis", alleles -> {
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
    }),
    GT_RAREMETAL("Mineralis", alleles -> {
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.CACTI);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FAST);
    }),
    GT_RADIOACTIVE("Criticalis", alleles -> {
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.END);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAllele)GTAlleleBeeSpecies.speedBlinding);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectRadioactive);
    }),
    GT_NOBLEGAS("Gasa Nobilia", alleles -> {
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTEST);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
    });

    private static IAllele[] defaultTemplate;
    private final IClassification branch;
    private final Consumer<IAllele[]> branchProperties;

    private GTBranchDefinition(String scientific, Consumer<IAllele[]> branchProperties) {
        this.branch = BeeManager.beeFactory.createBranch(this.name().toLowerCase(), scientific);
        AlleleManager.alleleRegistry.getClassification("family.apidae").addMemberGroup(this.branch);
        this.branchProperties = branchProperties;
    }

    private static IAllele[] getDefaultTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumBeeChromosome.values().length];
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWEST);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
        }
        return Arrays.copyOf(defaultTemplate, defaultTemplate.length);
    }

    private void setBranchProperties(IAllele[] template) {
        this.branchProperties.accept(template);
    }

    public IAllele[] getTemplate() {
        IAllele[] template = GTBranchDefinition.getDefaultTemplate();
        this.setBranchProperties(template);
        return template;
    }

    public IClassification getBranch() {
        return this.branch;
    }
}

