/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.groovy;

import com.cleanroommc.groovyscript.GroovyScript;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.GroovyPlugin;
import com.cleanroommc.groovyscript.api.IObjectParser;
import com.cleanroommc.groovyscript.api.Result;
import com.cleanroommc.groovyscript.compat.mods.GroovyContainer;
import com.cleanroommc.groovyscript.compat.mods.GroovyPropertyContainer;
import com.cleanroommc.groovyscript.event.ScriptRunEvent;
import com.cleanroommc.groovyscript.helper.EnumHelper;
import com.cleanroommc.groovyscript.sandbox.expand.ExpansionHelper;
import com.google.common.collect.ImmutableList;
import gregtech.api.GregTechAPI;
import gregtech.api.fluids.FluidBuilder;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.modules.GregTechModule;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeOreInput;
import gregtech.api.unification.Element;
import gregtech.api.unification.Elements;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.event.MaterialEvent;
import gregtech.api.unification.material.event.PostMaterialEvent;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockMaterialBase;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.itempipe.BlockItemPipe;
import gregtech.integration.IntegrationSubmodule;
import gregtech.integration.groovy.GroovyExpansions;
import gregtech.integration.groovy.GroovyHandCommand;
import gregtech.integration.groovy.GroovyMaterialBuilderExpansion;
import gregtech.integration.groovy.MaterialExpansion;
import gregtech.integration.groovy.MaterialPropertyExpansion;
import gregtech.integration.groovy.PropertyContainer;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(modid="groovyscript", iface="com.cleanroommc.groovyscript.api.GroovyPlugin", striprefs=true)
@GregTechModule(moduleID="grs_integration", containerID="gregtech", modDependencies={"groovyscript"}, name="GregTech GroovyScript Integration", description="GroovyScript Integration Module")
public class GroovyScriptModule
extends IntegrationSubmodule
implements GroovyPlugin {
    private static GroovyContainer<?> modSupportContainer;
    private static final Object2ObjectOpenHashMap<String, Map<String, ItemStack>> metaItems;

    @Override
    @NotNull
    public List<Class<?>> getEventBusSubscribers() {
        return ImmutableList.of(GroovyHandCommand.class, GroovyScriptModule.class);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRecipeEvent(RegistryEvent.Register<IRecipe> event) {
        GroovyScriptModule.loadMetaItemBracketHandler();
    }

    @SubscribeEvent
    @Optional.Method(modid="groovyscript")
    public static void afterScriptLoad(ScriptRunEvent.Post event) {
        if (!GregTechAPI.moduleManager.isModuleEnabled("jei_integration")) {
            GTRecipeOreInput.refreshStackCache();
        }
    }

    public static boolean isCurrentlyRunning() {
        return GregTechAPI.moduleManager.isModuleEnabled("grs_integration") && GroovyScript.getSandbox().isRunning();
    }

    public static <T extends Enum<T>> T parseAndValidateEnumValue(Class<T> clazz, String raw, String type) {
        return GroovyScriptModule.parseAndValidateEnumValue(clazz, raw, type, false);
    }

    @Contract(value="_,_,_,true -> !null")
    public static <T extends Enum<T>> T parseAndValidateEnumValue(Class<T> clazz, String raw, String type, boolean crash) {
        Enum t = EnumHelper.valueOfNullable(clazz, (String)raw, (boolean)false);
        if (t == null) {
            String msg = GroovyLog.format((String)"Can't find {} for {} in material builder. Valid values are {};", (Object[])new Object[]{type, raw, Arrays.toString(clazz.getEnumConstants())});
            if (crash) {
                throw new NoSuchElementException(msg);
            }
            GroovyLog.get().error((Object)msg);
            return null;
        }
        return (T)t;
    }

    @Optional.Method(modid="groovyscript")
    public static GroovyContainer<?> getInstance() {
        return modSupportContainer;
    }

    public static boolean validateNonNull(Object o, Supplier<String> errorMsg) {
        if (o == null) {
            if (GroovyScriptModule.isCurrentlyRunning()) {
                GroovyLog.get().error((Object)errorMsg.get());
            }
            return false;
        }
        return true;
    }

    @Nullable
    public static ItemStack getMetaItem(String name) {
        ItemStack stack;
        String[] resultName = GroovyScriptModule.splitObjectName(name);
        Map map = (Map)metaItems.get((Object)resultName[0]);
        if (map != null && (stack = (ItemStack)map.get(resultName[1])) != null) {
            return stack.func_77946_l();
        }
        stack = GroovyScriptModule.getMetaTileEntityItem(resultName);
        if (stack != null) {
            return stack.func_77946_l();
        }
        return null;
    }

    @Nullable
    public static ItemStack getMetaTileEntityItem(String[] split) {
        MetaTileEntity metaTileEntity = (MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_82594_a(new ResourceLocation(split[0], split[1]));
        return metaTileEntity == null ? null : metaTileEntity.getStackForm();
    }

    public static String[] splitObjectName(String toSplit) {
        String[] resultSplit = new String[]{"gregtech", toSplit};
        int i = toSplit.indexOf(58);
        if (i >= 0) {
            resultSplit[1] = toSplit.substring(i + 1);
            if (i > 1) {
                resultSplit[0] = toSplit.substring(0, i);
            }
        }
        return resultSplit;
    }

    public static void loadMetaItemBracketHandler() {
        ItemStack stack;
        Map map;
        String modid;
        metaItems.clear();
        for (Map.Entry<Material, BlockCompressed> entry : MetaBlocks.COMPRESSED.entrySet()) {
            modid = entry.getKey().getModid();
            map = (Map)metaItems.computeIfAbsent((Object)modid, k -> new Object2ObjectOpenHashMap());
            String string = "block" + entry.getKey().toCamelCaseString();
            stack = entry.getValue().getItem(entry.getKey());
            map.put(string, stack);
        }
        for (Map.Entry<Material, BlockMaterialBase> entry : MetaBlocks.FRAMES.entrySet()) {
            modid = entry.getKey().getModid();
            map = (Map)metaItems.computeIfAbsent((Object)modid, k -> new Object2ObjectOpenHashMap());
            String string = "frame" + entry.getKey().toCamelCaseString();
            stack = ((BlockFrame)entry.getValue()).getItem(entry.getKey());
            map.put(string, stack);
        }
        for (MaterialRegistry materialRegistry : GregTechAPI.materialManager.getRegistries()) {
            ItemStack stack2;
            String name;
            modid = materialRegistry.getModid();
            map = (Map)metaItems.computeIfAbsent((Object)modid, k -> new Object2ObjectOpenHashMap());
            for (BlockCable blockCable : MetaBlocks.CABLES.get(modid)) {
                for (Material material : blockCable.getEnabledMaterials()) {
                    String name2 = blockCable.getPrefix().name + material.toCamelCaseString();
                    ItemStack stack22 = blockCable.getItem(material);
                    map.put(name2, stack22);
                }
            }
            for (BlockItemPipe blockItemPipe : MetaBlocks.ITEM_PIPES.get(modid)) {
                for (Material material : blockItemPipe.getEnabledMaterials()) {
                    name = blockItemPipe.getPrefix().name + material.toCamelCaseString();
                    stack2 = blockItemPipe.getItem(material);
                    map.put(name, stack2);
                }
            }
            for (BlockFluidPipe blockFluidPipe : MetaBlocks.FLUID_PIPES.get(modid)) {
                for (Material material : blockFluidPipe.getEnabledMaterials()) {
                    name = blockFluidPipe.getPrefix().name + material.toCamelCaseString();
                    stack2 = blockFluidPipe.getItem(material);
                    map.put(name, stack2);
                }
            }
            metaItems.put((Object)modid, (Object)map);
        }
        for (MetaItem metaItem : MetaItem.getMetaItems()) {
            Map map2 = (Map)metaItems.computeIfAbsent((Object)Objects.requireNonNull(metaItem.getRegistryName()).func_110624_b(), k -> new Object2ObjectOpenHashMap());
            for (MetaItem.MetaValueItem metaValueItem : metaItem.getAllItems()) {
                if (metaValueItem.unlocalizedName.equals("meta_item")) continue;
                map2.put(metaValueItem.unlocalizedName, metaValueItem.getStackForm());
            }
        }
    }

    @NotNull
    public String getModId() {
        return "gregtech";
    }

    @NotNull
    public String getContainerName() {
        return "GregTech";
    }

    @Optional.Method(modid="groovyscript")
    @Nullable
    public GroovyPropertyContainer createGroovyPropertyContainer() {
        return new PropertyContainer();
    }

    @Optional.Method(modid="groovyscript")
    public void onCompatLoaded(GroovyContainer<?> container) {
        modSupportContainer = container;
        container.objectMapperBuilder("recipemap", RecipeMap.class).parser(IObjectParser.wrapStringGetter(RecipeMap::getByName)).completerOfNamed(RecipeMap::getRecipeMaps, RecipeMap::getUnlocalizedName).register();
        container.objectMapperBuilder("material", Material.class).parser(IObjectParser.wrapStringGetter(GregTechAPI.materialManager::getMaterial)).completerOfNamed(GregTechAPI.materialManager::getRegisteredMaterials, mat -> mat.getResourceLocation().toString()).register();
        container.objectMapperBuilder("oreprefix", OrePrefix.class).parser(IObjectParser.wrapStringGetter(OrePrefix::getPrefix)).completerOfNamed(OrePrefix::values, v -> v.name).register();
        container.objectMapperBuilder("metaitem", ItemStack.class).parser(IObjectParser.wrapStringGetter(GroovyScriptModule::getMetaItem)).completer((paramIndex, items) -> {
            if (paramIndex != 0) {
                return;
            }
            ObjectIterator iterator = metaItems.object2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
                String mod = (String)entry.getKey();
                for (String key : ((Map)entry.getValue()).keySet()) {
                    CompletionItem item = new CompletionItem(mod + ":" + key);
                    item.setKind(CompletionItemKind.Constant);
                    items.add((Object)item);
                }
            }
        }).register();
        container.objectMapperBuilder("element", Element.class).parser((s, args) -> {
            Element element = Elements.get(s);
            if (element != null) {
                return Result.some((Object)element);
            }
            if (s.length() <= 6) {
                for (Element element1 : Elements.getAllElements()) {
                    if (!element1.symbol.equals(s)) continue;
                    return Result.some((Object)element1);
                }
            }
            return Result.error();
        }).completerOfNamed(Elements::getAllElements, Element::getName).register();
        ExpansionHelper.mixinClass(Material.class, MaterialExpansion.class);
        ExpansionHelper.mixinClass(Material.class, MaterialPropertyExpansion.class);
        ExpansionHelper.mixinClass(Material.Builder.class, GroovyMaterialBuilderExpansion.class);
        ExpansionHelper.mixinMethod(RecipeBuilder.class, GroovyExpansions.class, (String)"property");
        ExpansionHelper.mixinMethod(MaterialEvent.class, GroovyExpansions.class, (String)"materialBuilder");
        ExpansionHelper.mixinMethod(MaterialEvent.class, GroovyExpansions.class, (String)"toolBuilder");
        ExpansionHelper.mixinMethod(MaterialEvent.class, GroovyExpansions.class, (String)"fluidBuilder");
        ExpansionHelper.mixinMethod(PostMaterialEvent.class, GroovyExpansions.class, (String)"toolBuilder");
        ExpansionHelper.mixinMethod(PostMaterialEvent.class, GroovyExpansions.class, (String)"fluidBuilder");
        ExpansionHelper.mixinMethod(FluidBuilder.class, GroovyExpansions.class, (String)"acidic");
    }

    protected static boolean checkFrozen(String description) {
        if (!GregTechAPI.materialManager.canModifyMaterials()) {
            GroovyLog.get().error("Cannot {} now, must be done in preInit loadStage and material event", new Object[]{description});
            return true;
        }
        return false;
    }

    protected static void logError(Material m, String cause, String type) {
        GroovyLog.get().error("Cannot {0} of a Material with no {1}! Try calling \"add{1}\" in your late material event first if this is intentional. Material: {2}", new Object[]{cause, type, m.getUnlocalizedName()});
    }

    static {
        metaItems = new Object2ObjectOpenHashMap();
    }
}

