/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.electric.MetaTileEntityDiode;
import gregtech.integration.hwyla.provider.ElectricContainerDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.jetbrains.annotations.NotNull;

public class DiodeDataProvider
extends ElectricContainerDataProvider {
    public static final DiodeDataProvider INSTANCE = new DiodeDataProvider();

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("GregTech", "gregtech.diode");
    }

    @Override
    protected NBTTagCompound getNBTData(IEnergyContainer capability, NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!capability.outputsEnergy(facing)) continue;
            subTag.func_74768_a("FrontFacing", facing.func_176745_a());
            break;
        }
        subTag.func_74772_a("InputAmperage", capability.getInputAmperage());
        subTag.func_74772_a("OutputAmperage", capability.getOutputAmperage());
        tag.func_74782_a("gregtech.MetaTileEntityDiode", (NBTBase)subTag);
        return tag;
    }

    @Override
    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        IGregTechTileEntity gtte;
        TileEntity tileEntity;
        if (!(config.getConfig("gregtech.diode") && (tileEntity = accessor.getTileEntity()) instanceof IGregTechTileEntity && (gtte = (IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof MetaTileEntityDiode)) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.MetaTileEntityDiode")) {
            NBTTagCompound tag = accessor.getNBTData().func_74775_l("gregtech.MetaTileEntityDiode");
            long inputAmperage = tag.func_74763_f("InputAmperage");
            long outputAmperage = tag.func_74763_f("OutputAmperage");
            EnumFacing frontFacing = EnumFacing.func_82600_a((int)tag.func_74762_e("FrontFacing"));
            if (accessor.getSide() == frontFacing) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.transform_output", (Object[])new Object[0]) + " " + TextFormattingUtil.formatNumbers(outputAmperage) + " A");
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.transform_input", (Object[])new Object[0]) + " " + TextFormattingUtil.formatNumbers(inputAmperage) + " A");
            }
        }
        return tooltip;
    }
}

