/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.common.blocks.BlockLamp;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LampDataProvider
implements IWailaDataProvider {
    public static final LampDataProvider INSTANCE = new LampDataProvider();

    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, BlockLamp.class);
        registrar.addConfig("GregTech", "gregtech.block_lamp");
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("gregtech.block_lamp")) {
            return tooltip;
        }
        Block block = accessor.getBlock();
        if (block instanceof BlockLamp) {
            BlockLamp lamp = (BlockLamp)block;
            IBlockState state = accessor.getBlockState();
            boolean inverted = lamp.isInverted(state);
            boolean bloomEnabled = lamp.isBloomEnabled(state);
            boolean lightEnabled = lamp.isLightEnabled(state);
            if (inverted) {
                tooltip.add(I18n.func_135052_a((String)"tile.gregtech_lamp.tooltip.inverted", (Object[])new Object[0]));
            }
            if (!bloomEnabled) {
                tooltip.add(I18n.func_135052_a((String)"tile.gregtech_lamp.tooltip.no_bloom", (Object[])new Object[0]));
            }
            if (!lightEnabled) {
                tooltip.add(I18n.func_135052_a((String)"tile.gregtech_lamp.tooltip.no_light", (Object[])new Object[0]));
            }
        }
        return tooltip;
    }
}

