/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.ComputationRecipeLogic;
import gregtech.integration.hwyla.provider.CapabilityDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class WorkableDataProvider
extends CapabilityDataProvider<IWorkable> {
    public static final WorkableDataProvider INSTANCE = new WorkableDataProvider();

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("GregTech", "gregtech.workable");
    }

    @Override
    @NotNull
    protected Capability<IWorkable> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_WORKABLE;
    }

    @Override
    protected NBTTagCompound getNBTData(IWorkable capability, NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74757_a("Active", capability.isActive());
        if (capability.isActive()) {
            ComputationRecipeLogic logic;
            subTag.func_74757_a("ShowAsComputation", capability instanceof ComputationRecipeLogic && !(logic = (ComputationRecipeLogic)capability).shouldShowDuration());
            subTag.func_74768_a("Progress", capability.getProgress());
            subTag.func_74768_a("MaxProgress", capability.getMaxProgress());
        }
        tag.func_74782_a("gregtech.IWorkable", (NBTBase)subTag);
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag;
        boolean active;
        if (!config.getConfig("gregtech.workable") || accessor.getTileEntity() == null) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.IWorkable") && (active = (tag = accessor.getNBTData().func_74775_l("gregtech.IWorkable")).func_74767_n("Active"))) {
            int progress = tag.func_74762_e("Progress");
            int maxProgress = tag.func_74762_e("MaxProgress");
            if (tag.func_74767_n("ShowAsComputation")) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.waila.progress_computation", (Object[])new Object[]{progress, maxProgress}));
            }
            if (maxProgress == 0) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.waila.progress_idle", (Object[])new Object[0]));
            } else if (maxProgress < 20) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.waila.progress_tick", (Object[])new Object[]{progress, maxProgress}));
            } else {
                progress = Math.round((float)progress / 20.0f);
                maxProgress = Math.round((float)maxProgress / 20.0f);
                tooltip.add(I18n.func_135052_a((String)"gregtech.waila.progress_sec", (Object[])new Object[]{progress, maxProgress}));
            }
        }
        return super.getWailaBody(itemStack, tooltip, accessor, config);
    }
}

