/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.basic;

import com.google.common.collect.ImmutableList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.recipes.chance.output.ChancedOutputLogic;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.integration.jei.basic.BasicRecipeCategory;
import gregtech.integration.jei.basic.OreByProduct;
import gregtech.integration.jei.utils.render.FluidStackTextRenderer;
import gregtech.integration.jei.utils.render.ItemStackTextRenderer;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreByProductCategory
extends BasicRecipeCategory<OreByProduct, OreByProduct> {
    protected final IDrawable slot;
    protected final IDrawable fluidSlot;
    protected final IDrawable arrowsBase;
    protected final IDrawable arrowsDirectSmelt;
    protected final IDrawable arrowsChemBath;
    protected final IDrawable arrowsSeparator;
    protected final IDrawable arrowsSifter;
    protected final IDrawable icon;
    protected final List<Boolean> itemOutputExists = new ArrayList<Boolean>();
    protected final List<Boolean> fluidInputExists = new ArrayList<Boolean>();
    protected boolean hasDirectSmelt;
    protected boolean hasChemBath;
    protected boolean hasSeparator;
    protected boolean hasSifter;
    protected static final ImmutableList<Integer> ITEM_INPUT_LOCATIONS = ImmutableList.of((Object)3, (Object)3, (Object)23, (Object)3, (Object)3, (Object)24, (Object)23, (Object)71, (Object)50, (Object)80, (Object)24, (Object)25, (Object[])new Integer[]{97, 71, 70, 80, 114, 48, 133, 71, 3, 123, 41, 145, 102, 145, 24, 48, 155, 71, 101, 25});
    protected static final ImmutableList<Integer> ITEM_OUTPUT_LOCATIONS = ImmutableList.of((Object)46, (Object)3, (Object)3, (Object)47, (Object)3, (Object)65, (Object)23, (Object)92, (Object)23, (Object)110, (Object)50, (Object)101, (Object[])new Integer[]{50, 119, 64, 25, 82, 25, 97, 92, 97, 110, 70, 101, 70, 119, 137, 47, 155, 47, 133, 92, 133, 110, 3, 105, 3, 145, 23, 145, 63, 145, 84, 145, 124, 145, 64, 48, 82, 48, 155, 92, 155, 110, 155, 128, 119, 3, 137, 3, 155, 3, 119, 21, 137, 21, 155, 21});
    protected static final ImmutableList<Integer> FLUID_LOCATIONS = ImmutableList.of((Object)42, (Object)25, (Object)42, (Object)48);

    public OreByProductCategory(IGuiHelper guiHelper) {
        super("ore_by_product", "recipemap.byproductlist.name", (IDrawable)guiHelper.createBlankDrawable(176, 166), guiHelper);
        this.slot = guiHelper.drawableBuilder(GuiTextures.SLOT.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
        this.fluidSlot = guiHelper.drawableBuilder(GuiTextures.FLUID_SLOT.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
        String baseloc = "gregtech:textures/gui/arrows/";
        this.arrowsBase = guiHelper.drawableBuilder(new ResourceLocation(baseloc + "oreby-base.png"), 0, 0, 176, 166).setTextureSize(176, 166).build();
        this.arrowsDirectSmelt = guiHelper.drawableBuilder(new ResourceLocation(baseloc + "oreby-smelt.png"), 0, 0, 176, 166).setTextureSize(176, 166).build();
        this.arrowsChemBath = guiHelper.drawableBuilder(new ResourceLocation(baseloc + "oreby-chem.png"), 0, 0, 176, 166).setTextureSize(176, 166).build();
        this.arrowsSeparator = guiHelper.drawableBuilder(new ResourceLocation(baseloc + "oreby-sep.png"), 0, 0, 176, 166).setTextureSize(176, 166).build();
        this.arrowsSifter = guiHelper.drawableBuilder(new ResourceLocation(baseloc + "oreby-sift.png"), 0, 0, 176, 166).setTextureSize(176, 166).build();
        this.icon = guiHelper.createDrawableIngredient((Object)OreDictUnifier.get(OrePrefix.ore, Materials.Iron));
    }

    public void setRecipe(IRecipeLayout recipeLayout, @NotNull OreByProduct recipeWrapper, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStackGroup = recipeLayout.getFluidStacks();
        List itemInputs = ingredients.getInputs(VanillaTypes.ITEM);
        for (int i = 0; i < ITEM_INPUT_LOCATIONS.size(); i += 2) {
            itemStackGroup.init(i / 2, true, ((Integer)ITEM_INPUT_LOCATIONS.get(i)).intValue(), ((Integer)ITEM_INPUT_LOCATIONS.get(i + 1)).intValue());
        }
        List itemOutputs = ingredients.getOutputs(VanillaTypes.ITEM);
        this.itemOutputExists.clear();
        for (int i = 0; i < ITEM_OUTPUT_LOCATIONS.size(); i += 2) {
            itemStackGroup.init(i / 2 + itemInputs.size(), false, (IIngredientRenderer)new ItemStackTextRenderer(recipeWrapper.getChance(i / 2 + itemInputs.size()), ChancedOutputLogic.OR), (Integer)ITEM_OUTPUT_LOCATIONS.get(i) + 1, (Integer)ITEM_OUTPUT_LOCATIONS.get(i + 1) + 1, 16, 16, 0, 0);
            this.itemOutputExists.add(!((List)itemOutputs.get(i / 2)).isEmpty());
        }
        List fluidInputs = ingredients.getInputs(VanillaTypes.FLUID);
        this.fluidInputExists.clear();
        for (int i = 0; i < FLUID_LOCATIONS.size(); i += 2) {
            fluidStackGroup.init(i / 2, true, (IIngredientRenderer)new FluidStackTextRenderer(1, false, 16, 16, null), (Integer)FLUID_LOCATIONS.get(i) + 1, (Integer)FLUID_LOCATIONS.get(i + 1) + 1, 16, 16, 0, 0);
            this.fluidInputExists.add(!((List)fluidInputs.get(i / 2)).isEmpty());
        }
        itemStackGroup.addTooltipCallback(recipeWrapper::addTooltip);
        itemStackGroup.set(ingredients);
        fluidStackGroup.set(ingredients);
        this.hasDirectSmelt = recipeWrapper.hasDirectSmelt();
        this.hasChemBath = recipeWrapper.hasChemBath();
        this.hasSeparator = recipeWrapper.hasSeparator();
        this.hasSifter = recipeWrapper.hasSifter();
    }

    @NotNull
    public IRecipeWrapper getRecipeWrapper(@NotNull OreByProduct recipe) {
        return recipe;
    }

    @Override
    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void drawExtras(@NotNull Minecraft minecraft) {
        int i;
        this.arrowsBase.draw(minecraft, 0, 0);
        if (this.hasDirectSmelt) {
            this.arrowsDirectSmelt.draw(minecraft, 0, 0);
        }
        if (this.hasChemBath) {
            this.arrowsChemBath.draw(minecraft, 0, 0);
        }
        if (this.hasSeparator) {
            this.arrowsSeparator.draw(minecraft, 0, 0);
        }
        if (this.hasSifter) {
            this.arrowsSifter.draw(minecraft, 0, 0);
        }
        this.slot.draw(minecraft, ((Integer)ITEM_INPUT_LOCATIONS.get(0)).intValue(), ((Integer)ITEM_INPUT_LOCATIONS.get(1)).intValue());
        for (i = 0; i < ITEM_OUTPUT_LOCATIONS.size(); i += 2) {
            if (!this.itemOutputExists.get(i / 2).booleanValue() && (i < 56 || !this.hasSifter)) continue;
            this.slot.draw(minecraft, ((Integer)ITEM_OUTPUT_LOCATIONS.get(i)).intValue(), ((Integer)ITEM_OUTPUT_LOCATIONS.get(i + 1)).intValue());
        }
        for (i = 0; i < FLUID_LOCATIONS.size(); i += 2) {
            if (!this.fluidInputExists.get(i / 2).booleanValue()) continue;
            this.fluidSlot.draw(minecraft, ((Integer)FLUID_LOCATIONS.get(i)).intValue(), ((Integer)FLUID_LOCATIONS.get(i + 1)).intValue());
        }
    }
}

