/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.recipe;

import gregtech.api.GTValues;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IDataItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.chance.boost.BoostableChanceEntry;
import gregtech.api.recipes.chance.output.ChancedOutputLogic;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.machines.IResearchRecipeMap;
import gregtech.api.recipes.machines.IScannerRecipeMap;
import gregtech.api.recipes.recipeproperties.ComputationProperty;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.recipes.recipeproperties.ScanProperty;
import gregtech.api.recipes.recipeproperties.TotalComputationProperty;
import gregtech.api.util.AssemblyLineManager;
import gregtech.api.util.ClipboardUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.utils.TooltipHelper;
import gregtech.integration.RecipeCompatUtil;
import gregtech.integration.jei.utils.AdvancedRecipeWrapper;
import gregtech.integration.jei.utils.JeiButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTRecipeWrapper
extends AdvancedRecipeWrapper {
    private static final int LINE_HEIGHT = 10;
    private final RecipeMap<?> recipeMap;
    private final Recipe recipe;
    private final List<GTRecipeInput> sortedInputs;
    private final List<GTRecipeInput> sortedFluidInputs;

    public GTRecipeWrapper(RecipeMap<?> recipeMap, Recipe recipe) {
        this.recipeMap = recipeMap;
        this.recipe = recipe;
        this.sortedInputs = new ArrayList<GTRecipeInput>(recipe.getInputs());
        this.sortedInputs.sort(GTRecipeInput.RECIPE_INPUT_COMPARATOR);
        this.sortedFluidInputs = new ArrayList<GTRecipeInput>(recipe.getFluidInputs());
        this.sortedFluidInputs.sort(GTRecipeInput.RECIPE_INPUT_COMPARATOR);
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public void getIngredients(@NotNull IIngredients ingredients) {
        List recipeOutputs;
        Object stacks;
        ArrayList list;
        if (!this.sortedInputs.isEmpty()) {
            list = new ArrayList();
            for (GTRecipeInput input : this.sortedInputs) {
                stacks = new ArrayList<ItemStack>();
                for (ItemStack stack : input.getInputStacks()) {
                    stacks.add(stack.func_77946_l());
                }
                list.add(stacks);
            }
            ingredients.setInputLists(VanillaTypes.ITEM, list);
        }
        if (!this.sortedFluidInputs.isEmpty()) {
            list = new ArrayList();
            for (GTRecipeInput input : this.sortedFluidInputs) {
                list.add(input.getInputFluidStack());
            }
            ingredients.setInputs(VanillaTypes.FLUID, list);
        }
        if (!this.recipe.getOutputs().isEmpty() || !this.recipe.getChancedOutputs().getChancedEntries().isEmpty()) {
            recipeOutputs = this.recipe.getOutputs().stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
            ArrayList<ItemStack> scannerPossibilities = null;
            if (this.recipeMap instanceof IScannerRecipeMap) {
                Object stack;
                scannerPossibilities = new ArrayList<ItemStack>();
                String researchId = null;
                stacks = this.recipe.getOutputs().iterator();
                while (stacks.hasNext() && (researchId = AssemblyLineManager.readResearchId((ItemStack)(stack = (ItemStack)stacks.next()))) == null) {
                }
                if (researchId != null) {
                    Collection<Recipe> possibleRecipes = ((IResearchRecipeMap)((Object)RecipeMaps.ASSEMBLY_LINE_RECIPES)).getDataStickEntry(researchId);
                    if (possibleRecipes != null) {
                        for (Recipe r : possibleRecipes) {
                            ItemStack researchItem = (ItemStack)r.getOutputs().get(0);
                            researchItem = researchItem.func_77946_l();
                            researchItem.func_190920_e(1);
                            boolean didMatch = false;
                            for (ItemStack stack2 : scannerPossibilities) {
                                if (!ItemStack.func_77989_b((ItemStack)stack2, (ItemStack)researchItem)) continue;
                                didMatch = true;
                                break;
                            }
                            if (didMatch) continue;
                            scannerPossibilities.add(researchItem);
                        }
                    }
                    scannerPossibilities.add((ItemStack)recipeOutputs.get(0));
                }
            }
            ArrayList<ChancedItemOutput> chancedOutputs = new ArrayList<ChancedItemOutput>(this.recipe.getChancedOutputs().getChancedEntries());
            for (ChancedItemOutput chancedEntry : chancedOutputs) {
                recipeOutputs.add((ItemStack)chancedEntry.getIngredient());
            }
            if (scannerPossibilities == null || scannerPossibilities.isEmpty()) {
                ingredients.setOutputs(VanillaTypes.ITEM, recipeOutputs);
            } else {
                ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(scannerPossibilities));
            }
        }
        if (!this.recipe.getFluidOutputs().isEmpty() || !this.recipe.getChancedFluidOutputs().getChancedEntries().isEmpty()) {
            recipeOutputs = this.recipe.getFluidOutputs().stream().map(FluidStack::copy).collect(Collectors.toList());
            ArrayList<ChancedFluidOutput> chancedOutputs = new ArrayList<ChancedFluidOutput>(this.recipe.getChancedFluidOutputs().getChancedEntries());
            for (ChancedFluidOutput chancedEntry : chancedOutputs) {
                recipeOutputs.add((FluidStack)chancedEntry.getIngredient());
            }
            ingredients.setOutputs(VanillaTypes.FLUID, recipeOutputs);
        }
    }

    public void addItemTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        int outputIndex;
        boolean notConsumed = input && this.isNotConsumedItem(slotIndex);
        BoostableChanceEntry entry = null;
        if (!input && !this.recipe.getChancedOutputs().getChancedEntries().isEmpty() && (outputIndex = slotIndex - this.recipeMap.getMaxInputs()) >= this.recipe.getOutputs().size()) {
            entry = this.recipe.getChancedOutputs().getChancedEntries().get(outputIndex - this.recipe.getOutputs().size());
        }
        this.addIngredientTooltips(tooltip, notConsumed, input, entry, this.recipe.getChancedOutputs().getChancedOutputLogic());
        this.addIngredientTooltips(tooltip, notConsumed, input, ingredient, null);
    }

    public void addFluidTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        int outputIndex;
        FluidStack fluidStack = (FluidStack)ingredient;
        TankWidget.addIngotMolFluidTooltip(fluidStack, tooltip);
        boolean notConsumed = input && this.isNotConsumedFluid(slotIndex);
        BoostableChanceEntry entry = null;
        if (!this.recipe.getChancedFluidOutputs().getChancedEntries().isEmpty() && (outputIndex = slotIndex - this.recipeMap.getMaxFluidInputs()) >= this.recipe.getFluidOutputs().size()) {
            entry = this.recipe.getChancedFluidOutputs().getChancedEntries().get(outputIndex - this.recipe.getFluidOutputs().size());
        }
        this.addIngredientTooltips(tooltip, notConsumed, input, entry, this.recipe.getChancedFluidOutputs().getChancedOutputLogic());
        this.addIngredientTooltips(tooltip, notConsumed, input, ingredient, null);
    }

    public void addIngredientTooltips(@NotNull Collection<String> tooltip, boolean notConsumed, boolean input, @Nullable Object ingredient, @Nullable Object ingredient2) {
        ItemStack stack;
        if (ingredient2 instanceof ChancedOutputLogic) {
            ChancedOutputLogic logic = (ChancedOutputLogic)ingredient2;
            if (ingredient instanceof BoostableChanceEntry) {
                BoostableChanceEntry entry = (BoostableChanceEntry)ingredient;
                double chance = (double)entry.getChance() / 100.0;
                double boost = (double)entry.getChanceBoost() / 100.0;
                if (logic != ChancedOutputLogic.NONE && logic != ChancedOutputLogic.OR) {
                    tooltip.add(TooltipHelper.BLINKING_CYAN + I18n.func_135052_a((String)"gregtech.recipe.chance_logic", (Object[])new Object[]{chance, boost, I18n.func_135052_a((String)logic.getTranslationKey(), (Object[])new Object[0])}));
                } else {
                    tooltip.add(TooltipHelper.BLINKING_CYAN + I18n.func_135052_a((String)"gregtech.recipe.chance", (Object[])new Object[]{chance, boost}));
                }
            }
        } else if (notConsumed) {
            tooltip.add(TooltipHelper.BLINKING_CYAN + I18n.func_135052_a((String)"gregtech.recipe.not_consumed", (Object[])new Object[0]));
        }
        if (!input && this.recipeMap instanceof IScannerRecipeMap && ingredient instanceof ItemStack && !(stack = (ItemStack)ingredient).func_190926_b()) {
            if (stack.func_77973_b() instanceof IDataItem) {
                return;
            }
            Item item = stack.func_77973_b();
            if (item instanceof MetaItem) {
                MetaItem metaItem = (MetaItem)item;
                for (IItemBehaviour behaviour : metaItem.getBehaviours(stack)) {
                    if (!(behaviour instanceof IDataItem)) continue;
                    return;
                }
            }
            if (this.recipe.hasProperty(ScanProperty.getInstance())) {
                tooltip.add(TooltipHelper.BLINKING_CYAN + I18n.func_135052_a((String)"gregtech.recipe.research_result", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void drawInfo(@NotNull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        Set<RecipeProperty<?>> properties = this.recipe.getPropertyTypes();
        boolean drawTotalEU = properties.isEmpty() || properties.stream().noneMatch(RecipeProperty::hideTotalEU);
        boolean drawEUt = properties.isEmpty() || properties.stream().noneMatch(RecipeProperty::hideEUt);
        boolean drawDuration = properties.isEmpty() || properties.stream().noneMatch(RecipeProperty::hideDuration);
        int defaultLines = 0;
        if (drawTotalEU) {
            ++defaultLines;
        }
        if (drawEUt) {
            ++defaultLines;
        }
        if (drawDuration) {
            ++defaultLines;
        }
        int yPosition = recipeHeight - ((this.recipe.getUnhiddenPropertyCount() + defaultLines) * 10 - 3);
        if (drawTotalEU) {
            long eu = Math.abs((long)this.recipe.getEUt()) * (long)this.recipe.getDuration();
            if (this.recipe.hasProperty(TotalComputationProperty.getInstance()) && this.recipe.hasProperty(ComputationProperty.getInstance())) {
                int minimumCWUt = this.recipe.getProperty(ComputationProperty.getInstance(), 1);
                minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.max_eu", (Object[])new Object[]{eu / (long)minimumCWUt}), 0, yPosition, 0x111111);
            } else {
                minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.total", (Object[])new Object[]{eu}), 0, yPosition, 0x111111);
            }
        }
        if (drawEUt) {
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)(this.recipe.getEUt() >= 0 ? "gregtech.recipe.eu" : "gregtech.recipe.eu_inverted"), (Object[])new Object[]{Math.abs(this.recipe.getEUt()), GTValues.VN[GTUtility.getTierByVoltage(this.recipe.getEUt())]}), 0, yPosition += 10, 0x111111);
        }
        if (drawDuration) {
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.duration", (Object[])new Object[]{TextFormattingUtil.formatNumbers((double)this.recipe.getDuration() / 20.0)}), 0, yPosition += 10, 0x111111);
        }
        for (Map.Entry<RecipeProperty<?>, Object> propertyEntry : this.recipe.getPropertyValues()) {
            if (propertyEntry.getKey().isHidden()) continue;
            RecipeProperty<?> property = propertyEntry.getKey();
            Object value = propertyEntry.getValue();
            property.drawInfo(minecraft, 0, yPosition += property.getInfoHeight(value), 0x111111, value, mouseX, mouseY);
        }
    }

    @NotNull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> tooltips = new ArrayList<String>();
        for (Map.Entry<RecipeProperty<?>, Object> entry : this.recipe.getPropertyValues()) {
            if (entry.getKey().isHidden()) continue;
            RecipeProperty<?> property = entry.getKey();
            Object value = entry.getValue();
            property.getTooltipStrings(tooltips, mouseX, mouseY, value);
        }
        return tooltips;
    }

    @Override
    public void initExtras() {
        if (!RecipeCompatUtil.isTweakerLoaded()) {
            return;
        }
        BooleanSupplier creativePlayerCtPredicate = () -> Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184812_l_();
        this.buttons.add(new JeiButton(166.0f, 2.0f, 10, 10).setTextures(GuiTextures.BUTTON_CLEAR_GRID).setTooltipBuilder(lines -> lines.add("Copies a " + RecipeCompatUtil.getTweakerName() + " script, to remove this recipe, to the clipboard")).setClickAction((minecraft, mouseX, mouseY, mouseButton) -> {
            String recipeLine = RecipeCompatUtil.getRecipeRemoveLine(this.recipeMap, this.recipe);
            String output = RecipeCompatUtil.getFirstOutputString(this.recipe);
            if (!output.isEmpty()) {
                output = "// " + output + "\n";
            }
            String copyString = output + recipeLine + "\n";
            ClipboardUtil.copyToClipboard(copyString);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Copied [\u00a76" + recipeLine + "\u00a7r] to the clipboard"));
            return true;
        }).setActiveSupplier(creativePlayerCtPredicate));
    }

    public ChancedItemOutput getOutputChance(int slot) {
        if (slot >= this.recipe.getChancedOutputs().getChancedEntries().size() || slot < 0) {
            return null;
        }
        return this.recipe.getChancedOutputs().getChancedEntries().get(slot);
    }

    public ChancedOutputLogic getChancedOutputLogic() {
        return this.recipe.getChancedOutputs().getChancedOutputLogic();
    }

    public ChancedFluidOutput getFluidOutputChance(int slot) {
        if (slot >= this.recipe.getChancedFluidOutputs().getChancedEntries().size() || slot < 0) {
            return null;
        }
        return this.recipe.getChancedFluidOutputs().getChancedEntries().get(slot);
    }

    public ChancedOutputLogic getChancedFluidOutputLogic() {
        return this.recipe.getChancedFluidOutputs().getChancedOutputLogic();
    }

    public boolean isNotConsumedItem(int slot) {
        return slot < this.sortedInputs.size() && this.sortedInputs.get(slot).isNonConsumable();
    }

    public boolean isNotConsumedFluid(int slot) {
        return slot < this.sortedFluidInputs.size() && this.sortedFluidInputs.get(slot).isNonConsumable();
    }
}

