/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.drivers;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.integration.opencomputers.drivers.EnvironmentMetaTileEntity;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverEnergyContainer
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return IEnergyContainer.class;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            return tileEntity.hasCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, side);
        }
        return false;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            return new EnvironmentIEnergyContainer((IGregTechTileEntity)tileEntity, (IEnergyContainer)tileEntity.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, side));
        }
        return null;
    }

    public static final class EnvironmentIEnergyContainer
    extends EnvironmentMetaTileEntity<IEnergyContainer> {
        public EnvironmentIEnergyContainer(IGregTechTileEntity holder, IEnergyContainer capability) {
            super(holder, capability, "gt_energyContainer");
        }

        @Callback(doc="function():number --  Returns the amount of electricity contained in this Block, in EU units!")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((IEnergyContainer)this.tileEntity).getEnergyStored()};
        }

        @Callback(doc="function():number --  Returns the amount of electricity containable in this Block, in EU units!")
        public Object[] getEnergyCapacity(Context context, Arguments args) {
            return new Object[]{((IEnergyContainer)this.tileEntity).getEnergyCapacity()};
        }

        @Callback(doc="function():number --  Gets the Output in EU/p.")
        public Object[] getOutputVoltage(Context context, Arguments args) {
            return new Object[]{((IEnergyContainer)this.tileEntity).getOutputVoltage()};
        }

        @Callback(doc="function():number -- Gets the amount of Energy Packets per tick.")
        public Object[] getOutputAmperage(Context context, Arguments args) {
            return new Object[]{((IEnergyContainer)this.tileEntity).getOutputAmperage()};
        }

        @Callback(doc="function():number -- Gets the maximum Input in EU/p.")
        public Object[] getInputVoltage(Context context, Arguments args) {
            return new Object[]{((IEnergyContainer)this.tileEntity).getInputVoltage()};
        }

        @Callback(doc="function():number -- Gets the amount of Energy Packets per tick.")
        public Object[] getInputAmperage(Context context, Arguments args) {
            return new Object[]{((IEnergyContainer)this.tileEntity).getInputAmperage()};
        }

        @Callback(doc="function():number -- Gets the energy input per second.")
        public Object[] getInputPerSec(Context context, Arguments args) {
            return new Object[]{((IEnergyContainer)this.tileEntity).getInputPerSec()};
        }

        @Callback(doc="function():number -- Gets the energy output per second.")
        public Object[] getOutputPerSec(Context context, Arguments args) {
            return new Object[]{((IEnergyContainer)this.tileEntity).getOutputPerSec()};
        }
    }
}

