/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverHolder;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverEnderFluidLink;
import gregtech.common.covers.CoverFluidFilter;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.covers.CoverFluidVoiding;
import gregtech.common.covers.CoverFluidVoidingAdvanced;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverItemVoiding;
import gregtech.common.covers.CoverItemVoidingAdvanced;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.covers.IFilterMode;
import gregtech.common.covers.IIOMode;
import gregtech.common.covers.TransferMode;
import gregtech.common.covers.VoidingMode;
import gregtech.common.covers.filter.FluidFilter;
import gregtech.common.covers.filter.FluidFilterContainer;
import gregtech.common.covers.filter.ItemFilter;
import gregtech.common.covers.filter.ItemFilterContainer;
import gregtech.common.covers.filter.OreDictionaryItemFilter;
import gregtech.common.covers.filter.SmartItemFilter;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverInfoProvider
extends CapabilityInfoProvider<CoverHolder> {
    @Override
    @NotNull
    protected Capability<CoverHolder> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_COVER_HOLDER;
    }

    public String getID() {
        return "gregtech:coverable_provider";
    }

    @Override
    protected void addProbeInfo(@NotNull CoverHolder capability, @NotNull IProbeInfo probeInfo, @NotNull EntityPlayer player, @NotNull TileEntity tileEntity, @NotNull IProbeHitData data) {
        Cover cover = capability.getCoverAtSide(data.getSideHit());
        if (cover instanceof CoverConveyor) {
            CoverConveyor conveyor = (CoverConveyor)cover;
            CoverInfoProvider.conveyorInfo(probeInfo, conveyor);
        } else if (cover instanceof CoverPump) {
            CoverPump coverPump = (CoverPump)cover;
            CoverInfoProvider.pumpInfo(probeInfo, coverPump);
        } else if (cover instanceof CoverItemFilter) {
            CoverItemFilter itemFilter = (CoverItemFilter)cover;
            CoverInfoProvider.itemFilterInfo(probeInfo, itemFilter);
        } else if (cover instanceof CoverFluidFilter) {
            CoverFluidFilter fluidFilter = (CoverFluidFilter)cover;
            CoverInfoProvider.fluidFilterInfo(probeInfo, fluidFilter);
        } else if (cover instanceof CoverEnderFluidLink) {
            CoverEnderFluidLink enderFluidLink = (CoverEnderFluidLink)cover;
            CoverInfoProvider.enderFluidLinkInfo(probeInfo, enderFluidLink);
        }
    }

    private static void conveyorInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverConveyor conveyor) {
        String rateUnit = " {*cover.conveyor.transfer_rate*}";
        if (conveyor instanceof CoverItemVoiding) {
            CoverInfoProvider.itemVoidingInfo(probeInfo, (CoverItemVoiding)conveyor);
        } else if (!(conveyor instanceof CoverRoboticArm) || ((CoverRoboticArm)conveyor).getTransferMode() == TransferMode.TRANSFER_ANY) {
            CoverInfoProvider.transferRateText(probeInfo, conveyor.getConveyorMode(), rateUnit, conveyor.getTransferRate());
        }
        ItemFilterContainer filter = conveyor.getItemFilterContainer();
        if (conveyor instanceof CoverRoboticArm) {
            CoverRoboticArm roboticArm = (CoverRoboticArm)conveyor;
            CoverInfoProvider.transferModeText(probeInfo, roboticArm.getTransferMode(), rateUnit, filter.getTransferStackSize(), filter.getFilterWrapper().getItemFilter() != null);
        }
        CoverInfoProvider.itemFilterText(probeInfo, filter.getFilterWrapper().getItemFilter());
    }

    private static void itemVoidingInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverItemVoiding voiding) {
        String unit = " {*gregtech.top.unit.items*}";
        ItemFilterContainer container = voiding.getItemFilterContainer();
        if (voiding instanceof CoverItemVoidingAdvanced) {
            CoverItemVoidingAdvanced advanced = (CoverItemVoidingAdvanced)voiding;
            VoidingMode mode = advanced.getVoidingMode();
            CoverInfoProvider.voidingText(probeInfo, mode, unit, container.getTransferStackSize(), container.getFilterWrapper().getItemFilter() != null);
        }
    }

    private static void pumpInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverPump pump) {
        String rateUnit = "{*" + pump.getBucketMode().func_176610_l() + "*}";
        if (pump instanceof CoverFluidVoiding) {
            CoverInfoProvider.fluidVoidingInfo(probeInfo, (CoverFluidVoiding)pump);
        } else if (!(pump instanceof CoverFluidRegulator) || ((CoverFluidRegulator)pump).getTransferMode() == TransferMode.TRANSFER_ANY) {
            CoverInfoProvider.transferRateText(probeInfo, pump.getPumpMode(), " " + rateUnit, pump.getBucketMode() == CoverPump.BucketMode.BUCKET ? pump.getTransferRate() / 1000 : pump.getTransferRate());
        }
        FluidFilterContainer filter = pump.getFluidFilterContainer();
        if (pump instanceof CoverFluidRegulator) {
            CoverFluidRegulator regulator = (CoverFluidRegulator)pump;
            CoverInfoProvider.transferModeText(probeInfo, regulator.getTransferMode(), rateUnit, regulator.getTransferAmount(), filter.getFilterWrapper().getFluidFilter() != null);
        }
        CoverInfoProvider.fluidFilterText(probeInfo, filter.getFilterWrapper().getFluidFilter());
    }

    private static void fluidVoidingInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverFluidVoiding voiding) {
        String unit;
        String string = unit = voiding.getBucketMode() == CoverPump.BucketMode.BUCKET ? " {*gregtech.top.unit.fluid_buckets*}" : " {*gregtech.top.unit.fluid_milibuckets*}";
        if (voiding instanceof CoverFluidVoidingAdvanced) {
            CoverFluidVoidingAdvanced advanced = (CoverFluidVoidingAdvanced)voiding;
            VoidingMode mode = advanced.getVoidingMode();
            CoverInfoProvider.voidingText(probeInfo, mode, unit, voiding.getBucketMode() == CoverPump.BucketMode.BUCKET ? advanced.getTransferAmount() / 1000 : advanced.getTransferAmount(), voiding.getFluidFilterContainer().getFilterWrapper().getFluidFilter() != null);
        }
    }

    private static void itemFilterInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverItemFilter itemFilter) {
        CoverInfoProvider.filterModeText(probeInfo, itemFilter.getFilterMode());
        CoverInfoProvider.itemFilterText(probeInfo, itemFilter.getItemFilter().getItemFilter());
    }

    private static void fluidFilterInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverFluidFilter fluidFilter) {
        CoverInfoProvider.filterModeText(probeInfo, fluidFilter.getFilterMode());
        CoverInfoProvider.fluidFilterText(probeInfo, fluidFilter.getFluidFilter().getFluidFilter());
    }

    private static void enderFluidLinkInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverEnderFluidLink enderFluidLink) {
        CoverInfoProvider.transferRateText(probeInfo, enderFluidLink.getPumpMode(), " {*cover.bucket.mode.milli_bucket*}", enderFluidLink.isIOEnabled() ? 8000 : 0);
        CoverInfoProvider.fluidFilterText(probeInfo, enderFluidLink.getFluidFilterContainer().getFilterWrapper().getFluidFilter());
        if (!enderFluidLink.getColorStr().isEmpty()) {
            probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.link_cover.color*} " + enderFluidLink.getColorStr());
        }
    }

    private static void transferRateText(@NotNull IProbeInfo probeInfo, @NotNull IIOMode mode, @NotNull String rateUnit, int rate) {
        String modeText = mode.isImport() ? "{*gregtech.top.mode.import*} " : "{*gregtech.top.mode.export*} ";
        probeInfo.text(TextStyleClass.OK + modeText + TextStyleClass.LABEL + TextFormattingUtil.formatNumbers(rate) + rateUnit);
    }

    private static void transferModeText(@NotNull IProbeInfo probeInfo, @NotNull TransferMode mode, @NotNull String rateUnit, int rate, boolean hasFilter) {
        String text = TextStyleClass.OK + "{*" + mode.func_176610_l() + "*}";
        if (!hasFilter && mode != TransferMode.TRANSFER_ANY) {
            text = text + TextStyleClass.LABEL + " " + TextFormattingUtil.formatNumbers(rate) + rateUnit;
        }
        probeInfo.text(text);
    }

    private static void voidingText(@NotNull IProbeInfo probeInfo, @NotNull VoidingMode mode, @NotNull String unit, int amount, boolean hasFilter) {
        String text = TextFormatting.RED + "{*" + mode.func_176610_l() + "*}";
        if (mode != VoidingMode.VOID_ANY && !hasFilter) {
            text = text + " " + TextFormattingUtil.formatNumbers(amount) + unit;
        }
        probeInfo.text(text);
    }

    private static void filterModeText(@NotNull IProbeInfo probeInfo, @NotNull IFilterMode mode) {
        probeInfo.text(TextStyleClass.WARNING + "{*" + mode.getName() + "*}");
    }

    private static void itemFilterText(@NotNull IProbeInfo probeInfo, @Nullable ItemFilter filter) {
        String label = TextStyleClass.INFO + "{*gregtech.top.filter.label*} ";
        if (filter instanceof OreDictionaryItemFilter) {
            String expression = ((OreDictionaryItemFilter)filter).getExpression();
            if (!expression.isEmpty()) {
                probeInfo.text(label + expression);
            }
        } else if (filter instanceof SmartItemFilter) {
            probeInfo.text(label + "{*" + ((SmartItemFilter)filter).getFilteringMode().func_176610_l() + "*}");
        }
    }

    private static void fluidFilterText(@NotNull IProbeInfo probeInfo, @Nullable FluidFilter filter) {
    }
}

