/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.xaero;

import java.awt.Color;

public class ColorUtility {
    static final double[][] M = new double[][]{{0.4124, 0.3576, 0.1805}, {0.2126, 0.7152, 0.0722}, {0.0193, 0.1192, 0.9505}};

    public static double[] getLab(Color colour, WhitePoint wp) {
        return ColorUtility.XYZtoLAB(ColorUtility.RGBtoXYZ(colour), wp);
    }

    public static double[] getLab(Color colour) {
        return ColorUtility.XYZtoLAB(ColorUtility.RGBtoXYZ(colour), WhitePoint.C);
    }

    static double[] RGBtoXYZ(Color colour) {
        double r = (double)colour.getRed() / 255.0;
        double g = (double)colour.getGreen() / 255.0;
        double b = (double)colour.getBlue() / 255.0;
        return ColorUtility.RGBtoXYZ(new double[]{r, g, b});
    }

    static double[] RGBtoXYZ(double[] rgb) {
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        r = r <= 0.04045 ? (r /= 12.92) : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.04045 ? (g /= 12.92) : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.04045 ? (b /= 12.92) : Math.pow((b + 0.055) / 1.055, 2.4);
        double[] result = new double[]{(r *= 100.0) * M[0][0] + (g *= 100.0) * M[0][1] + (b *= 100.0) * M[0][2], r * M[1][0] + g * M[1][1] + b * M[1][2], r * M[2][0] + g * M[2][1] + b * M[2][2]};
        return result;
    }

    static double[] XYZtoLAB(double[] XYZ, WhitePoint wp) {
        double x = XYZ[0] / wp.getTristimulus()[0];
        double y = XYZ[1] / wp.getTristimulus()[1];
        double z = XYZ[2] / wp.getTristimulus()[2];
        x = x > 0.008856 ? Math.pow(x, 0.3333333333333333) : 7.787 * x + 0.13793103448275862;
        y = y > 0.008856 ? Math.pow(y, 0.3333333333333333) : 7.787 * y + 0.13793103448275862;
        z = z > 0.008856 ? Math.pow(z, 0.3333333333333333) : 7.787 * z + 0.13793103448275862;
        return new double[]{116.0 * y - 16.0, 500.0 * (x - y), 200.0 * (y - z)};
    }

    public static enum WhitePoint {
        D50(96.4, 100.0, 82.5),
        D55(95.68, 100.0, 92.14),
        D65(95.04, 100.0, 108.88),
        D75(94.97, 100.0, 122.61),
        C(98.07, 100.0, 118.22);

        private double[] params;

        private WhitePoint(double X, double Y, double Z) {
            this.params = new double[]{X, Y, Z};
        }

        double[] getTristimulus() {
            return this.params;
        }
    }
}

