/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe.handlers;

import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.loaders.recipe.RecyclingRecipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class RecyclingRecipeHandler {
    private static final List<Object> CRUSHING_PREFIXES = Arrays.asList(OrePrefix.ingot, OrePrefix.gem, OrePrefix.stick, OrePrefix.plate, OrePrefix.plank, OrePrefix.ring, OrePrefix.stickLong, OrePrefix.foil, OrePrefix.bolt, OrePrefix.screw, OrePrefix.nugget, OrePrefix.gearSmall, OrePrefix.gear, OrePrefix.frameGt, OrePrefix.plateDense, OrePrefix.spring, OrePrefix.springSmall, OrePrefix.block, OrePrefix.wireFine, OrePrefix.rotor, OrePrefix.lens, OrePrefix.turbineBlade, OrePrefix.round, OrePrefix.plateDouble, OrePrefix.dust, orePrefix -> orePrefix.name().startsWith("toolHead"), orePrefix -> orePrefix.name().startsWith("gem"), orePrefix -> orePrefix.name().startsWith("cableGt"), orePrefix -> orePrefix.name().startsWith("wireGt"), orePrefix -> orePrefix.name().startsWith("pipe"));
    private static final List<OrePrefix> IGNORE_ARC_SMELTING = Arrays.asList(OrePrefix.ingot, OrePrefix.gem, OrePrefix.nugget);

    public static void register() {
        for (OrePrefix orePrefix : OrePrefix.values()) {
            if (!CRUSHING_PREFIXES.stream().anyMatch(object -> {
                if (object instanceof OrePrefix) {
                    return object == orePrefix;
                }
                if (object instanceof Predicate) {
                    return ((Predicate)object).test(orePrefix);
                }
                return false;
            })) continue;
            orePrefix.addProcessingHandler(PropertyKey.DUST, RecyclingRecipeHandler::processCrushing);
        }
    }

    public static void processCrushing(OrePrefix thingPrefix, Material material, DustProperty property) {
        ArrayList<MaterialStack> materialStacks = new ArrayList<MaterialStack>();
        materialStacks.add(new MaterialStack(material, thingPrefix.getMaterialAmount(material)));
        materialStacks.addAll(thingPrefix.secondaryMaterials);
        boolean ignoreArcSmelting = IGNORE_ARC_SMELTING.contains(thingPrefix) && (!material.hasProperty(PropertyKey.INGOT) || material.getProperty(PropertyKey.INGOT).getArcSmeltInto() == material);
        RecyclingRecipes.registerRecyclingRecipes(OreDictUnifier.get(thingPrefix, material), materialStacks, ignoreArcSmelting, thingPrefix);
    }
}

