/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.block.model;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.chameleon.model.CachedBuilderModel;
import com.jaquadro.minecraft.chameleon.model.PassLimitedModel;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGeometry;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.DrawerStateModelData;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerDecoratorModel;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerSealedModel;
import com.nomiceu.gregtechdrawers.GTDrawers;
import com.nomiceu.gregtechdrawers.block.BlockGTDrawers;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.logging.log4j.Level;

public final class GTDrawerModel {
    private static final ItemHandler itemHandler = new ItemHandler();

    private static class ItemHandler
    extends ItemOverrideList {
        public ItemHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel parent, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
            if (stack.func_190926_b()) {
                return parent;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_150297_b("tile", 10)) {
                return parent;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            IBlockState state = block.func_176203_a(stack.func_77960_j());
            return new DrawerSealedModel(parent, state, true);
        }
    }

    public static class Model
    extends ProxyBuilderModel {
        public Model(IBakedModel parent) {
            super(parent);
        }

        protected IBakedModel buildModel(IBlockState state, IBakedModel parent) {
            try {
                EnumBasicDrawer drawer = (EnumBasicDrawer)state.func_177229_b((IProperty)BlockStandardDrawers.BLOCK);
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING);
                if (!(state instanceof IExtendedBlockState)) {
                    return new PassLimitedModel(parent, BlockRenderLayer.CUTOUT_MIPPED);
                }
                IExtendedBlockState xstate = (IExtendedBlockState)state;
                DrawerStateModelData stateModel = (DrawerStateModelData)xstate.getValue(BlockDrawers.STATE_MODEL);
                if (!DrawerDecoratorModel.shouldHandleState((DrawerStateModelData)stateModel)) {
                    return new PassLimitedModel(parent, BlockRenderLayer.CUTOUT_MIPPED);
                }
                return new DrawerDecoratorModel(parent, xstate, (IDrawerGeometry)drawer, dir, stateModel);
            }
            catch (Throwable t) {
                GTDrawers.logger.log(Level.ERROR, (Object)t);
                return new PassLimitedModel(parent, BlockRenderLayer.CUTOUT_MIPPED);
            }
        }

        public ItemOverrideList func_188617_f() {
            return itemHandler;
        }

        public List<Object> getKey(IBlockState state) {
            try {
                ArrayList<Object> key = new ArrayList<Object>();
                IExtendedBlockState xstate = (IExtendedBlockState)state;
                key.add(xstate.getValue(BlockDrawers.STATE_MODEL));
                return key;
            }
            catch (Throwable t) {
                return super.getKey(state);
            }
        }
    }

    public static class Register
    extends DefaultRegister<BlockGTDrawers> {
        public Register(BlockGTDrawers block) {
            super((Block)block);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumBasicDrawer drawer : EnumBasicDrawer.values()) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    states.add(((BlockGTDrawers)this.getBlock()).func_176223_P().func_177226_a((IProperty)BlockStandardDrawers.BLOCK, (Comparable)drawer).func_177226_a((IProperty)BlockDrawers.FACING, (Comparable)dir));
                }
            }
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model(existingModel));
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model(existingModel));
        }

        public List<ResourceLocation> getTextureResources() {
            ArrayList<ResourceLocation> resource = new ArrayList<ResourceLocation>();
            resource.add(DrawerDecoratorModel.iconClaim);
            resource.add(DrawerDecoratorModel.iconClaimLock);
            resource.add(DrawerDecoratorModel.iconLock);
            resource.add(DrawerDecoratorModel.iconShroudCover);
            resource.add(DrawerDecoratorModel.iconVoid);
            resource.add(DrawerSealedModel.iconTapeCover);
            return resource;
        }
    }
}

