/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.event;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.nomiceu.gregtechdrawers.GTDrawers;
import com.nomiceu.gregtechdrawers.block.BlockGTDrawers;
import com.nomiceu.gregtechdrawers.block.BlockGTTrim;
import com.nomiceu.gregtechdrawers.item.ItemGTDrawers;
import com.nomiceu.gregtechdrawers.item.ItemGTTrim;
import com.nomiceu.gregtechdrawers.type.DrawerMaterial;
import com.nomiceu.gregtechdrawers.type.Mod;
import com.nomiceu.gregtechdrawers.type.Mods;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryEvents {
    private static final ResourceLocation EMPTY_GROUP = new ResourceLocation("", "");

    @SubscribeEvent
    public void onBlockRegistryEvent(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ConfigManager config = StorageDrawers.config;
        boolean trimEnabled = config.isBlockEnabled("trim");
        boolean anyDrawerEnabled = false;
        for (EnumBasicDrawer type : EnumBasicDrawer.values()) {
            if (!config.isBlockEnabled(type.getUnlocalizedName())) continue;
            anyDrawerEnabled = true;
            break;
        }
        for (Block block : Mods.BLOCKS) {
            boolean isDrawer = block instanceof BlockGTDrawers;
            boolean isTrim = block instanceof BlockGTTrim;
            if (isDrawer && !anyDrawerEnabled || isTrim && !trimEnabled) continue;
            registry.register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public void onItemRegistryEvent(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ConfigManager config = StorageDrawers.config;
        boolean trimEnabled = config.isBlockEnabled("trim");
        boolean anyDrawerEnabled = false;
        for (EnumBasicDrawer type : EnumBasicDrawer.values()) {
            if (!config.isBlockEnabled(type.getUnlocalizedName())) continue;
            anyDrawerEnabled = true;
            break;
        }
        for (Item item : Mods.ITEMS) {
            boolean isDrawer = item instanceof ItemGTDrawers;
            boolean isTrim = item instanceof ItemGTTrim;
            if (isDrawer && !anyDrawerEnabled || isTrim && !trimEnabled) continue;
            registry.register((IForgeRegistryEntry)item);
            if (isDrawer) {
                OreDictionary.registerOre((String)"drawerBasic", (ItemStack)new ItemStack(item, 1, Short.MAX_VALUE));
                continue;
            }
            if (!isTrim) continue;
            OreDictionary.registerOre((String)"drawerTrim", (Item)item);
        }
    }

    @SubscribeEvent
    public void onCraftingRegistryEvent(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Mod mod : Mods.ENABLED_MODS) {
            for (DrawerMaterial material : mod) {
                int count = 0;
                ArrayList<ItemStack> planks = new ArrayList<ItemStack>(material.planks.length);
                for (DrawerMaterial.AbstractItemStack plankAbstract : material.planks) {
                    ItemStack plank = plankAbstract.toItemStack(mod);
                    if (plank.func_190926_b()) {
                        GTDrawers.logger.warn("One of the planks for drawer material " + material.func_176610_l() + " is missing: " + plankAbstract);
                        continue;
                    }
                    RegistryEvents.registerPlankRecipes((IForgeRegistry<IRecipe>)registry, material.getDrawersBlock(), plank, count++);
                    planks.add(plank);
                }
                count = 0;
                for (DrawerMaterial.AbstractItemStack slabAbstract : material.slabs) {
                    ItemStack slab = slabAbstract.toItemStack(mod);
                    if (slab.func_190926_b()) {
                        GTDrawers.logger.warn("One of the slabs for drawer material " + material.func_176610_l() + " is missing: " + slabAbstract);
                        continue;
                    }
                    RegistryEvents.registerSlabRecipes((IForgeRegistry<IRecipe>)registry, material.getDrawersBlock(), slab, count++);
                }
                if (!StorageDrawers.config.isBlockEnabled("trim")) continue;
                count = 0;
                for (ItemStack plank : planks) {
                    RegistryEvents.registerTrimRecipe((IForgeRegistry<IRecipe>)registry, material.getTrimBlock(), plank, count++);
                }
            }
        }
    }

    @Nonnull
    public static ItemStack makeBasicDrawerItemStack(EnumBasicDrawer info, BlockGTDrawers block, int count) {
        return new ItemStack((Block)block, count, info.getMetadata());
    }

    public static void registerPlankRecipes(IForgeRegistry<IRecipe> registry, BlockGTDrawers block, ItemStack plankStack, int count) {
        ItemStack result;
        ConfigManager config = StorageDrawers.config;
        if (config.isBlockEnabled(EnumBasicDrawer.FULL1.getUnlocalizedName()) && !plankStack.func_190926_b()) {
            result = RegistryEvents.makeBasicDrawerItemStack(EnumBasicDrawer.FULL1, block, config.getBlockRecipeOutput(EnumBasicDrawer.FULL1.getUnlocalizedName()));
            registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xxx", " y ", "xxx", Character.valueOf('x'), plankStack, Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.FULL1.getUnlocalizedName() + "_" + block.mod + "_" + block.field_149764_J + "." + count)));
        }
        if (config.isBlockEnabled(EnumBasicDrawer.FULL2.getUnlocalizedName()) && !plankStack.func_190926_b()) {
            result = RegistryEvents.makeBasicDrawerItemStack(EnumBasicDrawer.FULL2, block, config.getBlockRecipeOutput(EnumBasicDrawer.FULL2.getUnlocalizedName()));
            registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), plankStack, Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.FULL2.getUnlocalizedName() + "_" + block.mod + "_" + block.field_149764_J + "." + count)));
        }
        if (config.isBlockEnabled(EnumBasicDrawer.FULL4.getUnlocalizedName()) && !plankStack.func_190926_b()) {
            result = RegistryEvents.makeBasicDrawerItemStack(EnumBasicDrawer.FULL4, block, config.getBlockRecipeOutput(EnumBasicDrawer.FULL4.getUnlocalizedName()));
            registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), plankStack, Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.FULL4.getUnlocalizedName() + "_" + block.mod + "_" + block.field_149764_J + "." + count)));
        }
    }

    public static void registerSlabRecipes(IForgeRegistry<IRecipe> registry, BlockGTDrawers block, ItemStack slabStack, int count) {
        ItemStack result;
        ConfigManager config = StorageDrawers.config;
        if (config.isBlockEnabled(EnumBasicDrawer.HALF2.getUnlocalizedName()) && !slabStack.func_190926_b()) {
            result = RegistryEvents.makeBasicDrawerItemStack(EnumBasicDrawer.HALF2, block, config.getBlockRecipeOutput(EnumBasicDrawer.HALF2.getUnlocalizedName()));
            registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), slabStack, Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.HALF2.getUnlocalizedName() + "_" + block.mod + "_" + block.field_149764_J + "." + count)));
        }
        if (config.isBlockEnabled(EnumBasicDrawer.HALF4.getUnlocalizedName()) && !slabStack.func_190926_b()) {
            result = RegistryEvents.makeBasicDrawerItemStack(EnumBasicDrawer.HALF4, block, config.getBlockRecipeOutput(EnumBasicDrawer.HALF4.getUnlocalizedName()));
            registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), slabStack, Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.HALF4.getUnlocalizedName() + "_" + block.mod + "_" + block.field_149764_J + "." + count)));
        }
    }

    public static void registerTrimRecipe(IForgeRegistry<IRecipe> registry, BlockGTTrim trim, ItemStack plankStack, int count) {
        ConfigManager config = StorageDrawers.config;
        if (!plankStack.func_190926_b()) {
            ItemStack result = new ItemStack((Block)trim, config.getBlockRecipeOutput("trim"));
            registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xyx", "yyy", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), plankStack}).setRegistryName(result.func_77973_b().getRegistryName() + "." + count)));
        }
    }
}

