/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.event;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.resources.ModelRegistry;
import com.jaquadro.minecraft.chameleon.resources.register.IUnifiedRegister;
import com.nomiceu.gregtechdrawers.block.BlockGTDrawers;
import com.nomiceu.gregtechdrawers.block.model.GTDrawerModel;
import com.nomiceu.gregtechdrawers.item.ItemGTTrim;
import com.nomiceu.gregtechdrawers.render.tileentity.TileEntityGTDrawersRenderer;
import com.nomiceu.gregtechdrawers.tileentity.TileEntityGTDrawers;
import com.nomiceu.gregtechdrawers.type.Mods;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderEvents {
    @SubscribeEvent
    public void onModelRegistryEvent(ModelRegistryEvent event) {
        for (ItemGTTrim trim : Mods.TRIM_ITEMS) {
            RenderEvents.registerItem((Item)trim);
        }
        ModelRegistry modelRegistry = Chameleon.instance.modelRegistry;
        for (BlockGTDrawers drawers : Mods.DRAWERS_BLOCKS) {
            drawers.initDynamic();
            modelRegistry.registerModel((IUnifiedRegister)new GTDrawerModel.Register(drawers));
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGTDrawers.class, (TileEntitySpecialRenderer)new TileEntityGTDrawersRenderer());
    }

    public static void registerItem(Item item) {
        RenderEvents.registerItem(item, 0);
    }

    public static void registerItem(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    public static void registerBlock(final BlockGTDrawers block) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("gregtechdrawers:basicdrawers_" + block.mod + "_" + block.field_149764_J, "block=" + state.func_177229_b((IProperty)BlockGTDrawers.BLOCK) + ",facing=" + state.func_177229_b((IProperty)BlockGTDrawers.FACING));
            }
        });
    }
}

