/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.item;

import com.jaquadro.minecraft.chameleon.resources.IItemMeshMapper;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.nomiceu.gregtechdrawers.block.BlockGTDrawers;
import com.nomiceu.gregtechdrawers.type.DrawerMaterial;
import com.nomiceu.gregtechdrawers.type.Mod;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemGTDrawers
extends ItemDrawers
implements IItemMeshMapper {
    public final Mod mod;
    public final DrawerMaterial material;

    public ItemGTDrawers(BlockGTDrawers block) {
        super((Block)block);
        this.mod = block.mod;
        this.material = block.field_149764_J;
        this.setRegistryName(block.getRegistryName());
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, List<String> list, ITooltipFlag advanced) {
        list.add(I18n.func_135052_a((String)"storagedrawers.material", (Object[])new Object[]{I18n.func_135052_a((String)("storagedrawers.material." + this.mod + '.' + this.material), (Object[])new Object[0])}));
        list.add(I18n.func_135052_a((String)"storagedrawers.drawers.description", (Object[])new Object[]{this.getCapacityForBlock(itemStack)}));
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("tile")) {
            list.add(ChatFormatting.YELLOW + I18n.func_135052_a((String)"storagedrawers.drawers.sealed", (Object[])new Object[0]));
        }
    }

    private int getCapacityForBlock(@Nonnull ItemStack itemStack) {
        ConfigManager config = StorageDrawers.config;
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block instanceof BlockStandardDrawers) {
            EnumBasicDrawer info = EnumBasicDrawer.byMetadata((int)itemStack.func_77960_j());
            switch (info) {
                case FULL1: {
                    return config.getBlockBaseStorage("fulldrawers1");
                }
                case FULL2: {
                    return config.getBlockBaseStorage("fulldrawers2");
                }
                case FULL4: {
                    return config.getBlockBaseStorage("fulldrawers4");
                }
                case HALF2: {
                    return config.getBlockBaseStorage("halfdrawers2");
                }
                case HALF4: {
                    return config.getBlockBaseStorage("halfdrawers4");
                }
            }
            return 0;
        }
        if (block == ModBlocks.compDrawers) {
            return config.getBlockBaseStorage("compDrawers");
        }
        return 0;
    }

    public String func_77667_c(@Nonnull ItemStack stack) {
        return super.func_77658_a() + "." + EnumBasicDrawer.byMetadata((int)stack.func_77960_j()).getUnlocalizedName();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w()) {
            ConfigManager config = StorageDrawers.config;
            for (EnumBasicDrawer type : EnumBasicDrawer.values()) {
                if (!config.isBlockEnabled(type.getUnlocalizedName())) continue;
                items.add((Object)new ItemStack((Item)this, 1, type.getMetadata()));
            }
        }
    }

    public List<Pair<ItemStack, ModelResourceLocation>> getMeshMappings() {
        return Arrays.stream(EnumBasicDrawer.values()).map(type -> Pair.of((Object)new ItemStack((Item)this, 1, type.getMetadata()), (Object)new ModelResourceLocation("gregtechdrawers:basicdrawers_" + type.func_176610_l() + "_" + this.mod + "_" + this.material, "inventory"))).collect(Collectors.toList());
    }
}

