/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.tileentity;

import com.jaquadro.minecraft.chameleon.block.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityGTDrawers
extends TileEntityDrawersStandard {
    @CapabilityInject(value=IDrawerAttributes.class)
    static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = null;
    private int capacity = 0;

    public static TileEntityGTDrawers createEntity(int slotCount) {
        switch (slotCount) {
            case 1: {
                return new Slot1();
            }
            case 2: {
                return new Slot2();
            }
            case 4: {
                return new Slot4();
            }
        }
        return null;
    }

    public IDrawerGroup getGroup() {
        return null;
    }

    public int getDrawerCapacity() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return super.getDrawerCapacity();
        }
        if (this.capacity == 0) {
            IBlockState blockState = this.func_145831_w().func_180495_p(this.field_174879_c);
            if (!blockState.func_177227_a().contains(BlockStandardDrawers.BLOCK)) {
                return 1;
            }
            EnumBasicDrawer type = (EnumBasicDrawer)blockState.func_177229_b((IProperty)BlockStandardDrawers.BLOCK);
            ConfigManager config = StorageDrawers.config;
            switch (type) {
                case FULL1: {
                    this.capacity = config.getBlockBaseStorage("fulldrawers1");
                    break;
                }
                case FULL2: {
                    this.capacity = config.getBlockBaseStorage("fulldrawers2");
                    break;
                }
                case FULL4: {
                    this.capacity = config.getBlockBaseStorage("fulldrawers4");
                    break;
                }
                case HALF2: {
                    this.capacity = config.getBlockBaseStorage("halfdrawers2");
                    break;
                }
                case HALF4: {
                    this.capacity = config.getBlockBaseStorage("halfdrawers4");
                    break;
                }
                default: {
                    this.capacity = 1;
                }
            }
            if (this.capacity <= 0) {
                this.capacity = 1;
            }
        }
        return this.capacity;
    }

    public static class Slot1
    extends TileEntityGTDrawers {
        private GroupData groupData = new GroupData(1);

        public Slot1() {
            this.groupData.setCapabilityProvider((ICapabilityProvider)this);
            this.injectPortableData((TileDataShim)this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        protected void onAttributeChanged() {
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends TileEntityGTDrawers {
        private GroupData groupData = new GroupData(2);

        public Slot2() {
            this.groupData.setCapabilityProvider((ICapabilityProvider)this);
            this.injectPortableData((TileDataShim)this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        protected void onAttributeChanged() {
            this.groupData.syncAttributes();
        }
    }

    public static class Slot4
    extends TileEntityGTDrawers {
        private GroupData groupData = new GroupData(4);

        public Slot4() {
            this.groupData.setCapabilityProvider((ICapabilityProvider)this);
            this.injectPortableData((TileDataShim)this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        protected void onAttributeChanged() {
            this.groupData.syncAttributes();
        }
    }

    private class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        protected int getStackCapacity() {
            return TileEntityGTDrawers.this.upgrades().getStorageMultiplier() * TileEntityGTDrawers.this.getEffectiveDrawerCapacity();
        }

        protected void onItemChanged() {
            DrawerPopulatedEvent event = new DrawerPopulatedEvent((IDrawer)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (TileEntityGTDrawers.this.func_145831_w() != null && !TileEntityGTDrawers.this.func_145831_w().field_72995_K) {
                TileEntityGTDrawers.this.func_70296_d();
                TileEntityGTDrawers.this.markBlockForUpdate();
            }
        }

        protected void onAmountChanged() {
            if (TileEntityGTDrawers.this.func_145831_w() != null && !TileEntityGTDrawers.this.func_145831_w().field_72995_K) {
                TileEntityGTDrawers.this.syncClientCount(this.slot, this.getStoredItemCount());
                TileEntityGTDrawers.this.func_70296_d();
            }
        }
    }

    private class GroupData
    extends StandardDrawerGroup {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Nonnull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerData(this, slot);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == DRAWER_ATTRIBUTES_CAPABILITY || super.hasCapability(capability, facing);
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == DRAWER_ATTRIBUTES_CAPABILITY) {
                return (T)TileEntityGTDrawers.this.getDrawerAttributes();
            }
            return (T)super.getCapability(capability, facing);
        }
    }

    public static class Legacy
    extends TileEntityGTDrawers {
        private GroupData groupData = new GroupData(4);

        public Legacy() {
            this.groupData.setCapabilityProvider((ICapabilityProvider)this);
            this.injectPortableData((TileDataShim)this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        protected void onAttributeChanged() {
            this.groupData.syncAttributes();
        }

        public void replaceWithCurrent() {
            TileEntityGTDrawers replacement = Legacy.createEntity(this.groupData.getDrawerCount());
            if (replacement != null) {
                replacement.deserializeNBT(this.serializeNBT());
                this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)replacement);
                replacement.func_70296_d();
            }
        }

        public void func_145829_t() {
            super.func_145829_t();
            this.func_145831_w().func_180497_b(this.func_174877_v(), (Block)ModBlocks.basicDrawers, 1, 0);
        }

        public NBTTagCompound writeToPortableNBT(NBTTagCompound tag) {
            return super.writeToPortableNBT(tag);
        }
    }
}

