/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.type;

import com.nomiceu.gregtechdrawers.block.BlockGTDrawers;
import com.nomiceu.gregtechdrawers.block.BlockGTTrim;
import com.nomiceu.gregtechdrawers.item.ItemGTDrawers;
import com.nomiceu.gregtechdrawers.item.ItemGTTrim;
import com.nomiceu.gregtechdrawers.type.Mod;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class DrawerMaterial
implements IStringSerializable {
    private Mod mod;
    private String name;
    private BlockGTDrawers drawersBlock;
    private ItemGTDrawers drawersItem;
    private BlockGTTrim trimBlock;
    private ItemGTTrim trimItem;
    public AbstractItemStack[] planks;
    public AbstractItemStack[] slabs;
    private boolean isGrass = false;

    DrawerMaterial(Mod mod, String name, AbstractItemStack[] planks, AbstractItemStack[] slabs) {
        this.mod = mod;
        this.name = name;
        this.planks = planks;
        this.slabs = slabs;
    }

    public boolean isCraftable() {
        return this.planks.length != 0 && this.slabs.length != 0;
    }

    public String func_176610_l() {
        return this.name;
    }

    public BlockGTDrawers getDrawersBlock() {
        return this.drawersBlock;
    }

    public ItemGTDrawers getDrawerItem() {
        return this.drawersItem;
    }

    public BlockGTTrim getTrimBlock() {
        return this.trimBlock;
    }

    public ItemGTTrim getTrimItem() {
        return this.trimItem;
    }

    public Iterable<Block> asBlockIterable() {
        return this::blockIterator;
    }

    public Iterable<Item> asItemIterable() {
        return this::itemIterator;
    }

    public Iterator<Block> blockIterator() {
        return this.drawersBlock == null ? DrawerMaterial.emptyIterator() : (this.trimBlock == null ? new SingleIterator<BlockGTDrawers>(this.drawersBlock) : new DoubleIterator<BlockGTTrim>((BlockGTTrim)((Object)this.drawersBlock), this.trimBlock));
    }

    public Iterator<Item> itemIterator() {
        return this.drawersItem == null ? DrawerMaterial.emptyIterator() : (this.trimItem == null ? new SingleIterator<ItemGTDrawers>(this.drawersItem) : new DoubleIterator<ItemGTTrim>((ItemGTTrim)((Object)this.drawersItem), this.trimItem));
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.EMPTY_ITERATOR;
    }

    public Mod getMod() {
        return this.mod;
    }

    public String toString() {
        return this.func_176610_l();
    }

    void init() {
        if (this.drawersBlock == null) {
            this.drawersBlock = new BlockGTDrawers(this);
            this.trimBlock = new BlockGTTrim(this);
            if (this.isGrass) {
                this.drawersBlock.setMadeOfGrass();
                this.trimBlock.setMadeOfGrass();
            }
        }
        if (this.drawersItem == null) {
            this.drawersItem = new ItemGTDrawers(this.drawersBlock);
            this.trimItem = new ItemGTTrim(this.trimBlock);
        }
    }

    public static interface AbstractItemStack {
        public ItemStack toItemStack(Mod var1);
    }

    private static class SingleIterator<T>
    implements Iterator<T> {
        private final T value;
        private boolean hasNext = true;

        SingleIterator(T value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.value;
            }
            throw new NoSuchElementException("next");
        }
    }

    private static class DoubleIterator<T>
    implements Iterator<T> {
        private final T first;
        private final T second;
        private int count = 0;

        DoubleIterator(T first, T second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean hasNext() {
            return this.count < 2;
        }

        @Override
        public T next() {
            T result;
            switch (this.count) {
                case 0: {
                    result = this.first;
                    break;
                }
                case 1: {
                    result = this.second;
                    break;
                }
                default: {
                    throw new NoSuchElementException("next");
                }
            }
            ++this.count;
            return result;
        }
    }

    private static class EmptyIterator<T>
    implements Iterator<T> {
        private static final Iterator<?> EMPTY_ITERATOR = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException("next");
        }
    }

    public static class AbstractItemStackImpl
    implements AbstractItemStack {
        private String modid;
        private String id;
        private int meta;

        AbstractItemStackImpl(String id, int meta) {
            int i = id.indexOf(58);
            if (i >= 0) {
                this.modid = id.substring(0, i);
                this.id = id.substring(i + 1);
            } else {
                this.modid = null;
                this.id = id;
            }
            this.meta = meta;
        }

        @Override
        public ItemStack toItemStack(Mod mod) {
            return new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.modid == null ? mod.modid : this.modid, this.id)), 1, this.meta);
        }

        public String toString() {
            return (this.modid == null ? "" : this.modid + ":") + this.id + (this.meta == Short.MAX_VALUE ? "(*)" : "(" + this.meta + ")");
        }

        public int hashCode() {
            return Objects.hash(this.id, this.meta, this.modid);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AbstractItemStackImpl)) {
                return false;
            }
            AbstractItemStackImpl item = (AbstractItemStackImpl)obj;
            return this.id.equals(item.id) && this.meta == item.meta && Objects.equals(this.modid, item.modid);
        }
    }

    public static class UnlimitedChiselWorksItemStack
    implements AbstractItemStack {
        private String name;
        private int meta;

        UnlimitedChiselWorksItemStack(String item, int meta) {
            this.name = item;
            this.meta = meta;
        }

        @Override
        public ItemStack toItemStack(Mod mod) {
            String modid;
            int i = this.name.indexOf(58);
            if (i < 0) {
                modid = mod.modid;
            } else {
                modid = this.name.substring(0, i);
                this.name = this.name.substring(i + 1);
            }
            return new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("unlimitedchiselworks", "chisel_planks_oak_" + modid + "_" + this.name.replaceAll("[^a-z_A-Z]", "_") + "_" + (this.meta == Short.MAX_VALUE ? 0 : this.meta))));
        }

        public String toString() {
            return "unlimitedchiselworks(" + this.name + ")";
        }

        public int hashCode() {
            return Objects.hash(this.name, this.meta);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UnlimitedChiselWorksItemStack)) {
                return false;
            }
            UnlimitedChiselWorksItemStack item = (UnlimitedChiselWorksItemStack)obj;
            return this.meta == item.meta && this.name.equals(item.name);
        }
    }

    public static class BuilderImpl
    implements Builder {
        private List<AbstractItemStack> planks = new ArrayList<AbstractItemStack>();
        private List<AbstractItemStack> slabs = new ArrayList<AbstractItemStack>();
        private final String name;
        private boolean isGrass = false;

        public BuilderImpl(String name) {
            this.name = name;
        }

        public BuilderImpl setGrassy() {
            this.isGrass = true;
            return this;
        }

        public BuilderImpl planks(String id) {
            return this.planks(id, Short.MAX_VALUE);
        }

        public BuilderImpl planks(String id, int meta) {
            this.planks.add(new AbstractItemStackImpl(id, meta));
            if (meta != Short.MAX_VALUE && Loader.isModLoaded((String)"unlimitedchiselworks")) {
                this.planks.add(new UnlimitedChiselWorksItemStack(id, meta));
            }
            return this;
        }

        public BuilderImpl slab(String id) {
            return this.slab(id, Short.MAX_VALUE);
        }

        public BuilderImpl slab(String id, int meta) {
            this.slabs.add(new AbstractItemStackImpl(id, meta));
            return this;
        }

        @Override
        public Optional<DrawerMaterial> build(Mod mod) {
            DrawerMaterial material = new DrawerMaterial(mod, this.name, this.planks.toArray(new AbstractItemStack[this.planks.size()]), this.slabs.toArray(new AbstractItemStack[this.slabs.size()]));
            material.isGrass = this.isGrass;
            return Optional.of(material);
        }
    }

    public static class MaterialReference
    implements Builder {
        private DrawerMaterial referenced;

        public MaterialReference(DrawerMaterial material) {
            this.referenced = Objects.requireNonNull(material);
        }

        @Override
        public Optional<DrawerMaterial> build(Mod mod) {
            return this.referenced.getMod().isEnabled() ? Optional.empty() : Optional.of(this.referenced);
        }
    }

    public static interface Builder {
        public Optional<DrawerMaterial> build(Mod var1);
    }
}

