/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.type;

import com.nomiceu.gregtechdrawers.type.DrawerMaterial;
import com.nomiceu.gregtechdrawers.type.StreamableIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.tuple.Pair;

public class Mod
implements StreamableIterable<DrawerMaterial> {
    static final ArrayList<Mod> internal_modlist = new ArrayList();
    public final String modid;
    private String modname;
    private final Map<String, DrawerMaterial> materials;

    public Mod(String modid, DrawerMaterial.Builder ... materialsIn) {
        this(modid, new String[0], new String[0], materialsIn);
    }

    public Mod(String[] modids, DrawerMaterial.Builder ... materialsIn) {
        this(modids[0], Mod.withoutFirstElement(modids), new String[0], materialsIn);
    }

    private static String[] withoutFirstElement(String[] array) {
        String[] result = new String[array.length - 1];
        System.arraycopy(array, 1, result, 0, result.length);
        return result;
    }

    public Mod(String modid, String[] other_modids, String[] disabled_modids, DrawerMaterial.Builder ... materialsIn) {
        this.modid = modid;
        this.materials = Collections.unmodifiableMap(Arrays.stream(materialsIn).map(builder -> builder.build(this)).filter(Optional::isPresent).map(optional -> {
            DrawerMaterial mat = (DrawerMaterial)optional.get();
            return Pair.of((Object)mat.func_176610_l(), (Object)mat);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
        internal_modlist.add(this);
    }

    public DrawerMaterial getMaterial(String name) {
        return this.materials.get(name);
    }

    @Override
    public Stream<DrawerMaterial> stream() {
        return this.materials.values().stream();
    }

    @Override
    public Stream<DrawerMaterial> parallelStream() {
        return this.materials.values().parallelStream();
    }

    public String getModName() {
        return this.modname == null ? (this.modname = Loader.instance().getModList().stream().filter(container -> container.getModId().equals(this.modid)).map(ModContainer::getName).findFirst().orElse(this.modid + " [not loaded]")) : this.modname;
    }

    public DrawerMaterial getDefaultMaterial() {
        return this.materials.isEmpty() ? null : this.materials.values().iterator().next();
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public Iterator<DrawerMaterial> iterator() {
        return this.materials.values().iterator();
    }

    public void init() {
        for (DrawerMaterial material : this.materials.values()) {
            material.init();
        }
    }

    public String toString() {
        return this.modid;
    }
}

