/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.type;

import com.nomiceu.gregtechdrawers.GTDrawers;
import com.nomiceu.gregtechdrawers.type.DrawerMaterial;
import com.nomiceu.gregtechdrawers.type.Mod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class ModListParser {
    private static final Matcher IGNORE_LINE = ModListParser.regex("^\\s*(#.*)?$");
    private static final Matcher MOD_HEADER = ModListParser.regex("^(?<modid>\\w+)(\\s*,\\s*(?<modids>\\w+(\\s*,\\s*\\w+)*))?\\s*:\\s*(!\\s*(?<disabled>\\w+(\\s*,\\s*\\w+)*)\\s*)?$");
    private static final Matcher MATERIAL_HEADER = ModListParser.regex("(?<name>\\w+)\\s*:\\s*((?<type>normal|grassy)\\s*)?$");
    private static final Matcher MATERIAL_REF = ModListParser.regex("@(?<modid>\\w+):(?<id>\\w+)\\s*$");
    private static final Matcher MATERIAL_DEF = ModListParser.regex("(?<type>planks|slab)\\s+(?<id>[.\\w]+(:[.\\w]+)?)(\\s+(?<meta>\\d+|\\*)?)?$");

    private static Matcher regex(String regex) {
        return Pattern.compile(regex).matcher("");
    }

    public static void parseModList(String fileName, Scanner scan) {
        ArrayList<Line> lines = new ArrayList<Line>(30);
        int lineNumber = 1;
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (!IGNORE_LINE.reset(line).matches()) {
                lines.add(new Line(lineNumber, line));
            }
            ++lineNumber;
        }
        HashMap modMaterials = new HashMap();
        ListIterator iter = lines.listIterator();
        while (iter.hasNext()) {
            HashSet<String> materials;
            block40: {
                Line line = (Line)iter.next();
                if (!MOD_HEADER.reset(line).matches()) {
                    throw new ModListSyntaxException(fileName, line, "invalid mod header syntax");
                }
                if (!line.indent.isEmpty()) {
                    throw new ModListSyntaxException(fileName, line, "unexpected indent");
                }
                if (!iter.hasNext()) {
                    throw new ModListSyntaxException(fileName, line, "missing material list for mod " + MOD_HEADER.group("modid"));
                }
                line = (Line)iter.next();
                if (line.indent.isEmpty()) {
                    throw new ModListSyntaxException(fileName, line, "no indented material list found after header for mod " + MOD_HEADER.group("modid"));
                }
                materials = new HashSet<String>();
                String indent = line.indent;
                do {
                    if (MATERIAL_REF.reset(line).matches()) {
                        Set otherMaterials = (Set)modMaterials.get(MATERIAL_REF.group("modid"));
                        if (otherMaterials == null) {
                            throw new ModListSyntaxException(fileName, line, "no such mod with id " + MATERIAL_REF.group("modid"));
                        }
                        if (!otherMaterials.contains(MATERIAL_REF.group("id"))) {
                            throw new ModListSyntaxException(fileName, line, "mod " + MATERIAL_REF.group("modid") + " does not define a material named " + MATERIAL_REF.group("id"));
                        }
                    } else {
                        block39: {
                            if (!MATERIAL_HEADER.reset(line).matches()) {
                                throw new ModListSyntaxException(fileName, line, "invalid material header syntax");
                            }
                            if (!iter.hasNext()) {
                                throw new ModListSyntaxException(fileName, line, "missing plank/slab list after material " + MATERIAL_HEADER.group("name") + " in mod " + MOD_HEADER.group("modid"));
                            }
                            line = (Line)iter.next();
                            String indent2 = line.indent;
                            if (!indent2.startsWith(indent) || indent2.length() == indent.length()) {
                                throw new ModListSyntaxException(fileName, line, "no indented plank/slab list found after header for material " + MATERIAL_HEADER.group("name") + " in mod " + MOD_HEADER.group("modid"));
                            }
                            do {
                                if (!MATERIAL_DEF.reset(line).matches()) {
                                    throw new ModListSyntaxException(fileName, line, "invalid plank/slab entry for material " + MATERIAL_HEADER.group("name") + " in mod " + MOD_HEADER.group("modid"));
                                }
                                if (!iter.hasNext()) break block39;
                                line = (Line)iter.next();
                            } while (line.indent.equals(indent2));
                            line = (Line)iter.previous();
                        }
                        materials.add(MATERIAL_HEADER.group("name"));
                    }
                    if (!iter.hasNext()) break block40;
                    line = (Line)iter.next();
                } while (line.indent.equals(indent));
                line = (Line)iter.previous();
            }
            modMaterials.put(MOD_HEADER.group("modid"), materials);
        }
        modMaterials.clear();
        HashMap<String, Mod> mods = new HashMap<String, Mod>();
        ListIterator iter2 = lines.listIterator();
        while (iter2.hasNext()) {
            ArrayList<DrawerMaterial.Builder> materials;
            String[] disabled_modids;
            String[] other_modids;
            String modid;
            block42: {
                Line line = (Line)iter2.next();
                MOD_HEADER.reset(line).find();
                modid = MOD_HEADER.group("modid");
                String temp = MOD_HEADER.group("modids");
                other_modids = temp == null ? new String[]{} : temp.split("\\s*,\\s*");
                temp = MOD_HEADER.group("disabled");
                disabled_modids = temp == null ? new String[]{} : temp.split("\\s*,\\s*");
                materials = new ArrayList<DrawerMaterial.Builder>();
                line = (Line)iter2.next();
                String indent = line.indent;
                do {
                    if (MATERIAL_REF.reset(line).matches()) {
                        Mod mod = (Mod)mods.get(MATERIAL_REF.group("modid"));
                        materials.add(ModListParser.reference(mod, MATERIAL_REF.group("id")));
                    } else {
                        String type;
                        DrawerMaterial.BuilderImpl material;
                        block41: {
                            MATERIAL_HEADER.reset(line).find();
                            material = ModListParser.material(MATERIAL_HEADER.group("name"));
                            line = (Line)iter2.next();
                            String indent2 = line.indent;
                            do {
                                MATERIAL_DEF.reset(line).find();
                                String id = MATERIAL_DEF.group("id");
                                temp = MATERIAL_DEF.group("meta");
                                int meta = temp == null || temp.equals("*") ? Short.MAX_VALUE : Integer.parseUnsignedInt(temp);
                                switch (MATERIAL_DEF.group("type")) {
                                    case "planks": {
                                        material.planks(id, meta);
                                        break;
                                    }
                                    case "slab": {
                                        material.slab(id, meta);
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError();
                                    }
                                }
                                if (!iter2.hasNext()) break block41;
                                line = (Line)iter2.next();
                            } while (line.indent.equals(indent2));
                            line = (Line)iter2.previous();
                        }
                        if ((type = MATERIAL_HEADER.group("type")) != null) {
                            switch (type) {
                                case "normal": {
                                    break;
                                }
                                case "grassy": {
                                    material.setGrassy();
                                    break;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                        }
                        materials.add(material);
                    }
                    if (!iter2.hasNext()) break block42;
                    line = (Line)iter2.next();
                } while (line.indent.equals(indent));
                line = (Line)iter2.previous();
            }
            mods.put(modid, new Mod(modid, other_modids, disabled_modids, materials.toArray(new DrawerMaterial.Builder[materials.size()])));
            GTDrawers.logger.info("Recognized mod " + modid);
        }
    }

    private static String getLeadingWhitespace(String str) {
        char c;
        StringBuilder b = new StringBuilder(4);
        for (int i = 0; i < str.length() && Character.isWhitespace(c = str.charAt(i)); ++i) {
            b.append(c);
        }
        return b.toString();
    }

    public static DrawerMaterial.BuilderImpl material(String name) {
        return new DrawerMaterial.BuilderImpl(name);
    }

    public static DrawerMaterial.Builder reference(Mod mod, String name) {
        return new DrawerMaterial.MaterialReference(mod.getMaterial(name));
    }

    private ModListParser() {
        throw new UnsupportedOperationException("ModListParser cannot be instantiated!");
    }

    private static class Line
    implements CharSequence {
        String indent;
        String content;
        int number;
        private int hash = 0;

        Line(int lineNumber, String line) {
            int i = line.indexOf(35);
            if (i != -1) {
                line = line.substring(0, i);
            }
            if (Character.isWhitespace(line.charAt(line.length() - 1))) {
                line = StringUtils.stripEnd((String)line, null);
            }
            this.indent = ModListParser.getLeadingWhitespace(line);
            this.content = line.substring(this.indent.length());
            this.number = lineNumber;
        }

        @Override
        public int length() {
            return this.content.length();
        }

        @Override
        public char charAt(int index) {
            return this.content.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.content.substring(start, end);
        }

        @Override
        public String toString() {
            return this.content;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Line)) {
                return false;
            }
            Line l = (Line)obj;
            return this.number == l.number && this.indent.equals(l.indent) && this.content.equals(l.content);
        }

        public int hashCode() {
            return this.hash == 0 ? (this.hash = Objects.hash(this.content, this.indent, this.number)) : this.hash;
        }
    }

    public static class ModListSyntaxException
    extends RuntimeException {
        private static final long serialVersionUID = -274200232220169644L;

        public ModListSyntaxException(String fileName, Line line, String message) {
            super("at " + fileName + ":" + line.number + ": " + message + "\n\t" + line);
        }
    }
}

