/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.type;

import com.nomiceu.gregtechdrawers.GTDrawers;
import com.nomiceu.gregtechdrawers.block.BlockGTDrawers;
import com.nomiceu.gregtechdrawers.block.BlockGTTrim;
import com.nomiceu.gregtechdrawers.item.ItemGTDrawers;
import com.nomiceu.gregtechdrawers.item.ItemGTTrim;
import com.nomiceu.gregtechdrawers.type.DrawerMaterial;
import com.nomiceu.gregtechdrawers.type.Mod;
import com.nomiceu.gregtechdrawers.type.ModListParser;
import com.nomiceu.gregtechdrawers.type.NestedIterator;
import com.nomiceu.gregtechdrawers.type.StreamableFilterableIterable;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import org.apache.commons.lang3.tuple.Pair;

public class Mods {
    public static final StreamableFilterableIterable<Mod> MODS;
    public static final StreamableFilterableIterable<Mod> ENABLED_MODS;
    private static final Map<String, Mod> BY_ID;
    public static final StreamableFilterableIterable<Block> BLOCKS;
    public static final StreamableFilterableIterable<Item> ITEMS;
    public static final StreamableFilterableIterable<BlockGTDrawers> DRAWERS_BLOCKS;
    public static final StreamableFilterableIterable<ItemGTDrawers> DRAWERS_ITEMS;
    public static final StreamableFilterableIterable<BlockGTTrim> TRIM_BLOCKS;
    public static final StreamableFilterableIterable<ItemGTTrim> TRIM_ITEMS;

    public static void init() {
        for (Mod mod : ENABLED_MODS) {
            mod.init();
        }
    }

    public static Mod fromModId(String modid) {
        return BY_ID.get(modid);
    }

    public static DrawerMaterial.BuilderImpl material(String name) {
        return new DrawerMaterial.BuilderImpl(name);
    }

    public static DrawerMaterial.Builder reference(Mod mod, String name) {
        return new DrawerMaterial.MaterialReference(mod.getMaterial(name));
    }

    private Mods() {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be instantiated");
    }

    static {
        Scanner scan0;
        try (Scanner scan = scan0 = new Scanner(GTDrawers.class.getResourceAsStream("builtin.sdmods"));){
            ModListParser.parseModList("builtin.sdmods", scan);
        }
        catch (NullPointerException e) {
            throw new Error("Missing io/github/nomiceu/builtin.sdmods in Gregtech Drawers jar file!");
        }
        if (scan0.ioException() != null) {
            throw new Error("Error reading builtin.sdmods for Gregtech Drawers.", scan0.ioException());
        }
        MODS = StreamableFilterableIterable.wrap(Mod.internal_modlist);
        ENABLED_MODS = MODS.filter(Mod::isEnabled);
        BY_ID = MODS.stream().map(mod -> Pair.of((Object)mod.modid, (Object)mod)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        BLOCKS = () -> new NestedIterator(ENABLED_MODS.stream().map(mod -> new NestedIterator(mod.stream().map(DrawerMaterial::blockIterator).iterator())).iterator());
        ITEMS = () -> new NestedIterator(ENABLED_MODS.stream().map(mod -> new NestedIterator(mod.stream().map(DrawerMaterial::itemIterator).iterator())).iterator());
        DRAWERS_BLOCKS = BLOCKS.filter(BlockGTDrawers.class);
        DRAWERS_ITEMS = ITEMS.filter(ItemGTDrawers.class);
        TRIM_BLOCKS = BLOCKS.filter(BlockGTTrim.class);
        TRIM_ITEMS = ITEMS.filter(ItemGTTrim.class);
    }
}

